/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.avia;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.RouteType;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.model.VisaRequirement;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.ibecorp.CurrencyHelper;
import com.gridnine.xtrip.common.ibecorp.common.PenaltiesResolver;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.TechStopInfo;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineAlliance;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.LuggageUnit;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.gds.PenaltiesInfo;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.PriceDisplayStyle;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.AviaPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.GeneralPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.ReservationPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.ExtApiV1CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.ExtApiV1CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.avia.ExtApiV1AviaHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.ExtApiV1Money;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.ExtApiV1Passport;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1AirlineReference;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1BestFlight;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1BestFlights;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1ConnectionsRestriction;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1Customer;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1DictionaryItem;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1DocoDocaNeededInfo;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1ExchangePenaltiesInfo;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1ExtendedLuggage;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1Flight;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1FlightItem;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1GeoLocationReference;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1GeoLocationType;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1Leg;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1MatrixFlightWithGap;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1Passenger;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1PassengerPrice;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1Price;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1RefundPenaltiesInfo;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1Reservation;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1SearchLeg;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1SearchMatrixFlightsParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1SeatDescription;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1Segment;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1ServiceStatus;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1ServicesDetails;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1ServicesStatuses;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1TechStopInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public final class ExtApiV1AviaConverterHelper {
    private static final long MILLIS_IN_DAY = 86400000L;

    public static ExtApiV1FlightItem convertFlightSearchItem2Rest(Flight flight, PriceComponentsParameters parameters, PriceDisplayStyle priceDisplayStyle, boolean displayTimeLimit) throws Exception {
        ExtApiV1FlightItem result = new ExtApiV1FlightItem();
        result.setFlight(ExtApiV1AviaConverterHelper.convertFlight2Rest(flight, parameters, null, displayTimeLimit));
        BigDecimal total = AviaHelper.getPriceByDisplayStyle(priceDisplayStyle, AviaPriceComponents.builder(flight, parameters).build(), AviaHelper.getAdultsType(flight.getSeats()));
        result.getFlight().getPrice().getTotal().setAmount((double)total.setScale(0, RoundingMode.HALF_DOWN).intValue());
        result.setFlightToken(ExtApiV1AviaConverterHelper.convertFlight2RestToken(flight));
        result.setExtendedFare(FlightHelper.getFlightSegmentsList((Flight)flight).stream().map(ExtApiV1AviaConverterHelper::convertBaseSegmentInfo2Rest).allMatch(segment -> ExtApiV1AviaConverterHelper.hasExtendedFare(segment, (EntityReference<SMSite>)parameters.getSalesContext().getSite())));
        return result;
    }

    public static void addFlightToMatrix(Flight flight, Map<String, Map<String, ExtApiV1MatrixFlightWithGap>> to, AviaPriceComponents priceComponents, Pair<LocalDate> requestedDates, PriceDisplayStyle priceDisplayStyle) {
        ExtApiV1MatrixFlightWithGap candidate = ExtApiV1AviaConverterHelper.convertMatrixFlight2Rest(flight, priceComponents, requestedDates, priceDisplayStyle);
        Map<String, ExtApiV1MatrixFlightWithGap> departuresFrom = Optional.ofNullable(to.get(candidate.getDepartureTo().toString())).orElseGet(ExtApiV1AviaConverterHelper.addMatrixDepartures(to, candidate));
        Days gapTo = Days.daysBetween((ReadablePartial)((ReadablePartial)requestedDates.getFirst()), (ReadablePartial)candidate.getDepartureTo());
        Days gapFrom = Days.ZERO;
        if (requestedDates.getLast() != null) {
            gapFrom = Days.daysBetween((ReadablePartial)((ReadablePartial)requestedDates.getLast()), (ReadablePartial)candidate.getDepartureFrom());
        }
        candidate.setGapToRequiredDates(Math.abs(gapTo.getDays()) + Math.abs(gapFrom.getDays()));
        candidate.setMaxGapToRequiredDates(Math.max(Math.abs(gapTo.getDays()), Math.abs(gapFrom.getDays())));
        departuresFrom.putIfAbsent(candidate.getDepartureFrom().toString(), candidate);
        ExtApiV1MatrixFlightWithGap cheapestByDate = departuresFrom.get(candidate.getDepartureFrom().toString());
        if (ExtApiV1CommonConverterHelper.MONEY_COMPARATOR.compare(cheapestByDate.getPrice(), candidate.getPrice()) > 0) {
            departuresFrom.put(candidate.getDepartureFrom().toString(), candidate);
        }
    }

    private static Supplier<Map<String, ExtApiV1MatrixFlightWithGap>> addMatrixDepartures(Map<String, Map<String, ExtApiV1MatrixFlightWithGap>> to, ExtApiV1MatrixFlightWithGap candidate) {
        return () -> {
            HashMap<String, ExtApiV1MatrixFlightWithGap> departures = new HashMap<String, ExtApiV1MatrixFlightWithGap>();
            departures.put(candidate.getDepartureFrom().toString(), candidate);
            to.put(candidate.getDepartureTo().toString(), departures);
            return departures;
        };
    }

    private static ExtApiV1MatrixFlightWithGap convertMatrixFlight2Rest(Flight flight, AviaPriceComponents priceComponents, Pair<LocalDate> requestedDates, PriceDisplayStyle priceDisplayStyle) {
        ExtApiV1MatrixFlightWithGap result = new ExtApiV1MatrixFlightWithGap();
        List flightLegs = FlightHelper.getFlightLegs((Flight)flight);
        result.setCarrier(flight.getCarrier());
        result.setDepartureTo(new LocalDate((Object)((FlightSegment)((List)flightLegs.get(0)).get(0)).getDateBegin()));
        result.setDepartureFrom(new LocalDate((Object)((FlightSegment)((List)flightLegs.get(flightLegs.size() - 1)).get(0)).getDateBegin()));
        result.setPrice(ExtApiV1CommonConverterHelper.convertMoney2Rest(AviaHelper.getPriceByDisplayStyle(priceDisplayStyle, priceComponents, AviaHelper.getAdultsType(flight.getSeats())), priceComponents.getCurrency()));
        Pair flightDates = new Pair((Object)result.getDepartureTo(), (Object)result.getDepartureFrom());
        if (requestedDates.equals((Object)flightDates)) {
            result.setCurrent(true);
        }
        if (result.getDepartureTo().equals(requestedDates.getFirst()) && requestedDates.getLast() == null) {
            result.setCurrent(true);
        }
        return result;
    }

    public static String convertFlight2RestToken(Flight flight) throws Exception {
        return Base64.encode((byte[])GZIPUtil.gzip((byte[])XSUtil.toString((XSSerializable)flight).getBytes(StandardCharsets.UTF_8)));
    }

    public static Flight convertRestToken2Flight(String token) throws Exception {
        Flight result = new Flight();
        try {
            XUtil.fromString((String)new String(GZIPUtil.gunzip((byte[])Base64.decode((String)token)), StandardCharsets.UTF_8), (XSerializable)result);
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)"Error converting token to flight", (Throwable)e, (Object[])new Object[0]);
        }
        return result;
    }

    public static void addFlightToBestPrices(Flight flight, Map<ExtApiV1ConnectionsRestriction, ExtApiV1BestFlights> bestFlights, GeneralPriceComponents priceComponents) {
        boolean toReplace;
        ExtApiV1ConnectionsRestriction cr = ExtApiV1AviaConverterHelper.getConnectionRestriction(flight);
        if (!bestFlights.containsKey(cr)) {
            bestFlights.put(cr, new ExtApiV1BestFlights());
        }
        ExtApiV1BestFlight candidate = ExtApiV1AviaConverterHelper.convertBestFlight2Rest(flight, priceComponents);
        List bestByConnection = bestFlights.get(cr).getBestFlights();
        boolean hasBestByConnectionAndAirline = bestByConnection.stream().anyMatch(bf -> bf.getCarrier().equals((Object)candidate.getCarrier()));
        boolean bl = toReplace = hasBestByConnectionAndAirline && bestByConnection.removeIf(bf -> bf.getCarrier().equals((Object)candidate.getCarrier()) && ExtApiV1CommonConverterHelper.MONEY_COMPARATOR.compare(bf.getPrice(), candidate.getPrice()) > 0);
        if (!hasBestByConnectionAndAirline || toReplace) {
            bestByConnection.add(candidate);
        }
    }

    private static ExtApiV1ConnectionsRestriction getConnectionRestriction(Flight flight) {
        int connectionsCount = 0;
        int legConnections = 0;
        for (FlightSegmentTariff st : flight.getSegmentTariffs()) {
            for (FlightSegment seg : st.getSegments()) {
                if (seg.isStarting()) {
                    if (legConnections > connectionsCount) {
                        connectionsCount = legConnections;
                    }
                    legConnections = 0;
                    continue;
                }
                ++legConnections;
            }
        }
        if (legConnections > connectionsCount) {
            connectionsCount = legConnections;
        }
        ExtApiV1ConnectionsRestriction result = connectionsCount == 0 ? ExtApiV1ConnectionsRestriction.DIRECT : (connectionsCount == 1 ? ExtApiV1ConnectionsRestriction.ONE_CONNECTION : ExtApiV1ConnectionsRestriction.TWO_CONNECTIONS);
        return result;
    }

    private static List<ExtApiV1Segment> convertFlightSegments2Rest(Flight flight, PriceComponentsParameters priceComponentsParameters) {
        DictionaryReference<PassengerType> mainPassengerType = ExtApiV1AviaConverterHelper.findMainPassengerType(flight);
        return FlightHelper.getFlightSegmentsStream((Flight)flight).map(fs -> ExtApiV1AviaConverterHelper.convertFlightSegment2Rest(fs, mainPassengerType, priceComponentsParameters)).collect(Collectors.toList());
    }

    private static ExtApiV1Segment convertFlightSegment2Rest(FlightSegment segment, DictionaryReference<PassengerType> mainPassengerType, PriceComponentsParameters priceComponentsParameters) {
        ExtApiV1Segment result = ExtApiV1AviaConverterHelper.convertBaseSegmentInfo2Rest(segment);
        SegmentInfo segmentInfo = new SegmentInfo(priceComponentsParameters);
        segmentInfo.setBrandedFare(ExtApiV1AviaConverterHelper.findFareInfo(segment, mainPassengerType));
        segment.getFareInfos().forEach(fi -> {
            segmentInfo.addBaseLuggageInfo((DictionaryReference<PassengerType>)fi.getPassengerType(), fi.getLuggageInfo());
            segmentInfo.addBrandedLuggageInfo((DictionaryReference<PassengerType>)fi.getPassengerType(), fi.getFareDetails());
        });
        result.setServicesDetails(ExtApiV1AviaConverterHelper.convertServicesDetails2Rest(segmentInfo));
        segment.getTechStopInfos().forEach(info -> result.getTechStopInfos().add(ExtApiV1AviaConverterHelper.convertTechStopInfosRest(info)));
        return result;
    }

    private static ExtApiV1TechStopInfo convertTechStopInfosRest(TechStopInfo techStopInfo) {
        ExtApiV1TechStopInfo result = new ExtApiV1TechStopInfo();
        result.setLocation(ExtApiV1AviaConverterHelper.getAirportWithIATACode((DictionaryReference<GeoLocation>)techStopInfo.getLocation()));
        result.setArrivalDate(techStopInfo.getArrivalDateTime());
        result.setDepartureDate(techStopInfo.getDepartureDateTime());
        result.setDuration(techStopInfo.getDuration());
        return result;
    }

    private static ExtApiV1Segment convertBaseSegmentInfo2Rest(FlightSegment segment) {
        ExtApiV1Segment result = new ExtApiV1Segment();
        result.setDepartureAirport(ExtApiV1AviaConverterHelper.getAirportWithIATACode((DictionaryReference<GeoLocation>)segment.getLocationBegin()));
        result.setDepartureCity(ExtApiV1AviaConverterHelper.getAirportCity((DictionaryReference<GeoLocation>)segment.getLocationBegin()));
        result.setArrivalAirport(ExtApiV1AviaConverterHelper.getAirportWithIATACode((DictionaryReference<GeoLocation>)segment.getLocationEnd()));
        result.setArrivalCity(ExtApiV1AviaConverterHelper.getAirportCity((DictionaryReference<GeoLocation>)segment.getLocationEnd()));
        result.setDepartureDate(LocalDateTime.ofInstant(segment.getDateBegin().toInstant(), ZoneId.systemDefault()));
        result.setArrivalDate(LocalDateTime.ofInstant(segment.getDateEnd().toInstant(), ZoneId.systemDefault()));
        result.setAirline(segment.getAirline());
        if (!segment.getAirline().getCode().equals(segment.getOperatingAirline().getCode())) {
            result.setOperatingAirline(segment.getOperatingAirline());
        }
        result.setFlightNumber(segment.getFlightNumber());
        result.setAircraft(ExtApiV1AviaConverterHelper.convertDictionaryReference2RestDictionaryItem((DictionaryReference<? extends BaseDictionary>)segment.getBoard()));
        result.setStops(segment.getStops());
        result.setTravelDuration(segment.getTravelDuration());
        result.setStarting(segment.isStarting());
        result.setClassOfService(segment.getServiceClass());
        result.setClassOfServiceCode(segment.getBookingClass());
        return result;
    }

    private static ExtApiV1ServicesDetails convertServicesDetails2Rest(SegmentInfo segmentInfo) {
        ExtApiV1ServicesDetails result = new ExtApiV1ServicesDetails();
        result.getFreeLuggage().putAll(segmentInfo.getFreeLuggageInfo());
        result.getPaidLuggage().putAll(segmentInfo.getPaidLuggageInfo());
        result.getFreeCabinLuggage().putAll(segmentInfo.getFreeCabinLuggageInfo());
        result.getPaidCabinLuggage().putAll(segmentInfo.getPaidCabinLuggageInfo());
        FareDetails fareDetails = segmentInfo.getBrandedFare();
        if (fareDetails != null) {
            result.setTariffName(GDSHelper.getDisplayBrandName((FareDetails)fareDetails, (Locale)LocaleHelper.RU_LOCALE));
            result.setExtraMileageBonus(fareDetails.getExtraMileageBonus());
            result.setClassUpgradeAvailable(fareDetails.getClassUpgradeAvailable());
            result.setBusinessLoungeAccess(fareDetails.getBusinessLoungeAccess());
            result.setPriorityBoarding(fareDetails.getPriorityBoarding());
            result.setTransferIncluded(fareDetails.getTransferIncluded());
        }
        return result;
    }

    private static FareDetails findFareInfo(FlightSegment flightSegment, DictionaryReference<PassengerType> mainPassengerType) {
        FareInfo fareInfo = flightSegment.getFareInfos().stream().filter(p -> p.getPassengerType().equals((Object)mainPassengerType)).findFirst().orElse(null);
        if (fareInfo == null) {
            fareInfo = flightSegment.getFareInfos().stream().findFirst().orElse(null);
        }
        if (fareInfo != null) {
            return fareInfo.getFareDetails();
        }
        return null;
    }

    private static String convertLuggageUnit2Rest(DictionaryReference<LuggageUnit> unitRef) {
        if (unitRef != null) {
            LuggageUnit unit = (LuggageUnit)DictionaryCache.get().resolveReference(unitRef);
            if (unit != null && !unit.getSpellVariants().isEmpty()) {
                Locale locale = LocaleHelper.getCurrentLocale();
                return (String)ExtApiV1CommonConverterHelper.findByLocale(unit.getTranslations(), locale);
            }
            return unitRef.getCode();
        }
        return null;
    }

    private static ExtApiV1Segment convertBaseSegmentInfo2Rest(Segment segment) {
        ExtApiV1Segment result = new ExtApiV1Segment();
        result.setDepartureAirport(ExtApiV1AviaConverterHelper.getAirportWithIATACode((DictionaryReference<GeoLocation>)segment.getDepartureLocation()));
        result.setDepartureCity(ExtApiV1AviaConverterHelper.getAirportCity((DictionaryReference<GeoLocation>)segment.getDepartureLocation()));
        result.setArrivalAirport(ExtApiV1AviaConverterHelper.getAirportWithIATACode((DictionaryReference<GeoLocation>)segment.getArriveLocation()));
        result.setArrivalCity(ExtApiV1AviaConverterHelper.getAirportCity((DictionaryReference<GeoLocation>)segment.getArriveLocation()));
        result.setDepartureDate(LocalDateTime.ofInstant(segment.getStartDate().toInstant(), ZoneId.systemDefault()));
        result.setArrivalDate(LocalDateTime.ofInstant(segment.getEndDate().toInstant(), ZoneId.systemDefault()));
        result.setAirline(segment.getAirline());
        if (segment.isCodeShare()) {
            result.setOperatingAirline(segment.getCodeShareCarrier());
        }
        result.setFlightNumber(segment.getFlightNo());
        result.setAircraft(ExtApiV1AviaConverterHelper.convertDictionaryReference2RestDictionaryItem((DictionaryReference<? extends BaseDictionary>)segment.getBoard()));
        result.setStops(segment.getNoOfStops().intValue());
        result.setTravelDuration(segment.getFlightDuration().intValue());
        result.setStarting(segment.isStarting());
        result.setClassOfServiceCode(segment.getClassOfSvcCode());
        return result;
    }

    private static Segment findSameSegment(Segment segment, List<Segment> segments) {
        return segments.stream().filter(s -> AviaHelper.isSameProductSegment(s, segment)).findFirst().orElse(null);
    }

    public static ExtApiV1Flight convertFlight2Rest(Flight gdsFlight, PriceComponentsParameters parameters, SMGeneralSettings generalSettings, boolean displayTimeLimit) {
        VisaRequirement vr;
        ExtApiV1Flight result = new ExtApiV1Flight();
        PenaltiesResolver penaltiesResolver = new PenaltiesResolver(gdsFlight);
        result.getExchange().putAll(Penalty2RestConverter.convertExchangeInfo(penaltiesResolver.getPenaltiesInfos(), parameters));
        result.getRefund().putAll(Penalty2RestConverter.convertRefundInfo(penaltiesResolver.getPenaltiesInfos(), parameters));
        result.getLegs().addAll(ExtApiV1AviaConverterHelper.convertLegs2Rest(ExtApiV1AviaConverterHelper.convertFlightSegments2Rest(gdsFlight, parameters)));
        result.setServicesStatuses(ExtApiV1AviaConverterHelper.convertServicesStatuses2Rest(result));
        if (generalSettings != null && displayTimeLimit) {
            result.setTimeLimit(ExtApiV1AviaConverterHelper.getCorrectTimeLimit(gdsFlight.getTimeLimit(), generalSettings));
            result.setTimeLimitCity(ExtApiV1AviaConverterHelper.getTimeLimitCity(generalSettings));
        }
        result.setCarrier(gdsFlight.getCarrier());
        result.setAirlineAlliance(((Airline)DictionaryCache.get().resolveReference(gdsFlight.getCarrier())).getAlliance());
        result.setPrice(ExtApiV1AviaConverterHelper.convertPriceComponents2Rest(AviaPriceComponents.builder(gdsFlight, parameters).build()));
        result.getSeats().addAll(ExtApiV1AviaConverterHelper.convertSeatPreferences2Rest(gdsFlight.getSeats()));
        if (!gdsFlight.getVisaRequirements().isEmpty() && ((vr = (VisaRequirement)gdsFlight.getVisaRequirements().get(0)).isDocoNeeded() || vr.isDocaNeeded())) {
            ExtApiV1DocoDocaNeededInfo info = new ExtApiV1DocoDocaNeededInfo();
            info.setCountry(vr.getCountry());
            info.setDocaNeeded(vr.isDocaNeeded());
            info.setDocoNeeded(vr.isDocoNeeded());
            result.setDocoDocaNeededInfo(info);
        }
        return result;
    }

    public static boolean isInternationalFlight(Flight flight) {
        for (FlightSegment segment : FlightHelper.getSegments((Flight)flight)) {
            if (!ExtApiV1AviaConverterHelper.isDomesticCountry((DictionaryReference<GeoLocation>)segment.getLocationBegin())) {
                return true;
            }
            if (ExtApiV1AviaConverterHelper.isDomesticCountry((DictionaryReference<GeoLocation>)segment.getLocationEnd())) continue;
            return true;
        }
        return false;
    }

    private static boolean isDomesticCountry(DictionaryReference<GeoLocation> locationRef) {
        GeoLocation location = (GeoLocation)DictionaryCache.get().resolveReference(locationRef);
        Country country = (Country)DictionaryCache.get().resolveReference(location.getCountry());
        return country.isDomestic();
    }

    private static List<ExtApiV1SeatDescription> convertSeatPreferences2Rest(List<SeatPreferences> seatPreferences) {
        return GDSHelper.seatPreferencesToMap(seatPreferences).entrySet().stream().sorted((es1, es2) -> ExtApiV1AviaConverterHelper.sortByPassengerType((DictionaryReference<PassengerType>)((DictionaryReference)es1.getKey()), (DictionaryReference<PassengerType>)((DictionaryReference)es2.getKey()))).map(ExtApiV1AviaConverterHelper::convertSeatDescription2Rest).collect(Collectors.toList());
    }

    private static ExtApiV1SeatDescription convertSeatDescription2Rest(Map.Entry<DictionaryReference<PassengerType>, Integer> e) {
        ExtApiV1SeatDescription sd = new ExtApiV1SeatDescription();
        sd.setType(e.getKey());
        sd.setCount(e.getValue().intValue());
        return sd;
    }

    private static ExtApiV1ServicesStatuses convertServicesStatuses2Rest(ExtApiV1Flight flight) {
        ExtApiV1ServicesStatuses result = new ExtApiV1ServicesStatuses();
        result.setBaggage(ExtApiV1AviaConverterHelper.getBaggageServiceStatus(flight.getLegs().stream().flatMap(l -> l.getSegments().stream()).collect(Collectors.toList())));
        result.setRefund(ExtApiV1AviaConverterHelper.getRefundServiceStatus(flight.getRefund()));
        result.setExchange(ExtApiV1AviaConverterHelper.getExchangeServiceStatus(flight.getExchange()));
        return result;
    }

    private static ExtApiV1ServicesStatuses convertServicesStatuses2Rest(ExtApiV1Reservation reservation) {
        ExtApiV1ServicesStatuses result = new ExtApiV1ServicesStatuses();
        result.setBaggage(ExtApiV1AviaConverterHelper.getBaggageServiceStatus(reservation.getLegs().stream().flatMap(l -> l.getSegments().stream()).collect(Collectors.toList())));
        result.setRefund(ExtApiV1AviaConverterHelper.getRefundServiceStatus(reservation.getRefund()));
        result.setExchange(ExtApiV1AviaConverterHelper.getExchangeServiceStatus(reservation.getExchange()));
        return result;
    }

    private static ExtApiV1ServiceStatus getRefundServiceStatus(Map<DictionaryReference<PassengerType>, ExtApiV1RefundPenaltiesInfo> refundInfo) {
        for (ExtApiV1RefundPenaltiesInfo refundPenaltiesInfo : refundInfo.values()) {
            if (refundPenaltiesInfo == null) {
                return ExtApiV1ServiceStatus.OFF;
            }
            if (!Optional.ofNullable(refundPenaltiesInfo.isRefundableBeforeDeparture()).orElse(false).booleanValue() && !Optional.ofNullable(refundPenaltiesInfo.isRefundableAfterDeparture()).orElse(false).booleanValue()) {
                return ExtApiV1ServiceStatus.OFF;
            }
            if (Optional.ofNullable(refundPenaltiesInfo.isRefundableBeforeDeparture()).orElse(false).booleanValue() && refundPenaltiesInfo.getRefundBeforeDeparture() != null && refundPenaltiesInfo.getRefundBeforeDeparture().getAmount() > 0.0) {
                return ExtApiV1ServiceStatus.PAID;
            }
            if (!Optional.ofNullable(refundPenaltiesInfo.isRefundableAfterDeparture()).orElse(false).booleanValue() || refundPenaltiesInfo.getRefundAfterDeparture() == null || !(refundPenaltiesInfo.getRefundAfterDeparture().getAmount() > 0.0)) continue;
            return ExtApiV1ServiceStatus.PAID;
        }
        return ExtApiV1ServiceStatus.FREE;
    }

    private static ExtApiV1ServiceStatus getExchangeServiceStatus(Map<DictionaryReference<PassengerType>, ExtApiV1ExchangePenaltiesInfo> refundInfo) {
        for (ExtApiV1ExchangePenaltiesInfo exchangePenaltiesInfo : refundInfo.values()) {
            if (exchangePenaltiesInfo == null) {
                return ExtApiV1ServiceStatus.OFF;
            }
            if (!Optional.ofNullable(exchangePenaltiesInfo.isExchangeableAfterDeparture()).orElse(false).booleanValue() && !Optional.ofNullable(exchangePenaltiesInfo.isExchangeableAfterDeparture()).orElse(false).booleanValue()) {
                return ExtApiV1ServiceStatus.OFF;
            }
            if (Optional.ofNullable(exchangePenaltiesInfo.isExchangeableBeforeDeparture()).orElse(false).booleanValue() && exchangePenaltiesInfo.getExchangeBeforeDeparture() != null && exchangePenaltiesInfo.getExchangeBeforeDeparture().getAmount() > 0.0) {
                return ExtApiV1ServiceStatus.PAID;
            }
            if (!Optional.ofNullable(exchangePenaltiesInfo.isExchangeableAfterDeparture()).orElse(false).booleanValue() || exchangePenaltiesInfo.getExchangeAfterDeparture() == null || !(exchangePenaltiesInfo.getExchangeAfterDeparture().getAmount() > 0.0)) continue;
            return ExtApiV1ServiceStatus.PAID;
        }
        return ExtApiV1ServiceStatus.FREE;
    }

    private static ExtApiV1ServiceStatus getBaggageServiceStatus(List<ExtApiV1Segment> segmentInfos) {
        boolean isWithoutLuggage = segmentInfos.stream().map(ExtApiV1Segment::getServicesDetails).anyMatch(sd -> {
            Collection<ExtApiV1ExtendedLuggage> luggage = sd.getFreeLuggage().values();
            return ExtApiV1AviaConverterHelper.withoutLuggage(luggage);
        });
        if (isWithoutLuggage) {
            boolean isWithoutPaidLuggage = segmentInfos.stream().map(ExtApiV1Segment::getServicesDetails).anyMatch(sd -> {
                Collection<ExtApiV1ExtendedLuggage> luggage = sd.getPaidLuggage().values();
                return ExtApiV1AviaConverterHelper.withoutLuggage(luggage);
            });
            if (isWithoutPaidLuggage) {
                return ExtApiV1ServiceStatus.PAID;
            }
            return ExtApiV1ServiceStatus.OFF;
        }
        return ExtApiV1ServiceStatus.FREE;
    }

    private static boolean withoutLuggage(Collection<ExtApiV1ExtendedLuggage> luggage) {
        return luggage.isEmpty() || luggage.stream().anyMatch(Objects::isNull) || luggage.stream().filter(Objects::nonNull).anyMatch(el -> Boolean.TRUE.equals(el.isNil()));
    }

    private static DictionaryReference<PassengerType> findMainPassengerType(Flight gdsFlight) {
        Set<DictionaryReference<PassengerType>> passengerTypes = gdsFlight.getSeats().stream().map(SeatPreferences::getPassengerType).collect(Collectors.toSet());
        return ExtApiV1AviaConverterHelper.findMainPassengerType(passengerTypes);
    }

    private static DictionaryReference<PassengerType> findMainPassengerType(Reservation reservation) {
        Set<DictionaryReference<PassengerType>> passengerTypes = AirProductHelper.getAirProductsStream((Reservation)reservation).map(Product::getPassengerType).collect(Collectors.toSet());
        return ExtApiV1AviaConverterHelper.findMainPassengerType(passengerTypes);
    }

    private static DictionaryReference<PassengerType> findMainPassengerType(Set<DictionaryReference<PassengerType>> passengerTypes) {
        if (passengerTypes.contains(DictHelper.getAdultPassengerType())) {
            return DictHelper.getAdultPassengerType();
        }
        if (passengerTypes.contains(((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.YOUTH)).toReference())) {
            return ((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.YOUTH)).toReference();
        }
        if (passengerTypes.contains(((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.SENIOR)).toReference())) {
            return ((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.SENIOR)).toReference();
        }
        return (DictionaryReference)passengerTypes.stream().findFirst().get();
    }

    private static List<ExtApiV1Leg> convertLegs2Rest(List<ExtApiV1Segment> segmentStream) {
        ArrayList<ExtApiV1Leg> result = new ArrayList<ExtApiV1Leg>();
        segmentStream.forEach(segment -> {
            if (segment.isStarting()) {
                result.add(new ExtApiV1Leg());
            }
            ExtApiV1Leg currentLeg = (ExtApiV1Leg)result.get(result.size() - 1);
            if (!segment.isStarting()) {
                ExtApiV1Segment prevSegment = (ExtApiV1Segment)currentLeg.getSegments().get(currentLeg.getSegments().size() - 1);
                currentLeg.setDuration(currentLeg.getDuration() + (int)ChronoUnit.MINUTES.between(prevSegment.getArrivalDate(), segment.getDepartureDate()));
            }
            currentLeg.getSegments().add(segment);
            currentLeg.setDuration(currentLeg.getDuration() + segment.getTravelDuration());
        });
        return result;
    }

    public static ExtApiV1Reservation convertReservation2Rest(Reservation reservation, PriceComponentsParameters priceComponentsParameters, SMGeneralSettings generalSettings) {
        VisaRequirement vr;
        ExtApiV1Reservation result = new ExtApiV1Reservation();
        PenaltiesResolver penaltiesResolver = new PenaltiesResolver(reservation);
        result.getExchange().putAll(Penalty2RestConverter.convertExchangeInfo(penaltiesResolver.getPenaltiesInfos(), priceComponentsParameters));
        result.getRefund().putAll(Penalty2RestConverter.convertRefundInfo(penaltiesResolver.getPenaltiesInfos(), priceComponentsParameters));
        result.getLegs().addAll(ExtApiV1AviaConverterHelper.convertLegs2Rest(ExtApiV1AviaConverterHelper.convertReservationSegments2Rest(reservation, priceComponentsParameters)));
        result.setServicesStatuses(ExtApiV1AviaConverterHelper.convertServicesStatuses2Rest(result));
        result.getPassengers().addAll(AirProductHelper.getAirProductsStream((Reservation)reservation).map(ExtApiV1AviaConverterHelper::convertTraveller2Rest).sorted((p1, p2) -> ExtApiV1AviaConverterHelper.sortByPassengerType((DictionaryReference<PassengerType>)p1.getType(), (DictionaryReference<PassengerType>)p2.getType())).collect(Collectors.toList()));
        result.setCustomer(ExtApiV1AviaConverterHelper.convertCustomer2Rest(reservation.getBookingFile().getCustomer()));
        ReservationStatus status = CommonIbecorpHelper.getReservationStatus((Reservation)reservation);
        if (Arrays.asList(ReservationStatus.BOOKING, ReservationStatus.ERROR).contains(status)) {
            result.setTimeLimit(ExtApiV1AviaConverterHelper.getCorrectTimeLimit(reservation.getTimeLimit(), generalSettings));
            result.setTimeLimitCity(ExtApiV1AviaConverterHelper.getTimeLimitCity(generalSettings));
        }
        result.setCarrier(ExtApiV1AviaConverterHelper.findMainProduct(reservation, ExtApiV1AviaConverterHelper.findMainPassengerType(reservation)).getCarrier());
        try {
            result.setAirlineAlliance(((Airline)DictionaryCache.get().resolveReference(ExtApiV1AviaConverterHelper.findMainProduct(reservation, ExtApiV1AviaConverterHelper.findMainPassengerType(reservation)).getCarrier())).getAlliance());
        }
        catch (NullPointerException e) {
            result.setAirlineAlliance(null);
        }
        result.setPrice(ExtApiV1AviaConverterHelper.convertPriceComponents2Rest(ReservationPriceComponents.builder(reservation, priceComponentsParameters).build()));
        result.setRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation));
        if (!reservation.getVisaRequirements().isEmpty() && ((vr = (VisaRequirement)reservation.getVisaRequirements().get(0)).isDocaNeeded() && !vr.isDocaSent() || vr.isDocoNeeded() && !vr.isDocoSent())) {
            ExtApiV1DocoDocaNeededInfo info = new ExtApiV1DocoDocaNeededInfo();
            info.setCountry(vr.getCountry());
            info.setDocaNeeded(vr.isDocaNeeded());
            info.setDocoNeeded(vr.isDocoNeeded());
            result.setDocoDocaNeededInfo(info);
        }
        return result;
    }

    private static List<ExtApiV1Segment> convertReservationSegments2Rest(Reservation reservation, PriceComponentsParameters priceComponentsParameters) {
        ArrayList<ExtApiV1Segment> result = new ArrayList<ExtApiV1Segment>(10);
        DictionaryReference<PassengerType> mainPassengerType = ExtApiV1AviaConverterHelper.findMainPassengerType(reservation);
        List<Product> mainProducts = ExtApiV1AviaConverterHelper.findMainProducts(reservation, mainPassengerType);
        List products = AirProductHelper.getAirProductsList((Reservation)reservation);
        boolean hasSeveralProductsPerTraveller = false;
        for (Segment segment : mainProducts.stream().flatMap(p -> AirProductHelper.getProductSegmentsList((Product)p).stream()).collect(Collectors.toList())) {
            ExtApiV1Segment segmentResult = ExtApiV1AviaConverterHelper.convertBaseSegmentInfo2Rest(segment);
            segmentResult.setClassOfService(DictHelper.findClassOfService((Segment)segment, (Date)mainProducts.get(0).getIssueDate()));
            SegmentInfo segmentInfo = new SegmentInfo(priceComponentsParameters);
            segmentInfo.setBrandedFare(segment.getFareDetails());
            for (Product p2 : products) {
                Segment sameSegment = ExtApiV1AviaConverterHelper.findSameSegment(segment, AirProductHelper.getProductSegmentsList((Product)p2));
                if (sameSegment != null) {
                    segmentInfo.addBaseLuggageInfo((DictionaryReference<PassengerType>)p2.getPassengerType(), sameSegment.getLuggageInfo());
                    segmentInfo.addBrandedLuggageInfo((DictionaryReference<PassengerType>)p2.getPassengerType(), sameSegment.getFareDetails());
                    continue;
                }
                hasSeveralProductsPerTraveller = true;
            }
            segmentResult.setServicesDetails(ExtApiV1AviaConverterHelper.convertServicesDetails2Rest(segmentInfo));
            result.add(segmentResult);
        }
        return hasSeveralProductsPerTraveller ? ExtApiV1AviaConverterHelper.sortSegmentsByDepartureDate(result) : result;
    }

    private static List<ExtApiV1Segment> sortSegmentsByDepartureDate(List<ExtApiV1Segment> segments) {
        return segments.stream().sorted((s1, s2) -> {
            DictionaryReference geolocationRef1 = DictHelper.getAirport((String)s1.getDepartureAirport().getUid(), (CodeSystem)CodeSystem.IATA);
            DictionaryReference geolocationRef2 = DictHelper.getAirport((String)s2.getDepartureAirport().getUid(), (CodeSystem)CodeSystem.IATA);
            return s1.getDepartureDate().atZone(ZoneId.systemDefault()).withZoneSameLocal(DictHelper.getZoneId((DictionaryReference)geolocationRef1)).isAfter(s2.getDepartureDate().atZone(ZoneId.systemDefault()).withZoneSameLocal(DictHelper.getZoneId((DictionaryReference)geolocationRef2))) ? 1 : -1;
        }).collect(Collectors.toList());
    }

    private static Product findMainProduct(Reservation reservation, DictionaryReference<PassengerType> mainPassengerType) {
        return AirProductHelper.getAirProductsStream((Reservation)reservation).filter(p -> p.getPassengerType().equals((Object)mainPassengerType)).findFirst().get();
    }

    private static List<Product> findMainProducts(Reservation reservation, DictionaryReference<PassengerType> mainPassengerType) {
        return AirProductHelper.getAirProductsStream((Reservation)reservation).filter(p -> p.getPassengerType().equals((Object)mainPassengerType)).collect(Collectors.toList());
    }

    public static LocalDateTime getCorrectTimeLimit(Date timeLimit, SMGeneralSettings generalSettings) {
        if (timeLimit == null) {
            return null;
        }
        return LocalDateTime.ofInstant(timeLimit.toInstant(), CommonHelper.getTimeZone(generalSettings).getTimeZone().toZoneId()).minusMinutes(15L);
    }

    public static String getTimeLimitCity(SMGeneralSettings generalSettings) {
        return CommonHelper.getTimeZone(generalSettings).getTimeZoneCity().toString(LocaleManager.get().getCurrentLocale());
    }

    private static ExtApiV1Price convertPriceComponents2Rest(GeneralPriceComponents priceComponents) {
        String currency = priceComponents.getCurrency();
        ExtApiV1Price result = new ExtApiV1Price();
        result.setTotal(ExtApiV1CommonConverterHelper.convertMoney2Rest(priceComponents.getTotal(), currency));
        result.setTotalFeeAndTaxes(ExtApiV1CommonConverterHelper.convertMoney2Rest(MiscUtil.sum((BigDecimal[])new BigDecimal[]{priceComponents.getFee(), priceComponents.getTaxes()}), currency));
        if (priceComponents.getParameters().getDisplayCurrencies() != null && !priceComponents.getParameters().getDisplayCurrencies().isEmpty()) {
            result.getRates().addAll(ExtApiV1CommonConverterHelper.convertRatesToRest(priceComponents.getRates()));
        }
        if (priceComponents.getParameters().isCalculateSubagentPrice()) {
            result.setTotalSubagent(ExtApiV1CommonConverterHelper.convertMoney2Rest(priceComponents.getTotalSubagent(), priceComponents.getSubagentCurrency()));
        }
        result.getPassengerPrices().addAll(priceComponents.getPassengers().entrySet().stream().map(ExtApiV1AviaConverterHelper.convertPassengerPriceInfo2Rest(priceComponents, currency)).sorted((pp1, pp2) -> ExtApiV1AviaConverterHelper.sortByPassengerType((DictionaryReference<PassengerType>)pp1.getPassengerType(), (DictionaryReference<PassengerType>)pp2.getPassengerType())).collect(Collectors.toList()));
        return result;
    }

    private static Function<Map.Entry<DictionaryReference<PassengerType>, Integer>, ExtApiV1PassengerPrice> convertPassengerPriceInfo2Rest(GeneralPriceComponents priceComponents, String currency) {
        return passengersInfo -> {
            ExtApiV1PassengerPrice pp = new ExtApiV1PassengerPrice();
            DictionaryReference passengerType = (DictionaryReference)passengersInfo.getKey();
            pp.setPassengerType(passengerType);
            pp.setPassengerCount(((Integer)passengersInfo.getValue()).intValue());
            pp.setSinglePassengerTotal(ExtApiV1CommonConverterHelper.convertMoney2Rest(priceComponents.getSinglePassengerTotal((DictionaryReference<PassengerType>)passengerType), currency));
            pp.setTotal(ExtApiV1CommonConverterHelper.convertMoney2Rest(priceComponents.getTotal((DictionaryReference<PassengerType>)passengerType), currency));
            BigDecimal tariff = priceComponents.getTariff((DictionaryReference<PassengerType>)passengerType);
            BigDecimal feeAndTaxes = MiscUtil.sum((BigDecimal[])new BigDecimal[]{priceComponents.getTaxes((DictionaryReference<PassengerType>)passengerType), priceComponents.getFee((DictionaryReference<PassengerType>)passengerType)});
            switch (priceComponents.getPriceDetailDisplay()) {
                case DETAILED: {
                    pp.setTariff(ExtApiV1CommonConverterHelper.convertMoney2Rest(tariff, currency));
                    pp.setTaxes(ExtApiV1CommonConverterHelper.convertMoney2Rest(priceComponents.getTaxes((DictionaryReference<PassengerType>)passengerType), currency));
                    pp.setFee(ExtApiV1CommonConverterHelper.convertMoney2Rest(priceComponents.getFee((DictionaryReference<PassengerType>)passengerType), currency));
                    break;
                }
                case DETAILED_WITH_FEES_IN_TAXES: {
                    pp.setTariff(ExtApiV1CommonConverterHelper.convertMoney2Rest(tariff, currency));
                    pp.setFeeAndTaxes(ExtApiV1CommonConverterHelper.convertMoney2Rest(feeAndTaxes, currency));
                    break;
                }
                case TOTAL_ONLY: {
                    pp.setTariff(ExtApiV1CommonConverterHelper.convertMoney2Rest(MiscUtil.sum((BigDecimal[])new BigDecimal[]{tariff, feeAndTaxes}), currency));
                }
            }
            return pp;
        };
    }

    private static ExtApiV1BestFlight convertBestFlight2Rest(Flight flight, GeneralPriceComponents priceComponents) {
        ExtApiV1BestFlight result = new ExtApiV1BestFlight();
        result.setCarrier(flight.getCarrier());
        result.setPrice(ExtApiV1CommonConverterHelper.convertMoney2Rest(priceComponents.getTotal(), priceComponents.getCurrency()));
        return result;
    }

    private static DictionaryReference<GeoLocation> getGeoLocationDictReferenceByCode(String code) {
        return DictHelper.toReference((BaseDictionary)DictionaryCache.get().lookup(GeoLocation.class, code, new String[0]).stream().findFirst().orElse(null));
    }

    public static void populateSegment(Date minimumDate, ExtApiV1SearchLeg fl, RouteSegment seg) {
        seg.setLocationBegin(fl.getDeparture());
        seg.setLocationEnd(fl.getArrival());
        ExtApiV1AviaConverterHelper.setDate(minimumDate, fl, seg);
        ExtApiV1AviaConverterHelper.setTimeOfDate(fl, seg);
    }

    private static void setDate(Date minimumDate, ExtApiV1SearchLeg fl, RouteSegment seg) {
        if (Objects.nonNull(minimumDate) && minimumDate.after(fl.getDate().toDate())) {
            seg.setDate(minimumDate);
        } else {
            seg.setDate(fl.getDate().toDate());
        }
    }

    private static void setTimeOfDate(ExtApiV1SearchLeg fl, RouteSegment seg) {
        int timeBegin = 0;
        int timeEnd = 1439;
        if (fl.getDepartureTimeWindowStart() != null) {
            LocalTime localTimeBegin = fl.getDepartureTimeWindowStart();
            timeBegin = localTimeBegin.getHour() * 60 + localTimeBegin.getMinute();
        }
        if (fl.getDepartureTimeWindowEnd() != null) {
            LocalTime localTimeEnd = fl.getDepartureTimeWindowEnd();
            timeEnd = localTimeEnd.getHour() * 60 + localTimeEnd.getMinute();
        }
        seg.setDepartureTimeBegin(Integer.valueOf(timeBegin));
        seg.setDepartureTimeEnd(Integer.valueOf(timeEnd));
    }

    public static Date getMinimumDate(EntityReference<SMSite> siteRef) {
        try {
            long numDaysFromToday = CommonHelper.getGeneralSettings(siteRef).getCalendarSettings().getDaysShift();
            return new Date(System.currentTimeMillis() + numDaysFromToday * 86400000L);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Pair<LocalDate> getRequestedMatrixDates(ExtApiV1SearchMatrixFlightsParameters parameters) {
        LocalDate to = ((ExtApiV1SearchLeg)parameters.getFlightLegs().get(0)).getDate();
        LocalDate from = parameters.getRouteType() == RouteType.ROUNDTRIP ? ((ExtApiV1SearchLeg)parameters.getFlightLegs().get(parameters.getFlightLegs().size() - 1)).getDate() : null;
        return new Pair((Object)to, from);
    }

    public static void setCheapestFlight(Map<String, Map<String, ExtApiV1MatrixFlightWithGap>> to, byte cheapestItemsNumber) {
        List<ExtApiV1MatrixFlightWithGap> cheapestFlights = to.values().stream().map(Map::values).flatMap(Collection::stream).sorted((matrixFlight1, matrixFlight2) -> {
            int priceComparisionResult = ExtApiV1CommonConverterHelper.MONEY_COMPARATOR.compare(matrixFlight1.getPrice(), matrixFlight2.getPrice());
            if (priceComparisionResult != 0) {
                return priceComparisionResult;
            }
            if (matrixFlight1.getGapToRequiredDates() > matrixFlight2.getGapToRequiredDates()) {
                return 1;
            }
            if (matrixFlight1.getGapToRequiredDates() < matrixFlight2.getGapToRequiredDates()) {
                return -1;
            }
            if (matrixFlight1.getMaxGapToRequiredDates() > matrixFlight2.getMaxGapToRequiredDates()) {
                return 1;
            }
            if (matrixFlight1.getMaxGapToRequiredDates() < matrixFlight2.getMaxGapToRequiredDates()) {
                return -1;
            }
            return 0;
        }).limit(cheapestItemsNumber).collect(Collectors.toList());
        if (cheapestFlights.size() > 0) {
            ExtApiV1MatrixFlightWithGap firstCheapestFlight = (ExtApiV1MatrixFlightWithGap)cheapestFlights.get(0);
            if (firstCheapestFlight.isCurrent()) {
                firstCheapestFlight.setCheapest(true);
                return;
            }
            cheapestFlights.forEach(matrixFlight -> matrixFlight.setCheapest(true));
        }
    }

    public static Traveller convertRest2Traveler(ExtApiV1Passenger passenger, Flight gdsFlight) {
        Traveller result = new Traveller();
        result.setPassport(ExtApiV1AviaConverterHelper.convertRest2Passport(passenger.getPassport(), gdsFlight));
        result.setName(TextUtil.buildFullName((PersonalName)result.getPassport()));
        result.getCommunications().addAll(ExtApiV1AviaConverterHelper.convertRest2ContactCommunications(passenger));
        if (ExtApiV1CommonValidationHelper.hasBonusCard(passenger.getBonusCard())) {
            result.getAirlineBonusCards().add(ExtApiV1CommonConverterHelper.convertRest2BonusCard(passenger.getBonusCard()));
        }
        if (passenger.getDocoInfo() != null) {
            result.getDocoInformations().add(ExtApiV1CommonConverterHelper.convertRest2DocoInformation(passenger.getDocoInfo()));
        }
        if (passenger.getDocaInfo() != null) {
            result.getDocaInformations().add(ExtApiV1CommonConverterHelper.convertRest2DocaInformation(passenger.getDocaInfo()));
        }
        return result;
    }

    private static ExtApiV1Passenger convertTraveller2Rest(Product product) {
        ExtApiV1Passenger result = new ExtApiV1Passenger();
        result.setType(product.getPassengerType());
        Traveller traveller = product.getTraveller();
        result.setUid(traveller.getUid());
        result.setPassport(ExtApiV1AviaConverterHelper.convertPassport2Rest(traveller.getPassport()));
        if (DictHelper.isAdultPassengerType((DictionaryReference)result.getType()) || DictHelper.isYouthPassengerType((DictionaryReference)result.getType()) || DictHelper.isSeniorPassengerType((DictionaryReference)result.getType())) {
            result.setEmail(ExtApiV1CommonConverterHelper.convertEmailCommunication2Rest((Communication)CommonHelper.getEmail(traveller.getCommunications()).get()));
            result.setPhone(ExtApiV1CommonConverterHelper.convertPhoneCommunication2Rest(CommonHelper.getPhone(traveller.getCommunications(), CommunicationType.WORK_PHONE).orElse(null)));
        }
        return result;
    }

    public static Customer convertRest2Customer(ExtApiV1Customer customer) {
        Customer result = new Customer();
        result.setName(customer.getFirstName().concat("-").concat(customer.getLastName()));
        Passport passport = new Passport();
        passport.setFirstName(customer.getFirstName());
        passport.setLastName(customer.getLastName());
        result.setPassport(passport);
        result.getCommunications().add(ExtApiV1CommonConverterHelper.convertRest2EmailCommunication(customer.getEmail(), Communication::new));
        result.getCommunications().add(ExtApiV1CommonConverterHelper.convertRest2PhoneCommunication(customer.getPhone(), CommunicationType.MOBILE, Communication::new));
        return result;
    }

    private static ExtApiV1Customer convertCustomer2Rest(Customer customer) {
        ExtApiV1Customer result = new ExtApiV1Customer();
        result.setFirstName(customer.getPassport().getFirstName());
        result.setLastName(customer.getPassport().getLastName());
        result.setEmail(ExtApiV1CommonConverterHelper.convertEmailCommunication2Rest((Communication)CommonHelper.getEmail(customer.getCommunications()).get()));
        result.setPhone(ExtApiV1CommonConverterHelper.convertPhoneCommunication2Rest((Communication)CommonHelper.getPhone(customer.getCommunications(), CommunicationType.MOBILE).get()));
        return result;
    }

    private static List<Communication> convertRest2ContactCommunications(ExtApiV1Passenger passenger) {
        ArrayList<Communication> result = new ArrayList<Communication>(5);
        if (AviaHelper.hasEmail((DictionaryReference<PassengerType>)passenger.getType()) && TextUtil.nonBlank((String)passenger.getEmail())) {
            result.add(ExtApiV1CommonConverterHelper.convertRest2EmailCommunication(passenger.getEmail(), Communication::new));
        }
        if (!(passenger.getPhone() == null || TextUtil.isBlank((String)passenger.getPhone().getCityCode()) || TextUtil.isBlank((String)passenger.getPhone().getCountryCode()) || TextUtil.isBlank((String)passenger.getPhone().getNumber()))) {
            result.add(ExtApiV1CommonConverterHelper.convertRest2PhoneCommunication(passenger.getPhone(), CommunicationType.MOBILE, Communication::new));
        }
        return result;
    }

    private static Passport convertRest2Passport(ExtApiV1Passport passport, Flight gdsFlight) {
        Passport result = new Passport();
        result.setGender(passport.getGender());
        result.setFirstName(ExtApiV1AviaConverterHelper.convertPassportName(passport.getFirstName()));
        result.setSecondName(ExtApiV1AviaConverterHelper.convertPassportName(passport.getSecondName()));
        result.setLastName(ExtApiV1AviaConverterHelper.convertPassportName(passport.getLastName()));
        if (!passport.isWithoutMiddleName()) {
            result.setMiddleName(ExtApiV1AviaConverterHelper.convertPassportName(passport.getMiddleName()));
        }
        result.setBirthday(passport.getBirthDate().toDate());
        result.setCitizenship(passport.getCitizenship());
        result.setOriginCountry(passport.getOriginCountry());
        result.setType(ExtApiV1AviaConverterHelper.convertPassportType(passport, gdsFlight));
        result.setExpired(ExtApiV1AviaHelper.isCalculateExpiredDate(passport, gdsFlight) ? ExtApiV1CommonValidationHelper.calculateExpiredDate(passport).toDate() : passport.getExpiredDate().toDate());
        result.setNumber(ExtApiV1AviaConverterHelper.convertPassportNumber(passport.getNumber(), gdsFlight.getGds(), result.getType()));
        return result;
    }

    public static Passport convertRest2PassportForRules(ExtApiV1Passport passport, Flight gdsFlight) {
        Passport result = new Passport();
        result.setCitizenship(passport.getCitizenship());
        result.setType(ExtApiV1AviaConverterHelper.convertPassportType(passport, gdsFlight));
        return result;
    }

    private static ExtApiV1Passport convertPassport2Rest(Passport passport) {
        ExtApiV1Passport result = new ExtApiV1Passport();
        result.setGender(passport.getGender());
        result.setFirstName(passport.getFirstName());
        result.setMiddleName(passport.getMiddleName());
        result.setLastName(passport.getLastName());
        result.setBirthDate(new LocalDate((Object)passport.getBirthday()));
        result.setType(passport.getType());
        result.setNumber(passport.getNumber());
        result.setCitizenship(passport.getCitizenship());
        result.setExpiredDate(new LocalDate((Object)passport.getExpired()));
        result.setOriginCountry(passport.getOriginCountry());
        return result;
    }

    private static String convertPassportName(String name) {
        return !TextUtil.isBlank((String)name) ? name.toUpperCase().trim() : null;
    }

    private static PassportType convertPassportType(ExtApiV1Passport passport, Flight gdsFlight) {
        if (ExtApiV1AviaHelper.isInternalNoDomesticPassport(passport, gdsFlight)) {
            return PassportType.PASSPORT;
        }
        if (ExtApiV1AviaHelper.isForeignNoDomesticPassport(passport, gdsFlight)) {
            return PassportType.FOREIGN_NATIONAL_PASSPORT;
        }
        return passport.getType();
    }

    private static String convertPassportNumber(String number, GdsName gdsName, PassportType passportType) {
        if (ExtApiV1AviaHelper.isSirenaBirthDateNotification(gdsName, passportType)) {
            return number.replaceAll(" ", "");
        }
        StringBuilder result = new StringBuilder();
        number.chars().forEach(ch -> result.append(ExtApiV1AviaConverterHelper.mapCharacter(ch, passportType == PassportType.BIRTHDAY_NOTIFICATION)));
        return result.toString();
    }

    private static String mapCharacter(int ch, boolean isBirthDateNotification) {
        if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || isBirthDateNotification && ch == 32) {
            return Character.valueOf((char)ch).toString();
        }
        if (isBirthDateNotification) {
            switch (ch) {
                case 1040: 
                case 1072: {
                    return "A";
                }
                case 1041: 
                case 1073: {
                    return "B";
                }
                case 1042: 
                case 1074: {
                    return "V";
                }
                case 1043: 
                case 1075: {
                    return "G";
                }
                case 1044: 
                case 1076: {
                    return "D";
                }
                case 1045: 
                case 1077: {
                    return "E";
                }
                case 1025: 
                case 1105: {
                    return "YO";
                }
                case 1046: 
                case 1078: {
                    return "ZH";
                }
                case 1047: 
                case 1079: {
                    return "Z";
                }
                case 1048: 
                case 1080: {
                    return "I";
                }
                case 1049: 
                case 1081: {
                    return "J";
                }
                case 1050: 
                case 1082: {
                    return "K";
                }
                case 1051: 
                case 1083: {
                    return "L";
                }
                case 1052: 
                case 1084: {
                    return "M";
                }
                case 1053: 
                case 1085: {
                    return "H";
                }
                case 1054: 
                case 1086: {
                    return "O";
                }
                case 1055: 
                case 1087: {
                    return "P";
                }
                case 1056: 
                case 1088: {
                    return "R";
                }
                case 1057: 
                case 1089: {
                    return "S";
                }
                case 1058: 
                case 1090: {
                    return "T";
                }
                case 1059: 
                case 1091: {
                    return "Y";
                }
                case 1060: 
                case 1092: {
                    return "F";
                }
                case 1061: 
                case 1093: {
                    return "X";
                }
                case 1062: 
                case 1094: {
                    return "C";
                }
                case 1063: 
                case 1095: {
                    return "CH";
                }
                case 1064: 
                case 1096: {
                    return "SH";
                }
                case 1065: 
                case 1097: {
                    return "SHH";
                }
                case 1066: 
                case 1098: {
                    return "";
                }
                case 1067: 
                case 1099: {
                    return "Y";
                }
                case 1068: 
                case 1100: {
                    return "";
                }
                case 1069: 
                case 1101: {
                    return "JE";
                }
                case 1070: 
                case 1102: {
                    return "JU";
                }
                case 1071: 
                case 1103: {
                    return "YA";
                }
            }
        } else {
            switch (ch) {
                case 1040: 
                case 1072: {
                    return Character.valueOf('A').toString();
                }
                case 1042: 
                case 1074: {
                    return Character.valueOf('B').toString();
                }
                case 1045: 
                case 1077: {
                    return Character.valueOf('E').toString();
                }
                case 1030: 
                case 1110: {
                    return Character.valueOf('I').toString();
                }
                case 1050: 
                case 1082: {
                    return Character.valueOf('K').toString();
                }
                case 1052: 
                case 1084: {
                    return Character.valueOf('M').toString();
                }
                case 1053: 
                case 1085: {
                    return Character.valueOf('H').toString();
                }
                case 1054: 
                case 1086: {
                    return Character.valueOf('O').toString();
                }
                case 1058: 
                case 1090: {
                    return Character.valueOf('T').toString();
                }
                case 1056: 
                case 1088: {
                    return Character.valueOf('P').toString();
                }
                case 1061: 
                case 1093: {
                    return Character.valueOf('X').toString();
                }
                case 1057: 
                case 1089: {
                    return Character.valueOf('C').toString();
                }
                case 1048: 
                case 1080: {
                    return Character.valueOf('U').toString();
                }
                case 1059: 
                case 1091: {
                    return Character.valueOf('Y').toString();
                }
            }
            return "";
        }
        return "";
    }

    private static boolean hasExtendedFare(ExtApiV1Segment segment, EntityReference<SMSite> siteRef) {
        return CommonHelper.getStep2Settings(siteRef).getExtendedTariffAirlines().contains(segment.getAirline().getCode());
    }

    public static ExtApiV1GeoLocationReference convertGeoLocationReference2Rest(GeoLocation location, Locale locale) {
        ExtApiV1GeoLocationReference result = new ExtApiV1GeoLocationReference();
        result.setCode(location.getCode());
        result.setUid(location.getCode());
        result.setIataCode((String)location.getCodeVariants().get(CodeSystem.IATA.name()));
        result.setCrtCode((String)location.getCodeVariants().get(CodeSystem.CRT.name()));
        if (location.getType() == LocationType.CITY) {
            result.setCityCaption((String)ExtApiV1CommonConverterHelper.findByLocale(location.getTranslations(), locale));
            result.setCountryCaption((String)ExtApiV1CommonConverterHelper.findByLocale(((Country)DictionaryCache.get().resolveReference(location.getCountry())).getTranslations(), locale));
            result.setType(ExtApiV1GeoLocationType.CITY);
        } else if (location.getType() == LocationType.AIRPORT) {
            GeoLocation city = (GeoLocation)DictionaryCache.get().resolveReference(location.getParent());
            result.setAirportCaption((String)ExtApiV1CommonConverterHelper.findByLocale(location.getTranslations(), locale));
            result.setCityCaption((String)ExtApiV1CommonConverterHelper.findByLocale(city.getTranslations(), locale));
            result.setCountryCaption((String)ExtApiV1CommonConverterHelper.findByLocale(((Country)DictionaryCache.get().resolveReference(city.getCountry())).getTranslations(), locale));
            result.setType(ExtApiV1GeoLocationType.AIRPORT);
        } else {
            throw new IllegalArgumentException("unexpected location type " + location.getType());
        }
        return result;
    }

    public static ExtApiV1AirlineReference convertAirlineReference2Rest(Airline airline, Locale locale) {
        AirlineAlliance alliance;
        Country country;
        ExtApiV1AirlineReference result = new ExtApiV1AirlineReference();
        result.setCode(airline.getCode());
        result.setUid(airline.getCode());
        result.setNumber(airline.getAirlineNumber());
        result.setAirportCaption((String)ExtApiV1CommonConverterHelper.findByLocale(airline.getTranslations(), locale));
        if (airline.getCountry() != null && (country = (Country)DictionaryCache.get().resolveReference(airline.getCountry())) != null) {
            result.setCountryCaption((String)ExtApiV1CommonConverterHelper.findByLocale(country.getTranslations(), locale));
        }
        if (airline.getAlliance() != null && (alliance = (AirlineAlliance)DictionaryCache.get().resolveReference(airline.getAlliance())) != null) {
            result.setAlliance((String)ExtApiV1CommonConverterHelper.findByLocale(alliance.getTranslations(), locale));
        }
        StringBuilder searchString = new StringBuilder();
        airline.getTranslations().forEach((key, value) -> searchString.append((String)value).append(" "));
        result.setSearchString(searchString.toString());
        return result;
    }

    public static ExtApiV1DictionaryItem getAirportWithIATACode(DictionaryReference<GeoLocation> airport) {
        ExtApiV1DictionaryItem result = ExtApiV1AviaConverterHelper.convertDictionaryReference2RestDictionaryItem(airport);
        GeoLocation airportLocation = (GeoLocation)DictionaryCache.get().resolveReference(airport);
        if (airportLocation == null || airportLocation.getCodeVariants() == null) {
            return result;
        }
        String code = (String)airportLocation.getCodeVariants().get(CodeSystem.IATA.name());
        if (StringUtils.isEmpty((String)code)) {
            code = (String)airportLocation.getCodeVariants().get(CodeSystem.CRT.name());
        }
        if (StringUtils.isEmpty((String)code)) {
            return result;
        }
        result.setUid(code);
        result.setCaption(airport.toString());
        return result;
    }

    private static ExtApiV1DictionaryItem getAirportCity(DictionaryReference<GeoLocation> airport) {
        GeoLocation airportLocation = (GeoLocation)DictionaryCache.get().resolveReference(airport);
        if (airportLocation != null && airportLocation.getType() == LocationType.AIRPORT) {
            DictionaryReference city = airportLocation.getParent();
            GeoLocation cityLocation = (GeoLocation)DictionaryCache.get().resolveReference(city);
            if (cityLocation != null && cityLocation.getType() == LocationType.CITY) {
                return ExtApiV1AviaConverterHelper.convertDictionaryReference2RestDictionaryItem((DictionaryReference<? extends BaseDictionary>)city);
            }
        }
        return null;
    }

    private static ExtApiV1DictionaryItem convertDictionaryReference2RestDictionaryItem(DictionaryReference<? extends BaseDictionary> dictRef) {
        ExtApiV1DictionaryItem result = new ExtApiV1DictionaryItem();
        if (StringUtils.isNotEmpty((String)dictRef.getCaption())) {
            result.setCaption(dictRef.getCaption());
        } else {
            BaseDictionary bd = DictionaryCache.get().resolveReference(dictRef);
            String caption = null;
            if (bd != null) {
                Locale locale = LocaleManager.get().getCurrentLocale();
                caption = (String)MiscUtil.findByLocale((Map)bd.getTranslations(), (Locale)locale);
                if (TextUtil.isBlank((String)caption) && !MiscUtil.equals((Object)locale, (Object)Locale.ENGLISH)) {
                    caption = (String)MiscUtil.findByLocale((Map)bd.getTranslations(), (Locale)Locale.ENGLISH);
                }
            }
            result.setCaption(caption);
            if (StringUtils.isEmpty((String)result.getCaption())) {
                if (StringUtils.isNotEmpty((String)dictRef.getCode())) {
                    result.setCaption(dictRef.getCode());
                } else {
                    result.setCaption(dictRef.toString());
                }
            }
        }
        result.setUid(dictRef.getCode());
        return result;
    }

    private static int sortByPassengerType(DictionaryReference<PassengerType> pt1, DictionaryReference<PassengerType> pt2) {
        return com.gridnine.xtrip.common.ibecorp.common.CommonHelper.getPassengerTypeRank(pt2) - com.gridnine.xtrip.common.ibecorp.common.CommonHelper.getPassengerTypeRank(pt1);
    }

    private static class SegmentInfo {
        private final Set<DictionaryReference<PassengerType>> usedTypes = new HashSet<DictionaryReference<PassengerType>>();
        private final Map<DictionaryReference<PassengerType>, LuggageInfo> baseLuggageInfo = new HashMap<DictionaryReference<PassengerType>, LuggageInfo>();
        private final Map<DictionaryReference<PassengerType>, FareDetails> brandedLuggageInfo = new HashMap<DictionaryReference<PassengerType>, FareDetails>();
        private FareDetails brandedFare;
        private final PriceComponentsParameters priceComponentsParameters;

        public SegmentInfo(PriceComponentsParameters priceComponentsParameters) {
            this.priceComponentsParameters = priceComponentsParameters;
        }

        private ExtApiV1ExtendedLuggage convertLuggageInfo2Rest(LuggageInfo luggageInfo) {
            ExtApiV1ExtendedLuggage result = new ExtApiV1ExtendedLuggage();
            if (luggageInfo != null) {
                result.setNil(Boolean.valueOf(luggageInfo.isNil()));
                if (!luggageInfo.isNil()) {
                    result.setPieces(luggageInfo.getQuantity());
                    result.setUnit(ExtApiV1AviaConverterHelper.convertLuggageUnit2Rest((DictionaryReference<LuggageUnit>)luggageInfo.getUnit()));
                }
            }
            return result;
        }

        private boolean isBrandedLuggageInfo(FareDetails fareDetails) {
            return Optional.ofNullable(fareDetails).map(FareDetails::getLuggageInfo).orElse(null) != null;
        }

        private ExtApiV1ExtendedLuggage getAndConvertLuggage(FareDetails fareDetails, LuggageInfo luggageInfo) {
            if (this.isBrandedLuggageInfo(fareDetails)) {
                return this.exchangeAndConvertExtendedLuggage2Rest(fareDetails.getLuggageInfo(), null);
            }
            return this.convertLuggageInfo2Rest(luggageInfo);
        }

        private ExtApiV1ExtendedLuggage exchangeAndConvertExtendedLuggage2Rest(ExtendedLuggageInfo luggageInfo, Money price) {
            ExtApiV1ExtendedLuggage result = new ExtApiV1ExtendedLuggage();
            if (luggageInfo != null) {
                result.setPieces(luggageInfo.getPieces());
                result.setWeight(luggageInfo.getWeight());
                result.setWeightUnit(luggageInfo.getWeightUnit());
                result.setLength(luggageInfo.getLength());
                result.setWidth(luggageInfo.getWidth());
                result.setHeight(luggageInfo.getHeight());
                result.setDimensionsSum(luggageInfo.getDimensionsSum());
                result.setDimensionUnit(luggageInfo.getDimensionUnit());
            }
            if (price != null) {
                if (price.getCurrency().equals(this.priceComponentsParameters.getCurrency())) {
                    result.setPrice(ExtApiV1CommonConverterHelper.convertMoney2Rest(price.getValue(), price.getCurrency()));
                } else {
                    Money money = new Money();
                    money.setCurrency(this.priceComponentsParameters.getCurrency());
                    money.setValue(CurrencyHelper.exchange((Money)price, (String)this.priceComponentsParameters.getCurrency()));
                    result.setPrice(ExtApiV1CommonConverterHelper.convertMoney2Rest(money));
                }
            }
            return result;
        }

        void addBaseLuggageInfo(DictionaryReference<PassengerType> passengerType, LuggageInfo luggageInfo) {
            this.usedTypes.add(passengerType);
            this.baseLuggageInfo.put(passengerType, luggageInfo);
        }

        void addBrandedLuggageInfo(DictionaryReference<PassengerType> passengerType, FareDetails fareDetails) {
            this.usedTypes.add(passengerType);
            this.brandedLuggageInfo.put(passengerType, fareDetails);
        }

        FareDetails getBrandedFare() {
            return this.brandedFare;
        }

        void setBrandedFare(FareDetails brandedFare) {
            this.brandedFare = brandedFare;
        }

        Map<DictionaryReference<PassengerType>, ExtApiV1ExtendedLuggage> getFreeLuggageInfo() {
            return this.usedTypes.stream().collect(Collectors.toMap(UnaryOperator.identity(), t -> this.getAndConvertLuggage(this.brandedLuggageInfo.get(t), this.baseLuggageInfo.get(t))));
        }

        Map<DictionaryReference<PassengerType>, ExtApiV1ExtendedLuggage> getPaidLuggageInfo() {
            return this.usedTypes.stream().collect(Collectors.toMap(UnaryOperator.identity(), t -> {
                FareDetails fareDetails = Optional.ofNullable(this.brandedLuggageInfo.get(t)).orElse(new FareDetails());
                return this.exchangeAndConvertExtendedLuggage2Rest(fareDetails.getPaidLuggageInfo(), fareDetails.getPaidLuggagePrice());
            }));
        }

        Map<DictionaryReference<PassengerType>, ExtApiV1ExtendedLuggage> getFreeCabinLuggageInfo() {
            return this.usedTypes.stream().collect(Collectors.toMap(UnaryOperator.identity(), t -> {
                FareDetails fareDetails = Optional.ofNullable(this.brandedLuggageInfo.get(t)).orElse(new FareDetails());
                return this.exchangeAndConvertExtendedLuggage2Rest(fareDetails.getCabinLuggageInfo(), null);
            }));
        }

        Map<DictionaryReference<PassengerType>, ExtApiV1ExtendedLuggage> getPaidCabinLuggageInfo() {
            return this.usedTypes.stream().collect(Collectors.toMap(UnaryOperator.identity(), t -> {
                FareDetails fareDetails = Optional.ofNullable(this.brandedLuggageInfo.get(t)).orElse(new FareDetails());
                return this.exchangeAndConvertExtendedLuggage2Rest(fareDetails.getPaidCabinLuggageInfo(), fareDetails.getPaidCabinLuggagePrice());
            }));
        }
    }

    private static class Penalty2RestConverter {
        private Penalty2RestConverter() {
        }

        private static ExtApiV1Money exchangeAndConvertMoney2Rest(PriceComponentsParameters priceComponentsParameters, Money money) {
            if (money == null || priceComponentsParameters.getCurrency().equals(money.getCurrency())) {
                return ExtApiV1CommonConverterHelper.convertMoney2Rest(money);
            }
            Money result = new Money();
            result.setCurrency(priceComponentsParameters.getCurrency());
            result.setValue(CurrencyHelper.exchange((Money)money, (String)priceComponentsParameters.getCurrency()));
            return ExtApiV1CommonConverterHelper.convertMoney2Rest(result);
        }

        private static ExtApiV1RefundPenaltiesInfo convertRefundPenalties2Rest(PriceComponentsParameters priceComponentsParameters, PenaltiesInfo penaltiesInfo) {
            ExtApiV1RefundPenaltiesInfo result = new ExtApiV1RefundPenaltiesInfo();
            if (penaltiesInfo == null) {
                return result;
            }
            result.setRefundableBeforeDeparture(Optional.ofNullable(penaltiesInfo.getRefundableBeforeDeparture()).orElse(false));
            result.setRefundableAfterDeparture(Optional.ofNullable(penaltiesInfo.getRefundableAfterDeparture()).orElse(false));
            result.setRefundBeforeDeparture(Penalty2RestConverter.exchangeAndConvertMoney2Rest(priceComponentsParameters, penaltiesInfo.getRefundBeforeDeparture()));
            result.setRefundAfterDeparture(Penalty2RestConverter.exchangeAndConvertMoney2Rest(priceComponentsParameters, penaltiesInfo.getRefundAfterDeparture()));
            return result;
        }

        private static ExtApiV1ExchangePenaltiesInfo convertExchangePenalties2Rest(PriceComponentsParameters priceComponentsParameters, PenaltiesInfo penaltiesInfo) {
            ExtApiV1ExchangePenaltiesInfo result = new ExtApiV1ExchangePenaltiesInfo();
            if (penaltiesInfo == null) {
                return result;
            }
            result.setExchangeableBeforeDeparture(Optional.ofNullable(penaltiesInfo.getExchangableBeforeDeparture()).orElse(false));
            result.setExchangeableAfterDeparture(Optional.ofNullable(penaltiesInfo.getExchangableAfterDeparture()).orElse(false));
            result.setExchangeBeforeDeparture(Penalty2RestConverter.exchangeAndConvertMoney2Rest(priceComponentsParameters, penaltiesInfo.getExchangeBeforeDeparture()));
            result.setExchangeAfterDeparture(Penalty2RestConverter.exchangeAndConvertMoney2Rest(priceComponentsParameters, penaltiesInfo.getExchangeAfterDeparture()));
            return result;
        }

        public static Map<DictionaryReference<PassengerType>, ExtApiV1ExchangePenaltiesInfo> convertExchangeInfo(Map<DictionaryReference<PassengerType>, PenaltiesInfo> penaltiesInfos, PriceComponentsParameters priceComponentsParameters) {
            return penaltiesInfos.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Penalty2RestConverter.convertExchangePenalties2Rest(priceComponentsParameters, (PenaltiesInfo)e.getValue())));
        }

        public static Map<DictionaryReference<PassengerType>, ExtApiV1RefundPenaltiesInfo> convertRefundInfo(Map<DictionaryReference<PassengerType>, PenaltiesInfo> penaltiesInfos, PriceComponentsParameters priceComponentsParameters) {
            HashMap<DictionaryReference<PassengerType>, ExtApiV1RefundPenaltiesInfo> result = new HashMap<DictionaryReference<PassengerType>, ExtApiV1RefundPenaltiesInfo>();
            penaltiesInfos.forEach((k, v) -> result.put((DictionaryReference<PassengerType>)k, Penalty2RestConverter.convertRefundPenalties2Rest(priceComponentsParameters, v)));
            return result;
        }
    }
}

