/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.avia;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsValidationMessages;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.rules.TransliterationType;
import com.gridnine.xtrip.common.model.rules.passport.PassportActionSet;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.CreateBookingParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchFlightsParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.ExtApiV1CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.avia.ExtApiV1AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.avia.ExtApiV1AviaHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.ExtApiV1Passport;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1CreateBookingParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1Customer;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1Passenger;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1SearchFlightsParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1SearchLeg;
import com.gridnine.xtrip.server.ibecorp.ibus.rules.PassportRuleHelper;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.ReadablePartial;

public final class ExtApiV1AviaValidationHelper {
    public static final Pattern ALPHA_NUMERIC_PATTERN = Pattern.compile("^([1-9A-Za-z]){3}[0-9A-Za-z]{3}(($)|([1-9A-Za-z]$)|([0-9A-Za-z]{4})$)");
    static final Pattern RUSSIAN_BIRTHDAY_NOTIFICATION_PATTERN = Pattern.compile("^[IVX]+[\u0410-\u042f\u0430-\u044f]{2}[0-9]{6}$");

    private ExtApiV1AviaValidationHelper() {
    }

    public static void validateFlightLeg(ExtApiV1SearchLeg fl) {
        if (Objects.isNull(fl.getDeparture())) {
            fl.getValidationContext().getDepartureValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyDepartureLocation());
        }
        if (Objects.isNull(fl.getArrival())) {
            fl.getValidationContext().getArrivalValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyArrivalLocation());
        }
        if (Objects.nonNull(fl.getDeparture()) && fl.getDeparture().equals((Object)fl.getArrival())) {
            fl.getValidationContext().getDepartureValidationMessages().add(GdsValidationMessages.getFlightSearchParametersRouteLocationsEqualOrInSameCity());
            fl.getValidationContext().getArrivalValidationMessages().add(GdsValidationMessages.getFlightSearchParametersRouteLocationsEqualOrInSameCity());
        }
        if (Objects.isNull(fl.getDate())) {
            fl.getValidationContext().getDateValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyDate());
        }
        if (Objects.nonNull(fl.getDate()) && fl.getDate().isBefore((ReadablePartial)LocalDate.now())) {
            fl.getValidationContext().getDateValidationMessages().add(SearchFlightsParametersValidationMessages.getPastDate());
        }
        if (fl.getDepartureTimeWindowStart() != null && fl.getDepartureTimeWindowEnd() != null && fl.getDepartureTimeWindowStart().isAfter(fl.getDepartureTimeWindowEnd())) {
            fl.getValidationContext().getDepartureTimeWindowStartValidationMessages().add(SearchFlightsParametersValidationMessages.getStartTimeAfterEndTime());
        }
    }

    public static void validateChildAges(ExtApiV1SearchFlightsParameters parameters, int children) {
        for (int i = 0; i < children; ++i) {
            if (i < parameters.getChildsAge().size() && !Objects.isNull(parameters.getChildsAge().get(i))) continue;
            parameters.getValidationContext().getChildsAgeListValidationMessages().put(i, Collections.singletonList(SearchFlightsParametersValidationMessages.getEmptyChildsAge()));
        }
    }

    public static boolean validatePassenger(ExtApiV1Passenger passenger, ExtApiV1CreateBookingParameters parameters, SalesContext salesContext) {
        boolean isValidateEmail;
        Flight gdsFlight;
        try {
            gdsFlight = AviaConverterHelper.convertRestToken2Flight(parameters.getFlightToken());
        }
        catch (Exception e) {
            return false;
        }
        ExtApiV1AviaValidationHelper.isValidPassport(passenger.getPassport(), gdsFlight, (DictionaryReference<PassengerType>)passenger.getType(), salesContext);
        boolean bl = isValidateEmail = gdsFlight.getGds() == GdsName.SABRE && AviaHelper.hasEmail((DictionaryReference<PassengerType>)passenger.getType());
        if (isValidateEmail || !TextUtil.isBlank((String)passenger.getEmail())) {
            ExtApiV1AviaValidationHelper.isValidEmail(passenger);
        }
        ExtApiV1AviaValidationHelper.isValidPhone(passenger);
        boolean hasBonusCard = ExtApiV1CommonValidationHelper.hasBonusCard(passenger.getBonusCard());
        if (hasBonusCard) {
            ExtApiV1CommonValidationHelper.isValidBonusCard(passenger.getBonusCard(), gdsFlight);
        }
        if (passenger.getDocoInfo() != null) {
            ExtApiV1CommonValidationHelper.validateDocoInfo(passenger.getDocoInfo());
        }
        if (passenger.getDocaInfo() != null) {
            ExtApiV1CommonValidationHelper.validateDocaInfo(passenger.getDocaInfo());
        }
        return ValidationHelper.isValid((Validatable)passenger);
    }

    private static boolean isValidPassport(ExtApiV1Passport passport, Flight gdsFlight, DictionaryReference<PassengerType> passengerType, SalesContext salesContext) {
        ExtApiV1Passport.ExtApiV1PassportValidationContext validationContext = passport.getValidationContext();
        if (passport.getGender() == null) {
            validationContext.getGenderValidationMessages().add(CreateBookingParametersValidationMessages.getMissingGender());
        }
        PassportActionSet transliterationRules = PassportRuleHelper.getPassportRules(gdsFlight, passengerType, ExtApiV1AviaConverterHelper.convertRest2PassportForRules(passport, gdsFlight), salesContext);
        TransliterationType transliterationType = AviaHelper.verifyTransliteration(gdsFlight, transliterationRules.getTransliterationTypeDocument());
        boolean latinRegistration = gdsFlight.isLatinRegistration();
        if (TransliterationType.LATIN.equals((Object)transliterationType)) {
            latinRegistration = true;
        } else if (TransliterationType.CYRILLIC.equals((Object)transliterationType)) {
            latinRegistration = false;
        }
        ExtApiV1AviaValidationHelper.isValidFirstName(passport, latinRegistration);
        ExtApiV1AviaValidationHelper.isValidLastName(passport, latinRegistration);
        if (!passport.isWithoutMiddleName()) {
            ExtApiV1AviaValidationHelper.isValidMiddleName(passport, latinRegistration);
        }
        ExtApiV1AviaValidationHelper.isValidBirthDate(passport, gdsFlight, passengerType);
        if (passport.getCitizenship() == null) {
            validationContext.getCitizenshipValidationMessages().add(CreateBookingParametersValidationMessages.getMissingCitizenship());
        }
        if (passport.getOriginCountry() == null) {
            validationContext.getOriginCountryValidationMessages().add(CreateBookingParametersValidationMessages.getMissingOrigin());
        }
        if (passport.getType() == null) {
            validationContext.getTypeValidationMessages().add(CreateBookingParametersValidationMessages.getMissingPassportType());
        }
        if (ExtApiV1AviaValidationHelper.isValidateExpiredDate(passport) && !ExtApiV1AviaHelper.isCalculateExpiredDate(passport, gdsFlight)) {
            ExtApiV1AviaValidationHelper.isValidExpiredDate(passport, gdsFlight);
        }
        ExtApiV1AviaValidationHelper.isValidPassportNumber(passport, gdsFlight);
        return ValidationHelper.isValid((Validatable)passport);
    }

    private static boolean isValidateExpiredDate(ExtApiV1Passport passport) {
        return passport.getType() != null && passport.getCitizenship() != null && passport.getOriginCountry() != null;
    }

    public static boolean isValidDKNumber(String number) {
        return ALPHA_NUMERIC_PATTERN.matcher(number).matches();
    }

    private static void isValidPhone(ExtApiV1Passenger passenger) {
        if (passenger.getType().equals((Object)DictHelper.getInfantPassengerType()) && (passenger.getPhone() == null || TextUtil.isBlank((String)passenger.getPhone().getCityCode()) || TextUtil.isBlank((String)passenger.getPhone().getCountryCode()) || TextUtil.isBlank((String)passenger.getPhone().getNumber()))) {
            ExtApiV1CommonValidationHelper.isValidPhone(passenger.getPhone(), passenger.getValidationContext().getPhoneValidationMessages());
        }
    }

    private static boolean isValidEmail(ExtApiV1Passenger passenger) {
        if (TextUtil.isBlank((String)passenger.getEmail())) {
            passenger.getValidationContext().getEmailValidationMessages().add(CreateBookingParametersValidationMessages.getMissingEmail());
            return false;
        }
        if (!ExtApiV1CommonValidationHelper.isValidEmailFormat(passenger.getEmail())) {
            passenger.getValidationContext().getEmailValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalEmail());
            return false;
        }
        return true;
    }

    private static boolean isValidPassportNumber(ExtApiV1Passport passport, Flight gdsFlight) {
        boolean isRuBirthdayNotification;
        if (TextUtil.isBlank((String)passport.getNumber())) {
            passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getMissingPassportNumber());
            return false;
        }
        String number = passport.getNumber();
        boolean isSirenaBirthDateNotification = ExtApiV1AviaHelper.isSirenaBirthDateNotification(gdsFlight.getGds(), passport.getType());
        boolean bl = isRuBirthdayNotification = ExtApiV1CommonValidationHelper.isRu((DictionaryReference<Country>)passport.getCitizenship()) && passport.getType() == PassportType.BIRTHDAY_NOTIFICATION;
        if (!isSirenaBirthDateNotification && !isRuBirthdayNotification && ExtApiV1AviaValidationHelper.isInvalidCharacterInPassportNumber(passport)) {
            passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalPassportNumber());
            return false;
        }
        if (isSirenaBirthDateNotification && !ExtApiV1AviaValidationHelper.isValidSirenaBirthDateNotificationNumber(number)) {
            passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalBirthdayNotificationNumber());
            return false;
        }
        if (ExtApiV1CommonValidationHelper.isRu((DictionaryReference<Country>)passport.getCitizenship())) {
            if (!(passport.getType() != PassportType.INTERNAL || ExtApiV1CommonValidationHelper.isNumber(number) && number.length() == 10)) {
                passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalInternalPassportNumber());
                return false;
            }
            if (passport.getType() == PassportType.FOREIGN && !ExtApiV1CommonValidationHelper.isNumber(number) && number.length() == 9) {
                passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalForeignPassportNumber());
                return false;
            }
            if (passport.getType() == PassportType.BIRTHDAY_NOTIFICATION && !ExtApiV1AviaValidationHelper.isValidRussianBirthDateNotificationNumber(passport.getNumber())) {
                passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalBirthdayNotificationNumber());
                return false;
            }
        }
        if (ExtApiV1CommonValidationHelper.isUa((DictionaryReference<Country>)passport.getCitizenship()) && number.length() > 15) {
            passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalInternalPassportNumberUA());
            return false;
        }
        return true;
    }

    private static boolean isValidSirenaBirthDateNotificationNumber(String number) {
        return RUSSIAN_BIRTHDAY_NOTIFICATION_PATTERN.matcher(number.replaceAll(" ", "")).matches();
    }

    private static boolean isValidRussianBirthDateNotificationNumber(String number) {
        return RUSSIAN_BIRTHDAY_NOTIFICATION_PATTERN.matcher(number).matches();
    }

    private static boolean isValidExpiredDate(ExtApiV1Passport passport, Flight gdsFlight) {
        if (Objects.isNull(passport.getExpiredDate())) {
            passport.getValidationContext().getExpiredDateValidationMessages().add(CreateBookingParametersValidationMessages.getMissingPassportExpired());
            return false;
        }
        if (FlightHelper.getFirstDepartureTime((Flight)gdsFlight).after(passport.getExpiredDate().toDate())) {
            passport.getValidationContext().getExpiredDateValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalPassportExpired());
            return false;
        }
        return true;
    }

    private static boolean isInvalidCharacterInPassportNumber(ExtApiV1Passport passport) {
        return passport.getNumber().chars().anyMatch(c -> ExtApiV1AviaValidationHelper.isInvalidCharacter(c, passport.getType() == PassportType.BIRTHDAY_NOTIFICATION, ExtApiV1CommonValidationHelper.isUa((DictionaryReference<Country>)passport.getCitizenship())));
    }

    private static boolean isInvalidCharacter(int ch, boolean isBirthDateNotification, boolean isUAPassport) {
        if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || isBirthDateNotification && ch == 32) {
            return false;
        }
        if (isUAPassport) {
            switch (ch) {
                case 1030: 
                case 1040: 
                case 1042: 
                case 1045: 
                case 1048: 
                case 1050: 
                case 1052: 
                case 1053: 
                case 1054: 
                case 1056: 
                case 1057: 
                case 1058: 
                case 1059: 
                case 1061: 
                case 1072: 
                case 1074: 
                case 1077: 
                case 1080: 
                case 1082: 
                case 1084: 
                case 1085: 
                case 1086: 
                case 1088: 
                case 1089: 
                case 1090: 
                case 1091: 
                case 1093: 
                case 1110: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private static boolean isValidBirthDate(ExtApiV1Passport passport, Flight gdsFlight, DictionaryReference<PassengerType> passengerType) {
        Collection validationMessages = passport.getValidationContext().getBirthDateValidationMessages();
        if (Objects.isNull(passport.getBirthDate())) {
            validationMessages.add(CreateBookingParametersValidationMessages.getMissingBirthDate());
            return false;
        }
        LocalDate departureDate = new LocalDate((Object)FlightHelper.getFirstDepartureTime((Flight)gdsFlight));
        Period period = new Period((ReadablePartial)passport.getBirthDate(), (ReadablePartial)departureDate);
        int age = period.getYears();
        int ageInMonths = period.getMonths() + age * 12;
        if (age < 0 || age > 150) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalBirthDate());
            return false;
        }
        if (DictHelper.isAdultPassengerType(passengerType) && age < 12) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalAdultAge());
            return false;
        }
        if (DictHelper.isInfantPassengerTypeCategory(passengerType) && ageInMonths >= 24) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalInfantAge());
            return false;
        }
        if (DictHelper.isChildPassengerTypeCategory(passengerType) && age > 11) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalChildAge());
            return false;
        }
        if (DictHelper.isYouthPassengerType(passengerType) && (age <= 12 || age >= 25)) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalYouthAge());
            return false;
        }
        if (DictHelper.isSeniorPassengerType(passengerType) && age < 65) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalSeniorAge());
            return false;
        }
        return true;
    }

    private static boolean isValidFirstName(ExtApiV1Passport passport, boolean isValidateLatinCharacters) {
        return ExtApiV1CommonValidationHelper.isValidName(passport.getFirstName(), isValidateLatinCharacters, passport.getValidationContext().getFirstNameValidationMessages(), CreateBookingParametersValidationMessages.getMissingFirstName(), CreateBookingParametersValidationMessages.getFirstNameNonLatin(), CreateBookingParametersValidationMessages.getFirstNameIllegal(), CreateBookingParametersValidationMessages.getFirstNameContainsSpace(), CreateBookingParametersValidationMessages.getFirstNameLengthLimit());
    }

    private static boolean isValidLastName(ExtApiV1Passport passport, boolean isValidateLatinCharacters) {
        return ExtApiV1CommonValidationHelper.isValidName(passport.getLastName(), isValidateLatinCharacters, passport.getValidationContext().getLastNameValidationMessages(), CreateBookingParametersValidationMessages.getMissingLastName(), CreateBookingParametersValidationMessages.getLastNameNonLatin(), CreateBookingParametersValidationMessages.getLastNameIllegal(), CreateBookingParametersValidationMessages.getLastNameContainsSpace(), CreateBookingParametersValidationMessages.getLastNameLengthLimit());
    }

    private static boolean isValidMiddleName(ExtApiV1Passport passport, boolean isValidateLatinCharacters) {
        return ExtApiV1CommonValidationHelper.isValidName(passport.getMiddleName(), isValidateLatinCharacters, passport.getValidationContext().getMiddleNameValidationMessages(), CreateBookingParametersValidationMessages.getMissingMiddleName(), CreateBookingParametersValidationMessages.getMiddleNameNonLatin(), CreateBookingParametersValidationMessages.getMiddleNameIllegal(), CreateBookingParametersValidationMessages.getMiddleNameContainsSpace(), CreateBookingParametersValidationMessages.getMiddleNameLengthLimit());
    }

    public static boolean validateCustomer(ExtApiV1Customer customer, SMGeneralSettings settings) {
        ExtApiV1AviaValidationHelper.isValidEmail(customer, settings);
        ExtApiV1AviaValidationHelper.isValidPhone(customer);
        return ValidationHelper.isValid((Validatable)customer);
    }

    public static void addValidationMessage(ExtApiV1SearchFlightsParameters parameters, Predicate<DictionaryReference<PassengerType>> passTypeCriterion, ValidationMessage message) {
        parameters.getPassengers().keySet().stream().filter(passTypeCriterion).forEach(type -> {
            Collection cfr_ignored_0 = parameters.getValidationContext().getPassengersListValidationMessages().put(type, Collections.singletonList(message));
        });
    }

    public static boolean isValidEmail(ExtApiV1Customer customer, SMGeneralSettings settings) {
        if (TextUtil.isBlank((String)customer.getEmail())) {
            customer.getValidationContext().getEmailValidationMessages().add(CreateBookingParametersValidationMessages.getMissingContactEmail());
            return false;
        }
        if (!ExtApiV1CommonValidationHelper.isValidEmailFormat(customer.getEmail())) {
            customer.getValidationContext().getEmailValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalContactEmail());
            return false;
        }
        if (settings.getBannedEmail().stream().anyMatch(s -> s.equalsIgnoreCase(customer.getEmail()))) {
            customer.getValidationContext().getEmailValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalContactEmail());
            return false;
        }
        return true;
    }

    public static boolean isValidPhone(ExtApiV1Customer customer) {
        if (customer.getPhone() == null || TextUtil.isBlank((String)customer.getPhone().getCityCode()) || TextUtil.isBlank((String)customer.getPhone().getCountryCode()) || TextUtil.isBlank((String)customer.getPhone().getNumber())) {
            customer.getValidationContext().getPhoneValidationMessages().add(CreateBookingParametersValidationMessages.getMissingPhone());
            return false;
        }
        return ExtApiV1CommonValidationHelper.isValidPhone(customer.getPhone(), customer.getValidationContext().getPhoneValidationMessages());
    }
}

