/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.avia.createBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.avia.ExtApiV1AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1CreateBookingParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1Passenger;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.HashSet;

public class ExtApiV1CreateBookingParametersConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV1CreateBookingParameters parameters = (ExtApiV1CreateBookingParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Flight selectedFlight = ExtApiV1AviaConverterHelper.convertRestToken2Flight(parameters.getFlightToken());
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        ArrayList<Traveller> travellers = new ArrayList<Traveller>(8);
        ArrayList<GdsTraveller> gdsTravellers = new ArrayList<GdsTraveller>(8);
        for (ExtApiV1Passenger passenger : parameters.getPassengers()) {
            Traveller traveller = ExtApiV1AviaConverterHelper.convertRest2Traveler(passenger, selectedFlight);
            GdsTraveller gdsTraveller = new GdsTraveller();
            gdsTraveller.setPassengerType(passenger.getType());
            gdsTraveller.setTravellerUid(traveller.getUid());
            travellers.add(traveller);
            gdsTravellers.add(gdsTraveller);
        }
        Customer customer = ExtApiV1AviaConverterHelper.convertRest2Customer(parameters.getCustomer());
        customer.setProfile(salesContext.getCustomer());
        customer.setPreferredLocale(LocaleHelper.getCurrentLocale());
        GdsReservationCreationParameters aviaParameters = new GdsReservationCreationParameters();
        aviaParameters.getGdsTravellers().addAll(gdsTravellers);
        aviaParameters.setFlight(selectedFlight);
        aviaParameters.setGdsAccount(selectedFlight.getGdsAccount());
        HashSet<GdsReservationCreationParameters> reservationCreationParameters = new HashSet<GdsReservationCreationParameters>();
        reservationCreationParameters.add(aviaParameters);
        ctx.putObject((Enum)IBusMidofficeContextKeys.TRAVELLERS, travellers);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_CREATION_PARAMETERS, reservationCreationParameters);
        ctx.putObject((Enum)IBusMidofficeContextKeys.CUSTOMER, (Object)customer);
        ctx.putObject((Enum)IBusIbecorpContextKeys.DK_NUMBER, (Object)parameters.getDkNumber());
    }
}

