/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.avia.createBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep3Settings;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.CreateBookingParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.avia.ExtApiV1AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.avia.ExtApiV1AviaValidationHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1CreateBookingParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1Passenger;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public class ExtApiV1CreateBookingParametersValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        ExtApiV1CreateBookingParameters parameters = (ExtApiV1CreateBookingParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Flight selectedFlight = ExtApiV1AviaConverterHelper.convertRestToken2Flight(parameters.getFlightToken());
        if (parameters.getPassengers().isEmpty()) {
            parameters.getValidationContext().getPassengersValidationMessages().add(CreateBookingParametersValidationMessages.getEmptyPassengers());
        }
        ArrayList validatedPassengers = new ArrayList(10);
        selectedFlight.getSeats().stream().flatMap(sp -> Stream.iterate(sp, UnaryOperator.identity()).map(SeatPreferences::getPassengerType).limit(sp.getCount())).forEach(t -> {
            Optional<ExtApiV1Passenger> validPassenger = parameters.getPassengers().stream().filter(p -> !validatedPassengers.contains(p)).findFirst();
            if (validPassenger.isPresent()) {
                ExtApiV1AviaValidationHelper.validatePassenger(validPassenger.get(), parameters, salesContext);
                validatedPassengers.add(validPassenger.get());
            } else {
                parameters.getValidationContext().getPassengersValidationMessages().add(CreateBookingParametersValidationMessages.getMissingPassenger());
            }
        });
        if (validatedPassengers.size() != selectedFlight.getSeats().stream().mapToInt(SeatPreferences::getCount).sum() && !validatedPassengers.equals(parameters.getPassengers())) {
            parameters.getValidationContext().getPassengersValidationMessages().add(CreateBookingParametersValidationMessages.getMissingPassenger());
        }
        ExtApiV1AviaValidationHelper.validateCustomer(parameters.getCustomer(), CommonHelper.getGeneralSettings((EntityReference<SMSite>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE))));
        if (!TextUtil.isBlank((String)parameters.getDkNumber()) && !ExtApiV1AviaValidationHelper.isValidDKNumber(parameters.getDkNumber())) {
            parameters.getValidationContext().getDkNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalDKNumber());
        }
        SMStep3Settings step3Settings = CommonHelper.getStep3Settings((EntityReference<SMSite>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE)));
        boolean checkIataRules = step3Settings.isDisplayIataRulesBlock();
        if (!step3Settings.isDisablePersonalDataRules() && !parameters.isAcceptSecurityRules()) {
            parameters.getValidationContext().getAcceptSecurityRulesValidationMessages().add(CreateBookingParametersValidationMessages.getSecurityRulesNotAccepted());
        }
        if (step3Settings.isDisplayRulesInOneLine()) {
            if (!parameters.isAcceptAllRules()) {
                parameters.getValidationContext().getAcceptAllRulesValidationMessages().add(CreateBookingParametersValidationMessages.getRulesNotAccepted());
            }
        } else {
            if (!parameters.isAcceptBookingRules()) {
                parameters.getValidationContext().getAcceptBookingRulesValidationMessages().add(CreateBookingParametersValidationMessages.getBookingRulesNotAccepted());
            }
            if (!parameters.isAcceptFareRemarks()) {
                parameters.getValidationContext().getAcceptFareRemarksValidationMessages().add(CreateBookingParametersValidationMessages.getFareRemarksNotAccepted());
            }
            if (checkIataRules && !parameters.isAcceptIataRules()) {
                parameters.getValidationContext().getAcceptIataRulesValidationMessages().add(CreateBookingParametersValidationMessages.getIataRulesNotAccepted());
            }
        }
        if (!ValidationHelper.isValid((Validatable)parameters)) {
            throw new ValidationException();
        }
    }
}

