/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.avia.searchFlights;

import com.gridnine.xtrip.common.gds.model.GdsValidationMessages;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchFlightsParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.avia.ExtApiV1AviaValidationHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1SearchFlightsParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExtApiV1SearchFlightsParametersValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV1SearchFlightsParameters parameters = (ExtApiV1SearchFlightsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        if (parameters.getFlightLegs().isEmpty()) {
            parameters.getValidationContext().getFlightLegsValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyLegs());
        }
        if (Objects.isNull(parameters.getClassOfService())) {
            parameters.getValidationContext().getClassOfServiceValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyClassOfService());
        }
        parameters.getFlightLegs().forEach(ExtApiV1AviaValidationHelper::validateFlightLeg);
        Map passengers = parameters.getPassengers();
        List passengerTypesWithInvalidCategory = passengers.keySet().stream().filter(type -> !AviaHelper.isValidPassengerTypeCategory((DictionaryReference<PassengerType>)type)).collect(Collectors.toList());
        if (!passengerTypesWithInvalidCategory.isEmpty()) {
            ExtApiV1AviaValidationHelper.addValidationMessage(parameters, passengerTypesWithInvalidCategory::contains, SearchFlightsParametersValidationMessages.getInvalidPassengerTypeCategory());
        }
        int totalPassengers = passengers.values().stream().mapToInt(count -> count).sum();
        int adults = AviaHelper.getAdultPassengersCount(passengers);
        int youthsOrSeniors = AviaHelper.getYouthAndSeniorsCount(passengers);
        int infants = AviaHelper.getInfantPassengersCount(passengers);
        int children = AviaHelper.getChildrenPassengersCount(passengers);
        if (totalPassengers == 0) {
            parameters.getValidationContext().getPassengersValidationMessages().add(GdsValidationMessages.getSeatsNotEnoughMajorPassengers());
        }
        if (totalPassengers > 8) {
            ExtApiV1AviaValidationHelper.addValidationMessage(parameters, AviaHelper.PassengerFilters.noFilterTypes, GdsValidationMessages.getSeatsTooManyPassengers());
        }
        if (adults <= 0 && youthsOrSeniors <= 0) {
            ExtApiV1AviaValidationHelper.addValidationMessage(parameters, AviaHelper.PassengerFilters.noFilterTypes, GdsValidationMessages.getSeatsNotEnoughMajorPassengers());
        }
        if ((adults > 0 || infants > 0 || children > 0) && youthsOrSeniors > 0) {
            ExtApiV1AviaValidationHelper.addValidationMessage(parameters, AviaHelper.PassengerFilters.youthsAndSeniorsFilter, SearchFlightsParametersValidationMessages.getYouthAndSeniorDoNotCombineWithOthers());
        }
        if (adults < infants) {
            ExtApiV1AviaValidationHelper.addValidationMessage(parameters, AviaHelper.PassengerFilters.adultsAndInfantsFilter, SearchFlightsParametersValidationMessages.getIllegalInfantsAmount());
        }
        if (children > 0 && CommonHelper.getStep1Settings((EntityReference<SMSite>)siteRef).isDisplayChildAgeSelector()) {
            ExtApiV1AviaValidationHelper.validateChildAges(parameters, children);
        }
        if (!ValidationHelper.isValid((Validatable)parameters)) {
            throw new ValidationException();
        }
    }
}

