/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.avia.searchFlights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.PriceDisplayStyle;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.AviaPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.ExtApiV1CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.avia.ExtApiV1AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1BestFlights;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1SearchFlightsResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public final class ExtApiV1SearchFlightsResultConverter
extends BaseProcessor {
    private static final DateTimeFormatter TF = DateTimeFormatter.ofPattern("HH:mm");

    public void process(MessageContext ctx) throws Exception {
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        Collection gdsFlights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        PriceDisplayStyle displayStyle = CommonHelper.getStep2Settings((EntityReference<SMSite>)siteRef).getPriceDisplayStyle();
        ExtApiV1SearchFlightsResult result = new ExtApiV1SearchFlightsResult();
        PriceComponentsParameters componentsParameters = this.getPriceConverterParameters(ctx);
        gdsFlights.stream().filter(flight -> flight.getCarrier() != null).forEach(flight -> ExtApiV1AviaConverterHelper.addFlightToBestPrices(flight, result.getBestPrices(), AviaPriceComponents.builder(flight, componentsParameters).build()));
        result.getBestPrices().entrySet().stream().forEach(bestFlightsEntry -> Collections.sort(((ExtApiV1BestFlights)bestFlightsEntry.getValue()).getBestFlights(), (bf1, bf2) -> ExtApiV1CommonConverterHelper.MONEY_COMPARATOR.compare(bf1.getPrice(), bf2.getPrice())));
        for (Flight flight2 : gdsFlights) {
            if (flight2.getCarrier() == null) continue;
            this.log.warn(this.noValidatingCarrierWarning(flight2));
            result.getFlights().add(ExtApiV1AviaConverterHelper.convertFlightSearchItem2Rest(flight2, componentsParameters, displayStyle, false));
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private String noValidatingCarrierWarning(Flight flight) {
        StringBuilder builder = new StringBuilder("No validating carrier for the flight:");
        List segments = FlightHelper.getSegments((Flight)flight);
        int segmentNumber = 0;
        for (FlightSegment segment : segments) {
            builder.append("\n").append("segment").append(++segmentNumber).append("(").append(segment.getLocationBegin().getCode()).append("->").append(segment.getLocationEnd().getCode()).append(")  departureTime: ").append(TF.format(MiscUtil.toLocalTime((Date)segment.getDateBegin()))).append(" arrivalTime: ").append(TF.format(MiscUtil.toLocalTime((Date)segment.getDateEnd()))).append(" flightNumber: ").append(segment.getFlightNumber());
        }
        return builder.toString();
    }

    protected PriceComponentsParameters getPriceConverterParameters(MessageContext ctx) {
        return PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER)), (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT));
    }
}

