/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.avia.searchMatrixFlights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.RouteType;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.AviaPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.avia.ExtApiV1AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1MatrixDepartures;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1MatrixFlightWithGap;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1SearchMatrixFlightsParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1SearchMatrixFlightsResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ExtApiV1SearchMatrixFlightsResultConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV1SearchMatrixFlightsParameters parameters = (ExtApiV1SearchMatrixFlightsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        ExtApiV1SearchMatrixFlightsResult result = new ExtApiV1SearchMatrixFlightsResult();
        Collection gdsFlights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        HashMap<String, Map<String, ExtApiV1MatrixFlightWithGap>> matrix = new HashMap<String, Map<String, ExtApiV1MatrixFlightWithGap>>();
        gdsFlights.stream().filter(flight -> flight.getCarrier() != null).forEach(flight -> ExtApiV1AviaConverterHelper.addFlightToMatrix(flight, matrix, AviaPriceComponents.builder(flight, PriceComponentsParameters.getBriefInfoParameters(salesContext)).build(), ExtApiV1AviaConverterHelper.getRequestedMatrixDates(parameters), CommonHelper.getStep2Settings((EntityReference<SMSite>)siteRef).getPriceDisplayStyle()));
        byte cheapestItemsNumber = parameters.getRouteType() == RouteType.ROUNDTRIP ? (byte)5 : 2;
        ExtApiV1AviaConverterHelper.setCheapestFlight(matrix, cheapestItemsNumber);
        matrix.entrySet().forEach(toDate -> {
            ExtApiV1MatrixDepartures departuresFrom = new ExtApiV1MatrixDepartures();
            ((Map)toDate.getValue()).entrySet().forEach(fromDate -> departuresFrom.getFrom().put(fromDate.getKey(), fromDate.getValue()));
            result.getTo().put(toDate.getKey(), departuresFrom);
        });
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

