/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.avia.selectFlight;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.avia.ExtApiV1AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1Flight;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1FlightParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.avia.ExtApiV1SelectFlightResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Iterator;
import java.util.List;

public class ExtApiV1SelectFlightResultConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV1FlightParameters parameters = (ExtApiV1FlightParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Flight oldFlight = AviaConverterHelper.convertRestToken2Flight(parameters.getFlightToken());
        Flight selectedFlight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMGeneralSettings generalSettings = CommonHelper.getGeneralSettings((EntityReference<SMSite>)siteRef);
        ExtApiV1SelectFlightResult result = new ExtApiV1SelectFlightResult();
        ExtApiV1Flight restFlight = ExtApiV1AviaConverterHelper.convertFlight2Rest(selectedFlight, this.getPriceConverterParameters(ctx), generalSettings, true);
        restFlight.setInternational(ExtApiV1AviaConverterHelper.isInternationalFlight(selectedFlight));
        result.setFlight(restFlight);
        result.setFlightToken(ExtApiV1AviaConverterHelper.convertFlight2RestToken(selectedFlight));
        result.setSegmentsChanged(this.isSegmentsChanged(oldFlight, selectedFlight));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    boolean isSegmentsChanged(Flight oldFlight, Flight selectedFlight) {
        List oldSegments = FlightHelper.getFlightSegmentsList((Flight)oldFlight);
        List newSegments = FlightHelper.getFlightSegmentsList((Flight)selectedFlight);
        if (oldSegments.size() != newSegments.size()) {
            return true;
        }
        Iterator oldIterator = oldSegments.iterator();
        for (FlightSegment newSegment : newSegments) {
            FlightSegment oldSegment = (FlightSegment)oldIterator.next();
            if (oldSegment.getDateBegin().compareTo(newSegment.getDateBegin()) == 0) continue;
            return true;
        }
        return false;
    }

    protected PriceComponentsParameters getPriceConverterParameters(MessageContext ctx) {
        return PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER)), (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT));
    }
}

