/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.booking.initiatePayment;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep4Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SalesOfficeDetails;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.model.RedirectForm;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.SiteConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.booking.BookingPaymentHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.ExtApiV1CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.booking.ExtApiV1BookingConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.booking.ExtApiV1InitiatePaymentInfo;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.booking.ExtApiV1InitiatePaymentParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.booking.ExtApiV1InitiatePaymentResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;

public class ExtApiV1InitiatePaymentResultConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PaymentType paymentType;
        ExtApiV1InitiatePaymentParameters parameters = (ExtApiV1InitiatePaymentParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        PaymentInitiationResult pir = (PaymentInitiationResult)ctx.getMandatoryObject((Enum)IBusPgContextKeys.INIT_PAYMENT_RESULT);
        EntityReference site = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        ExtApiV1InitiatePaymentResult result = new ExtApiV1InitiatePaymentResult();
        if (pir.getPayment() != null) {
            result.setPaymentId(pir.getPayment().getUid());
        }
        RedirectForm redirectForm = pir.getRedirectForm();
        result.setUrl(redirectForm.getUrl());
        if (!TextUtil.isBlank((String)redirectForm.getMethod())) {
            result.setMethod(redirectForm.getMethod());
        }
        if (!redirectForm.getParameters().isEmpty()) {
            result.getParameters().putAll(CommonHelper.convertCollectionToMap(redirectForm.getParameters(), NamedValue::getName, NamedValue::getValue));
        }
        if (!redirectForm.getParameters().isEmpty() && (redirectForm.getMethod() == null || "get".equals(redirectForm.getMethod().toLowerCase()))) {
            URIBuilder b = new URIBuilder(redirectForm.getUrl());
            for (NamedValue p : redirectForm.getParameters()) {
                b.setParameter(p.getName(), p.getValue());
            }
            result.setUrl(b.toString());
        }
        if ((paymentType = (PaymentType)ctx.getMandatoryObject((Enum)IBusPgContextKeys.PAYMENT_TYPE)) == PaymentType.CASH || paymentType == PaymentType.CASH_DELIVERY) {
            PaymentInitiationParameters paymentInitiationParameters = BookingPaymentHelper.createPaymentInitiationParameters(BookingPaymentHelper.getComebackURL(ctx), (EntityContainer<BookingFile>)bookingFile, (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT), ContractType.CLIENT);
            Map<PaymentType, MiscUtil.Pair<PgName, BigDecimal>> paymentTypesMap = BookingPaymentHelper.getPaymentTypesMap(paymentInitiationParameters, (EntityContainer<BookingFile>)bookingFile, ContractType.CLIENT);
            String currency = PriceComponentsParameters.getBriefInfoParameters((SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT)).getCurrency();
            SMStep4Settings step4Settings = CommonHelper.getStep4Settings((EntityReference<SMSite>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE)));
            if (paymentType == PaymentType.CASH) {
                SalesOfficeDetails salesOfficeDetails = CommonHelper.getStep4Settings((EntityReference<SMSite>)site).getCashSalesOfficesDetails().stream().filter(sod -> sod.getUid().equals(parameters.getSalesOfficeUid())).findFirst().get();
                ExtApiV1InitiatePaymentInfo paymentInfo = ExtApiV1BookingConverterHelper.convertBookingToInitiatePaymntInfo((EntityContainer<BookingFile>)bookingFile, ExtApiV1CommonConverterHelper.convertMoney2Rest((BigDecimal)paymentTypesMap.get(PaymentType.CASH).getSecond(), currency), SiteConverterHelper.getLocalizedText(step4Settings.getCashSummaryBlock()), (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT));
                paymentInfo.setText(paymentInfo.getText().replace("${address}", ProfileHelper.buildFullAddress((Address)salesOfficeDetails.getAddress(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false)));
                result.setInitiatePaymentInfo(paymentInfo);
            }
            if (paymentType == PaymentType.CASH_DELIVERY) {
                result.setInitiatePaymentInfo(ExtApiV1BookingConverterHelper.convertBookingToInitiatePaymntInfo((EntityContainer<BookingFile>)bookingFile, ExtApiV1CommonConverterHelper.convertMoney2Rest((BigDecimal)paymentTypesMap.get(PaymentType.CASH_DELIVERY).getSecond(), currency), SiteConverterHelper.getLocalizedText(step4Settings.getCashDeliverySummaryBlock()), (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT)));
            }
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

