/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.cabinet;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.ExtApiV1Passport;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.ExtApiV1Phone;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.cabinet.ExtApiV1EmployerType;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.cabinet.ExtApiV1Person;
import java.util.stream.Collectors;
import org.joda.time.LocalDate;

public class ExtApiV1CabinetConverterHelper {
    public static ExtApiV1EmployerType convertOrganizationType2EmployerType(OrganizationType orgType, EntityReference<Organization> orgRef) throws Exception {
        if (orgType == OrganizationType.CORPORATE_CLIENT) {
            return ExtApiV1EmployerType.CORPORATE_CLIENT;
        }
        if (orgType == OrganizationType.AGENCY) {
            EntityReference<Organization> mainAgencyRef = CommonHelper.findMainAgency();
            return orgRef.equals(mainAgencyRef) ? ExtApiV1EmployerType.MAIN_AGENCY : ExtApiV1EmployerType.AGENCY;
        }
        return null;
    }

    public static ExtApiV1Person convertPerson2Rest(Person person) {
        ExtApiV1Person result = new ExtApiV1Person();
        result.setUid(person.getUid());
        result.setFirstName(person.getFirstName().toString());
        result.setSecondName(person.getSecondName().toString());
        result.setLastName(person.getLastName().toString());
        result.setMiddleName(person.getMiddleName().toString());
        result.setGender(person.getGender());
        result.getPassports().addAll(person.getPassports().stream().map(ExtApiV1CabinetConverterHelper::convertPassport2Rest).collect(Collectors.toList()));
        result.getPhones().addAll(CommonHelper.getPhones(person.getCommunications(), CommunicationType.CELL, CommunicationType.MOBILE).stream().map(ExtApiV1CabinetConverterHelper::convertPhoneCommunication2Rest).collect(Collectors.toList()));
        result.getEmails().addAll(CommonHelper.getEmails(person.getCommunications()).stream().map(CommonConverterHelper::convertEmailCommunication2Rest).collect(Collectors.toList()));
        return result;
    }

    public static ExtApiV1Passport convertPassport2Rest(Passport passport) {
        ExtApiV1Passport result = new ExtApiV1Passport();
        result.setGender(passport.getGender());
        result.setFirstName(passport.getFirstName());
        result.setMiddleName(passport.getMiddleName());
        result.setLastName(passport.getLastName());
        result.setBirthDate(new LocalDate((Object)passport.getBirthday()));
        result.setType(passport.getType());
        result.setNumber(passport.getNumber());
        result.setCitizenship(passport.getCitizenship());
        result.setExpiredDate(new LocalDate((Object)passport.getExpired()));
        result.setOriginCountry(passport.getOriginCountry());
        return result;
    }

    public static ExtApiV1Phone convertPhoneCommunication2Rest(Communication communication) {
        if (communication == null) {
            return null;
        }
        ExtApiV1Phone result = new ExtApiV1Phone();
        result.setCountryCode(communication.getCountryCode());
        result.setCityCode(communication.getCityCode());
        result.setNumber(communication.getSense());
        return result;
    }
}

