/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.cabinet.getItineraryReceipt;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DownloadableData;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV1.model.cabinet.ExtApiV1GetItineraryReceiptParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.templates.jr.ItineraryReceiptRender;
import com.gridnine.xtrip.server.parsers.helpers.ParsersHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class ExtApiV1GetItineraryReceiptProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV1GetItineraryReceiptParameters request = (ExtApiV1GetItineraryReceiptParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        if (TextUtil.isBlank((String)request.getPnr())) {
            throw Xeption.forDeveloper((String)"empty pnr", (Object[])new Object[0]);
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)request.getPnr(), (boolean)true), SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)ParsersHelper.translitPnr((String)request.getPnr(), (boolean)false), (boolean)true)}));
        List bfIndices = EntityStorage.get().search(BookingFileIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData();
        if (bfIndices.size() == 0) {
            throw Xeption.forDeveloper((String)("No booking file found for pnr " + request.getPnr()), (Object[])new Object[0]);
        }
        Locale locale = LocaleUtil.createNormalizedLocale((String)LocaleHelper.getCurrentLocale().getLanguage());
        EntityContainer<TemplateDocument> templateContainer = CabinetHelper.getTemplateDocument(locale);
        if (templateContainer == null) {
            throw Xeption.forDeveloper((String)String.format("Travel reservation template not found for locale %s", locale.toString()), (Object[])new Object[0]);
        }
        BookingFileIndex bfInd = (BookingFileIndex)bfIndices.get(0);
        EntityReference bfRef = bfInd.getSource();
        EntityContainer bfCont = EntityStorage.get().resolve(bfRef);
        Product product = null;
        if (bfCont != null && bfCont.getEntity() != null) {
            block0: for (Reservation res : ((BookingFile)bfCont.getEntity()).getReservations()) {
                for (BaseProduct bp : res.getProducts()) {
                    if (!TextUtil.isSame((String)bp.getUid(), (String)request.getProductUid()) || !(bp instanceof Product)) continue;
                    product = (Product)bp;
                    continue block0;
                }
            }
        }
        DictionaryCache dCache = (DictionaryCache)Environment.getPublished(DictionaryCache.class);
        LinkedList<InformationNote> notes = new LinkedList<InformationNote>();
        for (String noteCode : request.getInformationNotes()) {
            InformationNote note = (InformationNote)dCache.findByCode(InformationNote.class, noteCode);
            if (note == null) continue;
            notes.add(note);
        }
        ItineraryReceiptRender render = new ItineraryReceiptRender();
        FilledTemplateDocument file = render.renderReport(bfCont, product, templateContainer, notes, false, false, false, true, false, true, request.isUseFeesAsTaxes(), true, request.isUseFeesAsTaxes(), false, false, false);
        file.setContent(JasperUtil.convertToPdf((byte[])file.getContent()));
        file.setContentType(ContentType.PDF);
        BinaryData binaryData = new BinaryData();
        binaryData.setContentType(file.getContentType());
        binaryData.setData(file.getContent());
        DownloadableData result = new DownloadableData();
        result.setFileName("itineraryReceipt.pdf");
        result.setContent(binaryData);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

