/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.Principal;
import com.gridnine.xtrip.common.model.dict.PrincipalReference;
import com.gridnine.xtrip.common.model.export.ExportDocumentIndex;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentRecordIndex;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.TrashBinItemIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.common.ExtApiV2CommonConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2Rate;
import com.gridnine.xtrip.server.externalApi.security.ExtApiV2SecurityHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.Rate;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.EntityReference;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseProduct;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2OrderMessages;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.dict.ExtApiV2PrincipalReference;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.shipment.ExtApiV2DeletedShipment;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.shipment.ExtApiV2Shipment;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.shipment.ExtApiV2ShipmentDocumentData;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.shipment.ExtApiV2ShipmentExportInfo;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ExtApiV2ConverterHelper {
    public static Collection<ExtApiV2Rate> convertRatesToRest(List<Rate> rates) {
        return rates.stream().map(rate -> {
            ExtApiV2Rate result = new ExtApiV2Rate();
            result.setTotal(ExtApiV2CommonConverterHelper.convertMoney2Rest((BigDecimal)rate.getRate(), (String)rate.getCurrency().getCode()));
            result.setSymbol(((CurrencyInfo)DictionaryCache.get().resolveReference(rate.getCurrency())).getDisplaySymbol());
            return result;
        }).collect(Collectors.toList());
    }

    public static void addPreferredPropertiesToShipmentQuery(SearchQuery query) {
        query.getPreferredProperties().add(ShipmentIndex.Property.number.name());
        query.getPreferredProperties().add(ShipmentIndex.Property.date.name());
        query.getPreferredProperties().add(ShipmentIndex.Property.totalAmount.name());
        query.getPreferredProperties().add(ShipmentIndex.Property.totalVatAmount.name());
        query.getPreferredProperties().add(ShipmentIndex.Property.currency.name());
        query.getPreferredProperties().add(ShipmentIndex.Property.customer.name());
        query.getPreferredProperties().add(ShipmentIndex.Property.agent.name());
        query.getPreferredProperties().add(ShipmentIndex.Property.exportedToSbis.name());
        query.getPreferredProperties().add(ShipmentIndex.Property.lastExportToSbisDate.name());
        query.getPreferredProperties().add(ShipmentIndex.Property.sentToEmail.name());
    }

    public static void fillStandardFieldsAndFindocsToRest(ShipmentIndex index, com.gridnine.xtrip.common.model.EntityReference<Person> currentUser, ExtApiV2Shipment restShipment) throws Exception {
        restShipment.setUid(index.getSource().getUid());
        restShipment.setNumber(index.getNumber());
        restShipment.setDate(MiscUtil.toLocalDateTime((Date)index.getDate()));
        restShipment.setAmount(index.getTotalAmount());
        restShipment.setVatAmount(index.getTotalVatAmount());
        restShipment.setCurrency(index.getCurrency());
        restShipment.setModifiedDate(MiscUtil.toLocalDateTime((Date)index.getModified()));
        restShipment.setClient(ExtApiV2CommonConverterHelper.convertOrganization2Rest((com.gridnine.xtrip.common.model.EntityReference)index.getCustomer()));
        restShipment.setExportedToSbis(index.isExportedToSbis());
        restShipment.setLastExportToSbisDate(MiscUtil.toLocalDateTime((Date)index.getLastExportToSbisDate()));
        restShipment.setSentToMail(index.isSentToEmail());
        SearchQuery findocsQuery = new SearchQuery();
        findocsQuery.getCriteria().getCriterions().add(SearchCriterion.contains((String)FinanceDocumentRecordIndex.Property.relatedShipments.name(), (Object)index.getSource()));
        findocsQuery.getPreferredProperties().add(FinanceDocumentRecordIndex.Property.number.name());
        findocsQuery.getPreferredProperties().add(FinanceDocumentRecordIndex.Property.documentType.name());
        findocsQuery.getPreferredProperties().add(FinanceDocumentRecordIndex.Property.totalAmount.name());
        findocsQuery.getPreferredProperties().add(FinanceDocumentRecordIndex.Property.totalVatAmount.name());
        restShipment.getDocuments().clear();
        for (FinanceDocumentRecordIndex docIndex : ExtApiV2SecurityHelper.secureSearch(currentUser, FinanceDocumentRecordIndex.class, (SearchQuery)findocsQuery)) {
            ExtApiV2ShipmentDocumentData restDocument = new ExtApiV2ShipmentDocumentData();
            restDocument.setNumber(docIndex.getNumber());
            restDocument.setType(docIndex.getDocumentType());
            restDocument.setAmount(docIndex.getTotalAmount());
            restDocument.setVatAmount(docIndex.getTotalVatAmount());
            restShipment.getDocuments().add(restDocument);
        }
    }

    public static ExtApiV2DeletedShipment convertDeletedShipmentToRest(TrashBinItemIndex index) {
        ExtApiV2DeletedShipment restShipment = new ExtApiV2DeletedShipment();
        restShipment.setNumber(index.getNumber());
        restShipment.setDeleted(true);
        restShipment.setDeletedDate(MiscUtil.toLocalDateTime((Date)index.getDeleted()));
        return restShipment;
    }

    public static void fillExportInfoToRest(com.gridnine.xtrip.common.model.EntityReference<Shipment> shipmentRef, ExtApiV2Shipment restShipment, com.gridnine.xtrip.common.model.EntityReference<Person> currentUser, com.gridnine.xtrip.common.model.EntityReference<Person> agent) throws Exception {
        SearchQuery documentsQuery = new SearchQuery();
        documentsQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)ExportDocumentIndex.Property.object.name(), shipmentRef));
        documentsQuery.getCriteria().getOrders().put(ExportDocumentIndex.Property.createDate.name(), SortOrder.DESC);
        documentsQuery.setLimit(1);
        List documentIndices = ExtApiV2SecurityHelper.secureSearch(currentUser, ExportDocumentIndex.class, (SearchQuery)documentsQuery);
        ExtApiV2ShipmentExportInfo extApiV2ShipmentExportInfo = new ExtApiV2ShipmentExportInfo();
        restShipment.setExportInfo(extApiV2ShipmentExportInfo);
        if (!documentIndices.isEmpty()) {
            ExportDocumentIndex docIndex = (ExportDocumentIndex)documentIndices.get(0);
            extApiV2ShipmentExportInfo.setCreateDate(MiscUtil.toLocalDateTime((Date)docIndex.getCreateDate()));
            extApiV2ShipmentExportInfo.setExportStatus(docIndex.getStatus());
            extApiV2ShipmentExportInfo.setAgent(agent);
            extApiV2ShipmentExportInfo.setLastUploadDate(MiscUtil.toLocalDateTime((Date)docIndex.getLastCommunicationDate()));
        }
    }

    public static void fillExportInfoToRest(com.gridnine.xtrip.common.model.EntityReference<Shipment> shipmentRef, ExtApiV2Shipment restShipment, com.gridnine.xtrip.common.model.EntityReference<Person> agent, Map<String, ExportDocumentIndex> shipmentUids2ExportDocs) {
        ExtApiV2ShipmentExportInfo extApiV2ShipmentExportInfo = new ExtApiV2ShipmentExportInfo();
        restShipment.setExportInfo(extApiV2ShipmentExportInfo);
        Optional.ofNullable(shipmentUids2ExportDocs.get(shipmentRef.getUid())).ifPresent(docIndex -> {
            extApiV2ShipmentExportInfo.setCreateDate(MiscUtil.toLocalDateTime((Date)docIndex.getCreateDate()));
            extApiV2ShipmentExportInfo.setExportStatus(docIndex.getStatus());
            extApiV2ShipmentExportInfo.setAgent(agent);
            extApiV2ShipmentExportInfo.setLastUploadDate(MiscUtil.toLocalDateTime((Date)docIndex.getLastCommunicationDate()));
        });
    }

    public static <E extends BaseEntity> com.gridnine.xtrip.common.model.EntityReference<E> toModelEntityReference(EntityReference ref) throws Exception {
        return new com.gridnine.xtrip.common.model.EntityReference(ref.getUid(), Class.forName(ref.getType()), null);
    }

    public static EntityReference toApiEntityReference(com.gridnine.xtrip.common.model.EntityReference<?> ref) {
        EntityReference result = new EntityReference();
        result.setUid(ref.getUid());
        result.setType(ref.getType().getName());
        return result;
    }

    public static void updateClientFops(ExtApiV2BaseProduct restProduct, BaseProduct fromRest) {
        ExtApiV2ConverterHelper.updateClientFops(restProduct, GeneralProductHelper.getClientContractRelationByReflection((BaseProduct)fromRest));
    }

    public static void updateClientFops(ExtApiV2BaseProduct restProduct, GeneralProductContractRelationData clientContractRelation) {
        restProduct.getClientFops().forEach(restFop -> clientContractRelation.getFops().stream().filter(productFop -> MiscUtil.equals((Object)restFop.getUid(), (Object)productFop.getUid(), (boolean)false)).forEach(productFop -> {
            productFop.setType(restFop.getPaymentType());
            productFop.setOperationDate(DateUtils.toJavaDate((LocalDateTime)restFop.getOperationDate()));
            productFop.setAgent(restFop.getAgent());
        }));
    }

    public static ExtApiV2PrincipalReference convertPrincipal2RestReference(Principal principal) {
        if (principal != null) {
            ExtApiV2PrincipalReference result = new ExtApiV2PrincipalReference();
            result.setCode(principal.getCode());
            result.setName((String)MiscUtil.findByLocale((Map)principal.getTranslations(), (Locale)LocaleHelper.getCurrentLocale()));
            result.setInn(principal.getRegistrationId());
            return result;
        }
        return null;
    }

    public static PrincipalReference convertRestPrincipalReference(ExtApiV2PrincipalReference restRef) {
        Principal principal = null;
        if (restRef != null) {
            if (TextUtil.nonBlank((String)restRef.getCode())) {
                principal = (Principal)DictionaryCache.get().findByCode(Principal.class, restRef.getCode());
            }
            if (principal == null) {
                Set search = DictionaryCache.get().search(Principal.class, DictSearchCriterion.eq((String)Principal.Property.registrationId.name(), (Object)restRef.getInn()));
                principal = (Principal)CollectionUtil.head((Iterable)search);
            }
        }
        return principal != null ? principal.toReference() : null;
    }

    public static Traveller getTravellerByPassengerUid(String passengerUid, Map<String, Traveller> travellerMap) {
        List travellers = travellerMap.values().stream().filter(traveller -> traveller.getPassenger() != null).filter(traveller -> MiscUtil.equals((Object)traveller.getPassenger().getUid(), (Object)passengerUid, (boolean)false)).collect(Collectors.toList());
        if (travellers.isEmpty()) {
            throw Xeption.forEndUser((String)ExtApiV2OrderMessages.getTravellerNotFound((String)passengerUid).getText(), (Object[])new Object[0]);
        }
        if (travellers.size() > 1) {
            throw Xeption.forEndUser((String)ExtApiV2OrderMessages.getSeveralTravellersFound((String)passengerUid).getText(), (Object[])new Object[0]);
        }
        return (Traveller)travellers.get(0);
    }
}

