/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2;

import com.google.common.collect.ImmutableMap;
import com.gridnine.xtrip.common.rest.TypeDiscriminator;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2GdsAccountType;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2ProductType;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.gdsAccount.ExtApiV2GdsAccountHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2ProductHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2ProductHandlersRegistry;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseGdsAccount;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseProduct;
import java.util.Map;
import java.util.function.Function;
import org.json.JSONObject;

public class ExtApiV2TypeDiscriminator
extends TypeDiscriminator {
    private static final Function<Object, Class<?>> BASE_PRODUCT_HANDLER = object -> {
        ExtApiV2ProductType productType = (ExtApiV2ProductType)EnumUtil.fromNameSafe(ExtApiV2ProductType.class, (String)((JSONObject)object).getString("productType"), (boolean)true);
        ExtApiV2ProductHandler handler = ExtApiV2ProductHandlersRegistry.get().findProductHandler(productType);
        return handler != null ? handler.getRestProductClass() : ExtApiV2BaseProduct.class;
    };
    private static final Function<Object, Class<?>> BASE_GDS_ACCOUNT_HANDLER = object -> {
        ExtApiV2GdsAccountType accountType = (ExtApiV2GdsAccountType)EnumUtil.fromNameSafe(ExtApiV2GdsAccountType.class, (String)((JSONObject)object).getString("type"), (boolean)true);
        ExtApiV2GdsAccountHandler handler = ExtApiV2GdsAccountHandler.getHandlerByType(accountType);
        return handler != null ? handler.getAccountClass() : ExtApiV2BaseProduct.class;
    };
    private static final Map<Class<?>, Function<Object, Class<?>>> handlers = new ImmutableMap.Builder().put(ExtApiV2BaseProduct.class, BASE_PRODUCT_HANDLER).put(ExtApiV2BaseGdsAccount.class, BASE_GDS_ACCOUNT_HANDLER).build();

    public boolean isAwareOf(Class<?> type) {
        return handlers.containsKey(type);
    }

    protected Class<?> determineEntityTypeFromObject(Object object, Class<?> type) {
        if (handlers.containsKey(type)) {
            return handlers.get(type).apply(object);
        }
        throw new IllegalArgumentException(String.format("Unsupported product type: %s", type));
    }
}

