/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.aeroexpress;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.dictionary.ExtApiV2DictionaryConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2DictionaryWrapper;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class ExtApiV2AeroexpressConverterHelper {
    private static final List<DictionaryReference<GeoLocation>> LOCATIONS = Arrays.asList(new GeoLocationReference("MOW", "\u041c\u043e\u0441\u043a\u0432\u0430"), new GeoLocationReference("airport VKO", "\u0412\u043d\u0443\u043a\u043e\u0432\u043e"), new GeoLocationReference("airport DME", "\u0414\u043e\u043c\u043e\u0434\u0435\u0434\u043e\u0432\u043e"), new GeoLocationReference("airport SVO", "\u0428\u0435\u0440\u0435\u043c\u0435\u0442\u044c\u0435\u0432\u043e"));

    public static Product getRelatedProduct(String relatedProductUid, String bookingCtrUid) {
        EntityContainer bookingCtr;
        if (TextUtil.nonBlank((String)relatedProductUid) && (bookingCtr = EntityStorage.get().load(BookingFile.class, bookingCtrUid)) != null) {
            return BookingHelper.getProductsStream((BookingFile)((BookingFile)bookingCtr.getEntity()), Product.class).filter(product -> MiscUtil.equals((Object)relatedProductUid, (Object)product.getUid())).findFirst().orElse(null);
        }
        return null;
    }

    public static GeoLocationReference findGeoLocation(ExtApiV2DictionaryWrapper geoLocationWrapper) {
        Set departureLocations = ExtApiV2DictionaryConverterHelper.lookupDictionaryWrapper(GeoLocation.class, (ExtApiV2DictionaryWrapper)geoLocationWrapper);
        if (departureLocations.size() > 1) {
            throw Xeption.forEndUser((String)String.format("More than one geolocation found for code(s) %s", String.join((CharSequence)", ", geoLocationWrapper.getCodes().values())), (Object[])new Object[0]);
        }
        if (!departureLocations.isEmpty()) {
            GeoLocationReference geoLocationRef = ((GeoLocation)departureLocations.iterator().next()).toReference();
            if (!LOCATIONS.contains(geoLocationRef)) {
                throw Xeption.forEndUser((String)String.format("Wrong geolocation %s", geoLocationRef.toString()), (Object[])new Object[0]);
            }
            return geoLocationRef;
        }
        return null;
    }
}

