/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.avia;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.DocaInformation;
import com.gridnine.xtrip.common.gds.model.DocoInformation;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.RouteType;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.model.VisaRequirement;
import com.gridnine.xtrip.common.ibecorp.CurrencyHelper;
import com.gridnine.xtrip.common.ibecorp.common.PenaltiesResolver;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.TechStopInfo;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.booking.air.OBFee;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineAlliance;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.LuggageUnit;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.gds.PenaltiesInfo;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructure;
import com.gridnine.xtrip.common.model.ibecorp.externalApi.extApiV2.avia.ExtApiV2AviaToken;
import com.gridnine.xtrip.common.model.ibecorp.sm.PriceDisplayStyle;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyParameters;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.common.ExtApiV2CommonConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.corporateData.person.ExtApiV2PersonHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.dictionary.ExtApiV2DictionaryConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2AirBonusCard;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2DictionaryWrapper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2Money;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2Passport;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2Phone;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2ProductFop;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2Tax;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.AviaPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.GeneralPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.TravelPolicyAction;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.ExtApiV2ConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.avia.ExtApiV2AviaValidationHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.ExtApiV2HasTravelPolicyCompliance;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.ExtApiV2TravelPolicyCompliance;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.ExtApiV2TravelPolicyRule;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2AviaProductPrice;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2BSPCommission;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2BestFlight;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2BestFlights;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2ConnectionsRestriction;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2Customer;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2DictionaryItem;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2DocaInfo;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2DocoDocaNeededInfo;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2DocoInfo;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2ExchangePenaltiesInfo;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2ExtendedLuggage;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2FeeDetails;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2Flight;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2FlightItem;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2FlightLeg;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2FlightSegment;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2MatrixFlightWithGap;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2OBFee;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2Passenger;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2PassengerPrice;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2Price;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2ProductLeg;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2ProductSegment;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2ProductSegmentDetails;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2RefundPenaltiesInfo;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2SearchLeg;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2SearchMatrixFlightsParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2SeatDescription;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2ServiceStatus;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2ServicesDetails;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2ServicesStatuses;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2TechStopInfo;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.dict.ExtApiV2AirlineReference;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.dict.ExtApiV2GeoLocationReference;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.dict.ExtApiV2GeoLocationType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.joda.time.Days;
import org.joda.time.ReadablePartial;

public final class ExtApiV2AviaConverterHelper {
    private static final long MILLIS_IN_DAY = 86400000L;

    public static ExtApiV2FlightItem convertFlightSearchItem2Rest(Flight flight, PriceComponentsParameters parameters, PriceDisplayStyle priceDisplayStyle, boolean displayTimeLimit, TravelPolicyParameters travelPolicyParams) throws Exception {
        ExtApiV2FlightItem result = new ExtApiV2FlightItem();
        result.setFlight(ExtApiV2AviaConverterHelper.convertFlight2Rest(flight, parameters, null, displayTimeLimit));
        BigDecimal total = AviaHelper.getPriceByDisplayStyle(priceDisplayStyle, AviaPriceComponents.builder(flight, parameters).build(), AviaHelper.getAdultsType(flight.getSeats()));
        result.getFlight().getPrice().getTotal().setAmount((double)total.setScale(0, RoundingMode.HALF_DOWN).intValue());
        ExtApiV2AviaToken aviaToken = new ExtApiV2AviaToken();
        aviaToken.setFlight(flight);
        aviaToken.setTravelPolicyParams(travelPolicyParams);
        result.setFlightToken(ExtApiV2AviaConverterHelper.convertFlight2RestToken(aviaToken));
        result.setExtendedFare(FlightHelper.getFlightSegmentsList((Flight)flight).stream().map(ExtApiV2AviaConverterHelper::convertBaseSegmentInfo2Rest).allMatch(segment -> ExtApiV2AviaConverterHelper.hasExtendedFare(segment, (EntityReference<SMSite>)parameters.getSalesContext().getSite())));
        return result;
    }

    public static void addFlightToMatrix(Flight flight, Map<String, Map<String, ExtApiV2MatrixFlightWithGap>> to, AviaPriceComponents priceComponents, Pair<org.joda.time.LocalDate> requestedDates, PriceDisplayStyle priceDisplayStyle) {
        ExtApiV2MatrixFlightWithGap candidate = ExtApiV2AviaConverterHelper.convertMatrixFlight2Rest(flight, priceComponents, requestedDates, priceDisplayStyle);
        Map<String, ExtApiV2MatrixFlightWithGap> departuresFrom = Optional.ofNullable(to.get(candidate.getDepartureTo().toString())).orElseGet(ExtApiV2AviaConverterHelper.addMatrixDepartures(to, candidate));
        Days gapTo = Days.daysBetween((ReadablePartial)((ReadablePartial)requestedDates.getFirst()), (ReadablePartial)candidate.getDepartureTo());
        Days gapFrom = Days.ZERO;
        if (requestedDates.getLast() != null) {
            gapFrom = Days.daysBetween((ReadablePartial)((ReadablePartial)requestedDates.getLast()), (ReadablePartial)candidate.getDepartureFrom());
        }
        candidate.setGapToRequiredDates(Math.abs(gapTo.getDays()) + Math.abs(gapFrom.getDays()));
        candidate.setMaxGapToRequiredDates(Math.max(Math.abs(gapTo.getDays()), Math.abs(gapFrom.getDays())));
        departuresFrom.putIfAbsent(candidate.getDepartureFrom().toString(), candidate);
        ExtApiV2MatrixFlightWithGap cheapestByDate = departuresFrom.get(candidate.getDepartureFrom().toString());
        if (ExtApiV2CommonConverterHelper.MONEY_COMPARATOR.compare(cheapestByDate.getPrice(), candidate.getPrice()) > 0) {
            departuresFrom.put(candidate.getDepartureFrom().toString(), candidate);
        }
    }

    private static Supplier<Map<String, ExtApiV2MatrixFlightWithGap>> addMatrixDepartures(Map<String, Map<String, ExtApiV2MatrixFlightWithGap>> to, ExtApiV2MatrixFlightWithGap candidate) {
        return () -> {
            HashMap<String, ExtApiV2MatrixFlightWithGap> departures = new HashMap<String, ExtApiV2MatrixFlightWithGap>();
            departures.put(candidate.getDepartureFrom().toString(), candidate);
            to.put(candidate.getDepartureTo().toString(), departures);
            return departures;
        };
    }

    private static ExtApiV2MatrixFlightWithGap convertMatrixFlight2Rest(Flight flight, AviaPriceComponents priceComponents, Pair<org.joda.time.LocalDate> requestedDates, PriceDisplayStyle priceDisplayStyle) {
        ExtApiV2MatrixFlightWithGap result = new ExtApiV2MatrixFlightWithGap();
        List flightLegs = FlightHelper.getFlightLegs((Flight)flight);
        result.setCarrier(flight.getCarrier());
        result.setDepartureTo(new org.joda.time.LocalDate((Object)((FlightSegment)((List)flightLegs.get(0)).get(0)).getDateBegin()));
        result.setDepartureFrom(new org.joda.time.LocalDate((Object)((FlightSegment)((List)flightLegs.get(flightLegs.size() - 1)).get(0)).getDateBegin()));
        result.setPrice(ExtApiV2CommonConverterHelper.convertMoney2Rest((BigDecimal)AviaHelper.getPriceByDisplayStyle(priceDisplayStyle, priceComponents, AviaHelper.getAdultsType(flight.getSeats())), (String)priceComponents.getCurrency()));
        Pair flightDates = new Pair((Object)result.getDepartureTo(), (Object)result.getDepartureFrom());
        if (requestedDates.equals((Object)flightDates)) {
            result.setCurrent(true);
        }
        if (result.getDepartureTo().equals(requestedDates.getFirst()) && requestedDates.getLast() == null) {
            result.setCurrent(true);
        }
        return result;
    }

    public static String convertFlight2RestToken(ExtApiV2AviaToken token) throws Exception {
        return Base64.encode((byte[])GZIPUtil.gzip((byte[])XSUtil.toString((XSSerializable)token).getBytes(StandardCharsets.UTF_8)));
    }

    public static ExtApiV2AviaToken convertRestToken2Flight(String token) throws Exception {
        ExtApiV2AviaToken result = new ExtApiV2AviaToken();
        try {
            XUtil.fromString((String)new String(GZIPUtil.gunzip((byte[])Base64.decode((String)token)), StandardCharsets.UTF_8), (XSerializable)result);
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)"Error converting token to flight", (Throwable)e, (Object[])new Object[0]);
        }
        return result;
    }

    public static void addFlightToBestPrices(Flight flight, Map<ExtApiV2ConnectionsRestriction, ExtApiV2BestFlights> bestFlights, GeneralPriceComponents priceComponents) {
        boolean toReplace;
        ExtApiV2ConnectionsRestriction cr = ExtApiV2AviaConverterHelper.getConnectionRestriction(flight);
        if (!bestFlights.containsKey(cr)) {
            bestFlights.put(cr, new ExtApiV2BestFlights());
        }
        ExtApiV2BestFlight candidate = ExtApiV2AviaConverterHelper.convertBestFlight2Rest(flight, priceComponents);
        List bestByConnection = bestFlights.get(cr).getBestFlights();
        boolean hasBestByConnectionAndAirline = bestByConnection.stream().anyMatch(bf -> bf.getCarrier().equals((Object)candidate.getCarrier()));
        boolean bl = toReplace = hasBestByConnectionAndAirline && bestByConnection.removeIf(bf -> bf.getCarrier().equals((Object)candidate.getCarrier()) && ExtApiV2CommonConverterHelper.MONEY_COMPARATOR.compare(bf.getPrice(), candidate.getPrice()) > 0);
        if (!hasBestByConnectionAndAirline || toReplace) {
            bestByConnection.add(candidate);
        }
    }

    private static ExtApiV2ConnectionsRestriction getConnectionRestriction(Flight flight) {
        int connectionsCount = 0;
        int legConnections = 0;
        for (FlightSegmentTariff st : flight.getSegmentTariffs()) {
            for (FlightSegment seg : st.getSegments()) {
                if (seg.isStarting()) {
                    if (legConnections > connectionsCount) {
                        connectionsCount = legConnections;
                    }
                    legConnections = 0;
                    continue;
                }
                ++legConnections;
            }
        }
        if (legConnections > connectionsCount) {
            connectionsCount = legConnections;
        }
        ExtApiV2ConnectionsRestriction result = connectionsCount == 0 ? ExtApiV2ConnectionsRestriction.DIRECT : (connectionsCount == 1 ? ExtApiV2ConnectionsRestriction.ONE_CONNECTION : ExtApiV2ConnectionsRestriction.TWO_CONNECTIONS);
        return result;
    }

    private static List<ExtApiV2FlightSegment> convertFlightSegments2Rest(Flight flight, PriceComponentsParameters priceComponentsParameters) {
        DictionaryReference<PassengerType> mainPassengerType = ExtApiV2AviaConverterHelper.findMainPassengerType(flight);
        return FlightHelper.getFlightSegmentsStream((Flight)flight).map(fs -> ExtApiV2AviaConverterHelper.convertFlightSegment2Rest(fs, mainPassengerType, priceComponentsParameters)).collect(Collectors.toList());
    }

    private static ExtApiV2FlightSegment convertFlightSegment2Rest(FlightSegment segment, DictionaryReference<PassengerType> mainPassengerType, PriceComponentsParameters priceComponentsParameters) {
        ExtApiV2FlightSegment result = ExtApiV2AviaConverterHelper.convertBaseSegmentInfo2Rest(segment);
        SegmentInfo segmentInfo = new SegmentInfo(priceComponentsParameters);
        segmentInfo.setBrandedFare(ExtApiV2AviaConverterHelper.findFareInfo(segment, mainPassengerType));
        segment.getFareInfos().forEach(fi -> {
            segmentInfo.addBaseLuggageInfo((DictionaryReference<PassengerType>)fi.getPassengerType(), fi.getLuggageInfo());
            segmentInfo.addBrandedLuggageInfo((DictionaryReference<PassengerType>)fi.getPassengerType(), fi.getFareDetails());
        });
        result.setServicesDetails(ExtApiV2AviaConverterHelper.convertServicesDetails2Rest(segmentInfo));
        segment.getTechStopInfos().forEach(info -> result.getTechStopInfos().add(ExtApiV2AviaConverterHelper.convertTechStopInfosRest(info)));
        return result;
    }

    private static ExtApiV2TechStopInfo convertTechStopInfosRest(TechStopInfo techStopInfo) {
        ExtApiV2TechStopInfo result = new ExtApiV2TechStopInfo();
        result.setLocation(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)techStopInfo.getLocation()));
        result.setArrivalDate(techStopInfo.getArrivalDateTime());
        result.setDepartureDate(techStopInfo.getDepartureDateTime());
        result.setDuration(techStopInfo.getDuration());
        return result;
    }

    private static ExtApiV2FlightSegment convertBaseSegmentInfo2Rest(FlightSegment segment) {
        ExtApiV2FlightSegment result = new ExtApiV2FlightSegment();
        result.setDepartureLocation(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)segment.getLocationBegin()));
        result.setDepartureCityCode(ExtApiV2AviaConverterHelper.getAirportCityCode((DictionaryReference<GeoLocation>)segment.getLocationBegin()));
        result.setDepartureDate(LocalDateTime.ofInstant(segment.getDateBegin().toInstant(), ZoneId.systemDefault()));
        result.setArrivalLocation(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)segment.getLocationBegin()));
        result.setArrivalCityCode(ExtApiV2AviaConverterHelper.getAirportCityCode((DictionaryReference<GeoLocation>)segment.getLocationBegin()));
        result.setArrivalDate(LocalDateTime.ofInstant(segment.getDateEnd().toInstant(), ZoneId.systemDefault()));
        result.setAirline(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)segment.getAirline()));
        result.setOperatingAirline(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)segment.getOperatingAirline()));
        result.setFlightNumber(segment.getFlightNumber());
        result.setStops(Integer.valueOf(segment.getStops()));
        result.setAircraftCode(segment.getBoard() != null ? segment.getBoard().getCode() : null);
        result.setTravelDuration(Integer.valueOf(segment.getTravelDuration()));
        result.setStarting(segment.isStarting());
        result.setClassOfServiceCode(segment.getBookingClass());
        result.setClassOfService(segment.getServiceClass());
        return result;
    }

    private static ExtApiV2ServicesDetails convertServicesDetails2Rest(SegmentInfo segmentInfo) {
        ExtApiV2ServicesDetails result = new ExtApiV2ServicesDetails();
        result.getFreeLuggage().putAll(segmentInfo.getFreeLuggageInfo());
        result.getPaidLuggage().putAll(segmentInfo.getPaidLuggageInfo());
        result.getFreeCabinLuggage().putAll(segmentInfo.getFreeCabinLuggageInfo());
        result.getPaidCabinLuggage().putAll(segmentInfo.getPaidCabinLuggageInfo());
        FareDetails fareDetails = segmentInfo.getBrandedFare();
        if (fareDetails != null) {
            result.setTariffName(GDSHelper.getDisplayBrandName((FareDetails)fareDetails, (Locale)LocaleHelper.RU_LOCALE));
            result.setExtraMileageBonus(fareDetails.getExtraMileageBonus());
            result.setClassUpgradeAvailable(fareDetails.getClassUpgradeAvailable());
            result.setBusinessLoungeAccess(fareDetails.getBusinessLoungeAccess());
            result.setPriorityBoarding(fareDetails.getPriorityBoarding());
            result.setTransferIncluded(fareDetails.getTransferIncluded());
        }
        return result;
    }

    private static FareDetails findFareInfo(FlightSegment flightSegment, DictionaryReference<PassengerType> mainPassengerType) {
        FareInfo fareInfo = flightSegment.getFareInfos().stream().filter(p -> p.getPassengerType().equals((Object)mainPassengerType)).findFirst().orElse(null);
        if (fareInfo == null) {
            fareInfo = flightSegment.getFareInfos().stream().findFirst().orElse(null);
        }
        if (fareInfo != null) {
            return fareInfo.getFareDetails();
        }
        return null;
    }

    private static ExtApiV2ExtendedLuggage convertLuggageInfo2Rest(LuggageInfo luggageInfo) {
        if (luggageInfo != null) {
            ExtApiV2ExtendedLuggage result = new ExtApiV2ExtendedLuggage();
            result.setNil(Boolean.valueOf(luggageInfo.isNil()));
            result.setPieces(luggageInfo.getQuantity());
            result.setUnit(ExtApiV2AviaConverterHelper.convertLuggageUnit2Rest((DictionaryReference<LuggageUnit>)luggageInfo.getUnit()));
            return result;
        }
        return null;
    }

    private static LuggageInfo convertRestLuggage(ExtApiV2ExtendedLuggage luggage) {
        if (luggage != null) {
            LuggageInfo info = new LuggageInfo();
            info.setNil(luggage.isNil().booleanValue());
            info.setQuantity(luggage.getPieces());
            info.setUnit(ExtApiV2AviaConverterHelper.convertRestLuggageUnit(luggage.getUnit()));
            return info;
        }
        return null;
    }

    private static ExtApiV2ExtendedLuggage convertPaidLuggageInfo2Rest(ExtendedLuggageInfo luggageInfo, Money price) {
        if (luggageInfo == null && price == null) {
            return null;
        }
        ExtApiV2ExtendedLuggage result = new ExtApiV2ExtendedLuggage();
        if (luggageInfo != null) {
            result.setPieces(luggageInfo.getPieces());
            result.setWeight(luggageInfo.getWeight());
            result.setWeightUnit(luggageInfo.getWeightUnit());
            result.setLength(luggageInfo.getLength());
            result.setWidth(luggageInfo.getWidth());
            result.setHeight(luggageInfo.getHeight());
            result.setDimensionsSum(luggageInfo.getDimensionsSum());
            result.setDimensionUnit(luggageInfo.getDimensionUnit());
        }
        if (price != null) {
            result.setPrice(ExtApiV2CommonConverterHelper.convertMoney2Rest((BigDecimal)price.getValue(), (String)price.getCurrency()));
        }
        return result;
    }

    private static ExtendedLuggageInfo convertPaidRestLuggage(ExtApiV2ExtendedLuggage luggage, FareDetails fareDetails) {
        if (luggage != null) {
            ExtendedLuggageInfo result = new ExtendedLuggageInfo();
            result.setPieces(luggage.getPieces());
            result.setWeight(luggage.getWeight());
            result.setWeightUnit(luggage.getWeightUnit());
            result.setLength(luggage.getLength());
            result.setWidth(luggage.getWidth());
            result.setHeight(luggage.getHeight());
            result.setDimensionsSum(luggage.getDimensionsSum());
            result.setDimensionUnit(luggage.getDimensionUnit());
            if (fareDetails != null) {
                fareDetails.setPaidLuggagePrice(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)luggage.getPrice()));
            }
            return result;
        }
        return null;
    }

    private static String convertLuggageUnit2Rest(DictionaryReference<LuggageUnit> unitRef) {
        if (unitRef != null) {
            LuggageUnit unit = (LuggageUnit)DictionaryCache.get().resolveReference(unitRef);
            if (unit != null && !unit.getSpellVariants().isEmpty()) {
                Locale locale = LocaleHelper.getCurrentLocale();
                return (String)ExtApiV2CommonConverterHelper.findByLocale((Map)unit.getTranslations(), (Locale)locale);
            }
            return unitRef.getCode();
        }
        return null;
    }

    private static DictionaryReference<LuggageUnit> convertRestLuggageUnit(String unit) {
        Set searchResult;
        if (TextUtil.nonBlank((String)unit) && !(searchResult = DictionaryCache.get().search(LuggageUnit.class, unit)).isEmpty()) {
            return ((LuggageUnit)searchResult.iterator().next()).toReference();
        }
        return null;
    }

    private static ExtApiV2ProductSegment convertProductSegment2Rest(Segment segment) {
        ExtApiV2ProductSegment result = ExtApiV2AviaConverterHelper.convertBaseSegmentInfo2Rest(segment);
        ExtApiV2ProductSegmentDetails details = new ExtApiV2ProductSegmentDetails();
        details.setFreeLuggage(ExtApiV2AviaConverterHelper.convertLuggageInfo2Rest(segment.getLuggageInfo()));
        result.setServicesDetails(details);
        if (segment.getFareDetails() != null) {
            FareDetails fareDetails = segment.getFareDetails();
            details.setTariffName(GDSHelper.getDisplayBrandName((FareDetails)fareDetails, (Locale)LocaleHelper.RU_LOCALE));
            details.setMealService(fareDetails.getMealService());
            details.setPaidLuggage(ExtApiV2AviaConverterHelper.convertPaidLuggageInfo2Rest(fareDetails.getLuggageInfo(), fareDetails.getPaidLuggagePrice()));
        }
        return result;
    }

    private static ExtApiV2ProductSegment convertBaseSegmentInfo2Rest(Segment segment) {
        ExtApiV2ProductSegment result = new ExtApiV2ProductSegment();
        result.setUid(segment.getUid());
        result.setDepartureLocation(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)segment.getDepartureLocation()));
        result.setDepartureCityCode(ExtApiV2AviaConverterHelper.getAirportCityCode((DictionaryReference<GeoLocation>)segment.getDepartureLocation()));
        if (segment.getStartDate() != null) {
            result.setDepartureDate(LocalDateTime.ofInstant(segment.getStartDate().toInstant(), ZoneId.systemDefault()));
        }
        result.setArrivalLocation(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)segment.getArriveLocation()));
        result.setArrivalCityCode(ExtApiV2AviaConverterHelper.getAirportCityCode((DictionaryReference<GeoLocation>)segment.getArriveLocation()));
        if (segment.getEndDate() != null) {
            result.setArrivalDate(LocalDateTime.ofInstant(segment.getEndDate().toInstant(), ZoneId.systemDefault()));
        }
        result.setAirline(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)segment.getAirline()));
        result.setOperatingAirline(ExtApiV2DictionaryConverterHelper.convertDictionaryItem2Rest((DictionaryReference)segment.getCodeShareCarrier()));
        result.setFlightNumber(segment.getFlightNo());
        result.setAircraftCode(segment.getBoard() != null ? segment.getBoard().getCode() : null);
        result.setArriveTerminal(segment.getArriveTerminal());
        result.setDepartTerminal(segment.getDepartTerminal());
        result.setNotValidBefore(DateUtils.toLocalDate((Date)segment.getNotValidBefore()));
        result.setNotValidAfter(DateUtils.toLocalDate((Date)segment.getNotValidAfter()));
        result.setSeatNumber(segment.getSeatNo());
        result.setStops(segment.getNoOfStops());
        result.setTravelDuration(segment.getFlightDuration());
        result.setStarting(segment.isStarting());
        result.setClassOfServiceCode(segment.getClassOfSvcCode());
        result.setClassOfService(DictHelper.findClassOfService((Segment)segment, (Date)segment.getStartDate()));
        result.setFareBasis(segment.getFareBasis());
        result.setAirlineLocator(segment.getAirlineLocator());
        result.setRecordNumber(segment.getRecordNumber());
        result.setFlightDistanceMiles(segment.getFlightDistanceMiles());
        return result;
    }

    private static void convertRestSegment(ExtApiV2ProductSegment restSegment, Segment momSegment) {
        ExtApiV2AviaConverterHelper.convertRestSegment2BaseSegmentInfo(restSegment, momSegment);
        if (restSegment.getServicesDetails() != null) {
            ExtApiV2ProductSegmentDetails details = restSegment.getServicesDetails();
            FareDetails fareDetails = new FareDetails();
            momSegment.setFareDetails(fareDetails);
            momSegment.setLuggageInfo(ExtApiV2AviaConverterHelper.convertRestLuggage(details.getFreeLuggage()));
            fareDetails.setLuggageInfo(ExtApiV2AviaConverterHelper.convertPaidRestLuggage(details.getPaidLuggage(), fareDetails));
            if (details.getTariffName() != null) {
                L10nStringHelper.setValue((L10nString)fareDetails.getBrandName(), (String)details.getTariffName(), (Locale)Locale.ROOT);
            }
            fareDetails.setMealService(details.getMealService());
        }
    }

    private static void convertRestSegment2BaseSegmentInfo(ExtApiV2ProductSegment restSegment, Segment momSegment) {
        Date departureDate = DateUtils.toJavaDate((LocalDateTime)restSegment.getDepartureDate());
        momSegment.setDepartureLocation(ExtApiV2AviaConverterHelper.getAirportLocation(restSegment.getDepartureLocation()));
        momSegment.setDepartCityCode(restSegment.getDepartureCityCode());
        momSegment.setStartDate(departureDate);
        momSegment.setArriveLocation(ExtApiV2AviaConverterHelper.getAirportLocation(restSegment.getArrivalLocation()));
        momSegment.setArriveCityCode(restSegment.getArrivalCityCode());
        momSegment.setEndDate(DateUtils.toJavaDate((LocalDateTime)restSegment.getArrivalDate()));
        momSegment.setAirline(ExtApiV2DictionaryConverterHelper.getAirlineFromDictionaryWrapper((ExtApiV2DictionaryWrapper)restSegment.getAirline(), (Date)departureDate));
        momSegment.setCodeShareCarrier(ExtApiV2DictionaryConverterHelper.getAirlineFromDictionaryWrapper((ExtApiV2DictionaryWrapper)restSegment.getOperatingAirline(), (Date)departureDate));
        DictHelper.getAircraftsByAnyCode((String)restSegment.getAircraftCode()).stream().findFirst().ifPresent(aircraft -> momSegment.setBoard((DictionaryReference)aircraft.toReference()));
        momSegment.setFlightNo(restSegment.getFlightNumber());
        momSegment.setFareBasis(restSegment.getFareBasis());
        momSegment.setNoOfStops(restSegment.getStops());
        momSegment.setFlightDuration(restSegment.getTravelDuration());
        momSegment.setStarting(restSegment.isStarting());
        momSegment.setArriveTerminal(restSegment.getArriveTerminal());
        momSegment.setDepartTerminal(restSegment.getDepartTerminal());
        momSegment.setNotValidBefore(DateUtils.toJavaDate((LocalDate)restSegment.getNotValidBefore()));
        momSegment.setNotValidAfter(DateUtils.toJavaDate((LocalDate)restSegment.getNotValidAfter()));
        momSegment.setSeatNo(restSegment.getSeatNumber());
        momSegment.setClassOfSvcCode(restSegment.getClassOfServiceCode());
        momSegment.setServiceClass(restSegment.getClassOfService());
        momSegment.setFlightDistanceMiles(restSegment.getFlightDistanceMiles());
        momSegment.setAirlineLocator(restSegment.getAirlineLocator());
        momSegment.setRecordNumber(restSegment.getRecordNumber());
    }

    private static DictionaryReference<GeoLocation> getAirportLocation(ExtApiV2DictionaryWrapper wrapper) {
        Set geoLocations = ExtApiV2DictionaryConverterHelper.lookupDictionaryWrapper(GeoLocation.class, (ExtApiV2DictionaryWrapper)wrapper);
        return geoLocations.stream().filter(loc -> loc.getType() == LocationType.AIRPORT).map(GeoLocation::toReference).findFirst().orElse(null);
    }

    private static Segment findSameSegment(Segment segment, List<Segment> segments) {
        return segments.stream().filter(s -> AviaHelper.isSameProductSegment(s, segment)).findFirst().orElse(null);
    }

    public static ExtApiV2Flight convertFlight2Rest(Flight gdsFlight, PriceComponentsParameters parameters, SMGeneralSettings generalSettings, boolean displayTimeLimit) {
        VisaRequirement vr;
        ExtApiV2Flight result = new ExtApiV2Flight();
        PenaltiesResolver penaltiesResolver = new PenaltiesResolver(gdsFlight);
        result.getExchange().putAll(Penalty2RestConverter.convertExchangeInfo(penaltiesResolver.getPenaltiesInfos(), parameters));
        result.getRefund().putAll(Penalty2RestConverter.convertRefundInfo(penaltiesResolver.getPenaltiesInfos(), parameters));
        result.getLegs().addAll(ExtApiV2AviaConverterHelper.convertLegs2Rest(ExtApiV2AviaConverterHelper.convertFlightSegments2Rest(gdsFlight, parameters)));
        result.setServicesStatuses(ExtApiV2AviaConverterHelper.convertServicesStatuses2Rest(result));
        if (generalSettings != null && displayTimeLimit) {
            result.setTimeLimit(ExtApiV2AviaConverterHelper.getCorrectTimeLimit(gdsFlight.getTimeLimit(), generalSettings));
            result.setTimeLimitCity(ExtApiV2AviaConverterHelper.getTimeLimitCity(generalSettings));
        }
        result.setTripartiteContractDiscountApplied(AviaConverterHelper.isTripartiteContractDiscountApplied(gdsFlight));
        result.setCarrier(gdsFlight.getCarrier());
        result.setAirlineAlliance(((Airline)DictionaryCache.get().resolveReference(gdsFlight.getCarrier())).getAlliance());
        result.setPrice(ExtApiV2AviaConverterHelper.convertPriceComponents2Rest(AviaPriceComponents.builder(gdsFlight, parameters).build()));
        result.getSeats().addAll(ExtApiV2AviaConverterHelper.convertSeatPreferences2Rest(gdsFlight.getSeats()));
        if (!gdsFlight.getVisaRequirements().isEmpty() && ((vr = (VisaRequirement)gdsFlight.getVisaRequirements().get(0)).isDocoNeeded() || vr.isDocaNeeded())) {
            ExtApiV2DocoDocaNeededInfo info = new ExtApiV2DocoDocaNeededInfo();
            info.setCountry(vr.getCountry());
            info.setDocaNeeded(vr.isDocaNeeded());
            info.setDocoNeeded(vr.isDocoNeeded());
            result.setDocoDocaNeededInfo(info);
        }
        ExtApiV2AviaConverterHelper.addTravelPolicyInfo(gdsFlight.getTravelPolicyImpositionResult(), (ExtApiV2HasTravelPolicyCompliance)result);
        return result;
    }

    private static void addTravelPolicyInfo(TravelPolicyImpositionResult src, ExtApiV2HasTravelPolicyCompliance dest) {
        ExtApiV2TravelPolicyRule rule;
        if (src == null) {
            dest.setTravelPolicyCompliance(null);
            return;
        }
        ExtApiV2TravelPolicyCompliance result = new ExtApiV2TravelPolicyCompliance();
        if (src.isRecommended()) {
            result.setRecommended(true);
            rule = new ExtApiV2TravelPolicyRule();
            rule.setAction(TravelPolicyAction.RECOMMENDED);
            result.getRulesApplied().add(rule);
        }
        if (src.getMatchType() != null) {
            switch (src.getMatchType()) {
                case VIOLATION: {
                    rule = new ExtApiV2TravelPolicyRule();
                    rule.setAction(TravelPolicyAction.VIOLATION);
                    rule.getRuleDetails().addAll(src.getRuleDetails());
                    result.getRulesApplied().add(rule);
                    break;
                }
                case STRICT_VIOLATION: {
                    rule = new ExtApiV2TravelPolicyRule();
                    rule.setAction(TravelPolicyAction.STRICT_VIOLATION);
                    rule.getRuleDetails().addAll(src.getRuleDetails());
                    result.getRulesApplied().add(rule);
                    break;
                }
                case HIDE: {
                    rule = new ExtApiV2TravelPolicyRule();
                    rule.setAction(TravelPolicyAction.HIDE);
                    result.getRulesApplied().add(rule);
                    break;
                }
            }
        }
        if (src.getAuthorizationParameters() != null) {
            rule = new ExtApiV2TravelPolicyRule();
            rule.setAction(TravelPolicyAction.AUTHORIZATION_REQUIRED);
            result.getRulesApplied().add(rule);
        }
        if (CollectionUtil.isEmpty((Collection)result.getRulesApplied())) {
            dest.setTravelPolicyCompliance(null);
            return;
        }
        dest.setTravelPolicyCompliance(result);
    }

    public static boolean isInternationalFlight(Flight flight) {
        for (FlightSegment segment : FlightHelper.getSegments((Flight)flight)) {
            if (!ExtApiV2AviaConverterHelper.isDomesticCountry((DictionaryReference<GeoLocation>)segment.getLocationBegin())) {
                return true;
            }
            if (ExtApiV2AviaConverterHelper.isDomesticCountry((DictionaryReference<GeoLocation>)segment.getLocationEnd())) continue;
            return true;
        }
        return false;
    }

    private static boolean isDomesticCountry(DictionaryReference<GeoLocation> locationRef) {
        GeoLocation location = (GeoLocation)DictionaryCache.get().resolveReference(locationRef);
        Country country = (Country)DictionaryCache.get().resolveReference(location.getCountry());
        return country.isDomestic();
    }

    private static List<ExtApiV2SeatDescription> convertSeatPreferences2Rest(List<SeatPreferences> seatPreferences) {
        return GDSHelper.seatPreferencesToMap(seatPreferences).entrySet().stream().sorted((es1, es2) -> ExtApiV2AviaConverterHelper.sortByPassengerType((DictionaryReference<PassengerType>)((DictionaryReference)es1.getKey()), (DictionaryReference<PassengerType>)((DictionaryReference)es2.getKey()))).map(ExtApiV2AviaConverterHelper::convertSeatDescription2Rest).collect(Collectors.toList());
    }

    private static ExtApiV2SeatDescription convertSeatDescription2Rest(Map.Entry<DictionaryReference<PassengerType>, Integer> e) {
        ExtApiV2SeatDescription sd = new ExtApiV2SeatDescription();
        sd.setType(e.getKey());
        sd.setCount(e.getValue().intValue());
        return sd;
    }

    private static ExtApiV2ServicesStatuses convertServicesStatuses2Rest(ExtApiV2Flight flight) {
        ExtApiV2ServicesStatuses result = new ExtApiV2ServicesStatuses();
        result.setBaggage(ExtApiV2AviaConverterHelper.getBaggageServiceStatus(flight.getLegs().stream().flatMap(l -> l.getSegments().stream()).collect(Collectors.toList())));
        result.setRefund(ExtApiV2AviaConverterHelper.getRefundServiceStatus(flight.getRefund()));
        result.setExchange(ExtApiV2AviaConverterHelper.getExchangeServiceStatus(flight.getExchange()));
        return result;
    }

    private static ExtApiV2ServiceStatus getRefundServiceStatus(Map<DictionaryReference<PassengerType>, ExtApiV2RefundPenaltiesInfo> refundInfo) {
        for (ExtApiV2RefundPenaltiesInfo refundPenaltiesInfo : refundInfo.values()) {
            if (refundPenaltiesInfo == null) {
                return ExtApiV2ServiceStatus.OFF;
            }
            if (!Optional.ofNullable(refundPenaltiesInfo.isRefundableBeforeDeparture()).orElse(false).booleanValue() && !Optional.ofNullable(refundPenaltiesInfo.isRefundableAfterDeparture()).orElse(false).booleanValue()) {
                return ExtApiV2ServiceStatus.OFF;
            }
            if (Optional.ofNullable(refundPenaltiesInfo.isRefundableBeforeDeparture()).orElse(false).booleanValue() && refundPenaltiesInfo.getRefundBeforeDeparture() != null && refundPenaltiesInfo.getRefundBeforeDeparture().getAmount() > 0.0) {
                return ExtApiV2ServiceStatus.PAID;
            }
            if (!Optional.ofNullable(refundPenaltiesInfo.isRefundableAfterDeparture()).orElse(false).booleanValue() || refundPenaltiesInfo.getRefundAfterDeparture() == null || !(refundPenaltiesInfo.getRefundAfterDeparture().getAmount() > 0.0)) continue;
            return ExtApiV2ServiceStatus.PAID;
        }
        return ExtApiV2ServiceStatus.FREE;
    }

    private static ExtApiV2ServiceStatus getExchangeServiceStatus(Map<DictionaryReference<PassengerType>, ExtApiV2ExchangePenaltiesInfo> refundInfo) {
        for (ExtApiV2ExchangePenaltiesInfo exchangePenaltiesInfo : refundInfo.values()) {
            if (exchangePenaltiesInfo == null) {
                return ExtApiV2ServiceStatus.OFF;
            }
            if (!Optional.ofNullable(exchangePenaltiesInfo.isExchangeableAfterDeparture()).orElse(false).booleanValue() && !Optional.ofNullable(exchangePenaltiesInfo.isExchangeableAfterDeparture()).orElse(false).booleanValue()) {
                return ExtApiV2ServiceStatus.OFF;
            }
            if (Optional.ofNullable(exchangePenaltiesInfo.isExchangeableBeforeDeparture()).orElse(false).booleanValue() && exchangePenaltiesInfo.getExchangeBeforeDeparture() != null && exchangePenaltiesInfo.getExchangeBeforeDeparture().getAmount() > 0.0) {
                return ExtApiV2ServiceStatus.PAID;
            }
            if (!Optional.ofNullable(exchangePenaltiesInfo.isExchangeableAfterDeparture()).orElse(false).booleanValue() || exchangePenaltiesInfo.getExchangeAfterDeparture() == null || !(exchangePenaltiesInfo.getExchangeAfterDeparture().getAmount() > 0.0)) continue;
            return ExtApiV2ServiceStatus.PAID;
        }
        return ExtApiV2ServiceStatus.FREE;
    }

    private static ExtApiV2ServiceStatus getBaggageServiceStatus(List<ExtApiV2FlightSegment> segmentInfos) {
        boolean isWithoutLuggage = segmentInfos.stream().map(ExtApiV2FlightSegment::getServicesDetails).anyMatch(sd -> {
            Collection<ExtApiV2ExtendedLuggage> luggage = sd.getFreeLuggage().values();
            return ExtApiV2AviaConverterHelper.withoutLuggage(luggage);
        });
        if (isWithoutLuggage) {
            boolean isWithoutPaidLuggage = segmentInfos.stream().map(ExtApiV2FlightSegment::getServicesDetails).anyMatch(sd -> {
                Collection<ExtApiV2ExtendedLuggage> luggage = sd.getPaidLuggage().values();
                return ExtApiV2AviaConverterHelper.withoutLuggage(luggage);
            });
            if (isWithoutPaidLuggage) {
                return ExtApiV2ServiceStatus.PAID;
            }
            return ExtApiV2ServiceStatus.OFF;
        }
        return ExtApiV2ServiceStatus.FREE;
    }

    private static boolean withoutLuggage(Collection<ExtApiV2ExtendedLuggage> luggage) {
        return luggage.isEmpty() || luggage.stream().anyMatch(Objects::isNull) || luggage.stream().filter(Objects::nonNull).anyMatch(el -> Boolean.TRUE.equals(el.isNil()));
    }

    private static DictionaryReference<PassengerType> findMainPassengerType(Flight gdsFlight) {
        Set<DictionaryReference<PassengerType>> passengerTypes = gdsFlight.getSeats().stream().map(SeatPreferences::getPassengerType).collect(Collectors.toSet());
        return ExtApiV2AviaConverterHelper.findMainPassengerType(passengerTypes);
    }

    private static DictionaryReference<PassengerType> findMainPassengerType(Set<DictionaryReference<PassengerType>> passengerTypes) {
        if (passengerTypes.contains(DictHelper.getAdultPassengerType())) {
            return DictHelper.getAdultPassengerType();
        }
        if (passengerTypes.contains(((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.YOUTH)).toReference())) {
            return ((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.YOUTH)).toReference();
        }
        if (passengerTypes.contains(((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.SENIOR)).toReference())) {
            return ((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.SENIOR)).toReference();
        }
        return (DictionaryReference)passengerTypes.stream().findFirst().get();
    }

    private static List<ExtApiV2FlightLeg> convertLegs2Rest(List<ExtApiV2FlightSegment> segmentStream) {
        ArrayList<ExtApiV2FlightLeg> result = new ArrayList<ExtApiV2FlightLeg>();
        segmentStream.forEach(segment -> {
            if (segment.isStarting()) {
                result.add(new ExtApiV2FlightLeg());
            }
            ExtApiV2FlightLeg currentLeg = (ExtApiV2FlightLeg)result.get(result.size() - 1);
            currentLeg.getSegments().add(segment);
        });
        return result;
    }

    private static List<ExtApiV2ProductSegment> convertProductSegments2Rest(PriceComponentsParameters priceComponentsParameters, List<Product> productList, Product product) {
        ArrayList<ExtApiV2ProductSegment> result = new ArrayList<ExtApiV2ProductSegment>();
        AirProductHelper.getProductSegmentsList((Product)product).forEach(s -> {
            ExtApiV2ProductSegment segmentResult = ExtApiV2AviaConverterHelper.convertBaseSegmentInfo2Rest(s);
            segmentResult.setClassOfService(DictHelper.findClassOfService((Segment)s, (Date)product.getIssueDate()));
            SegmentInfo segmentInfo = new SegmentInfo(priceComponentsParameters);
            segmentInfo.setBrandedFare(s.getFareDetails());
            for (Product p : productList) {
                Segment sameSegment = ExtApiV2AviaConverterHelper.findSameSegment(s, AirProductHelper.getProductSegmentsList((Product)p));
                if (sameSegment != null) {
                    segmentInfo.addBaseLuggageInfo((DictionaryReference<PassengerType>)p.getPassengerType(), sameSegment.getLuggageInfo());
                    segmentInfo.addBrandedLuggageInfo((DictionaryReference<PassengerType>)p.getPassengerType(), sameSegment.getFareDetails());
                }
                result.add(segmentResult);
            }
        });
        return result;
    }

    public static ExtApiV2AviaProductPrice convertProductPrice2Rest(Product product) {
        ExtApiV2AviaProductPrice price = new ExtApiV2AviaProductPrice();
        ProductHandler productHandler = HandlersRegistry.get().findProductHandler(product.getClass());
        price.setPenalty(productHandler.getPenalty((BaseProduct)product));
        price.setEquivalentTariff(productHandler.getEquivalentFare((BaseProduct)product));
        price.setTariff(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)productHandler.getProductBaseFare((BaseProduct)product)));
        Money bspCommissionValue = productHandler.getBspCommissionValue((BaseProduct)product);
        if (bspCommissionValue != null) {
            ExtApiV2BSPCommission bspCommission = new ExtApiV2BSPCommission();
            Double rate = productHandler.getBspCommissionRate((BaseProduct)product);
            bspCommission.setValue(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)bspCommissionValue));
            bspCommission.setRate(rate != null ? rate : 0.0);
            price.setBspCommission(bspCommission);
        }
        price.getTaxes().addAll(product.getTaxes().stream().map(tax -> {
            ExtApiV2Tax restTax = new ExtApiV2Tax();
            restTax.setCode(tax.getCode());
            restTax.setAmount(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)tax.getAmount()));
            restTax.setEquivalentAmount(tax.getEquivalentAmount());
            return restTax;
        }).collect(Collectors.toList()));
        price.getObFees().addAll(product.getObFees().stream().map(obFee -> {
            ExtApiV2OBFee restObFee = new ExtApiV2OBFee();
            restObFee.setDescription(obFee.getDescription());
            restObFee.setAmount(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)obFee.getAmount()));
            return restObFee;
        }).collect(Collectors.toList()));
        return price;
    }

    public static void convertRestProductPrice(ExtApiV2AviaProductPrice price, Product product) {
        if (price != null) {
            product.setPenalty(ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)price.getPenalty()));
            ProductFare baseFare = product.getFares().stream().filter(fare -> fare.getSegmentTariff() == null).findFirst().orElseGet(() -> {
                ProductFare f = new ProductFare();
                product.getFares().add(f);
                return f;
            });
            baseFare.setEquivalentFare(ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)price.getEquivalentTariff()));
            baseFare.setBaseFare(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)price.getTariff()));
            ExtApiV2BSPCommission bspCommission = price.getBspCommission();
            if (bspCommission != null) {
                product.setBspCommissionValue(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)bspCommission.getValue()));
                product.setBspCommissionRate(Double.valueOf(bspCommission.getRate()));
            }
            product.getObFees().clear();
            product.getObFees().addAll(price.getObFees().stream().map(restObFee -> {
                OBFee obFee = new OBFee();
                obFee.setDescription(restObFee.getDescription());
                obFee.setAmount(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)restObFee.getAmount()));
                return obFee;
            }).collect(Collectors.toList()));
            ArrayList oldTaxes = new ArrayList(product.getTaxes());
            product.getTaxes().clear();
            product.getTaxes().addAll(price.getTaxes().stream().map(restTax -> {
                Tax tax;
                Optional<Tax> optionalTax = oldTaxes.stream().filter(oldTax -> MiscUtil.equals((Object)restTax.getCode(), (Object)oldTax.getCode())).findFirst();
                if (optionalTax.isPresent()) {
                    oldTaxes.remove(optionalTax.get());
                    tax = optionalTax.get();
                } else {
                    tax = new Tax();
                }
                tax.setCode(restTax.getCode());
                tax.setAmount(ExtApiV2CommonConverterHelper.convertRestMoney((ExtApiV2Money)restTax.getAmount()));
                tax.setEquivalentAmount(ExtApiV2CommonConverterHelper.roundBigDecimalValue((BigDecimal)restTax.getEquivalentAmount()));
                return tax;
            }).collect(Collectors.toList()));
        }
    }

    public static List<ExtApiV2ProductLeg> convertSegmentLegs2Rest(List<SegmentTariff> segmentTariffs) {
        return segmentTariffs.stream().map(segmentTariff -> {
            ExtApiV2ProductLeg restSegmentTariff = new ExtApiV2ProductLeg();
            restSegmentTariff.getSegments().addAll(segmentTariff.getSegments().stream().map(ExtApiV2AviaConverterHelper::convertProductSegment2Rest).collect(Collectors.toList()));
            return restSegmentTariff;
        }).collect(Collectors.toList());
    }

    public static void convertRestProductSegmentLegs(List<SegmentTariff> segmentTariffs, List<ExtApiV2ProductLeg> restSegmentTariffs) {
        List segments = segmentTariffs.stream().flatMap(st -> st.getSegments().stream()).collect(Collectors.toList());
        segmentTariffs.clear();
        segmentTariffs.addAll(restSegmentTariffs.stream().map(restSegmentTariff -> {
            SegmentTariff segmentTariff = new SegmentTariff();
            segmentTariff.getSegments().addAll(restSegmentTariff.getSegments().stream().map(restSeg -> {
                Segment segment = segments.stream().filter(seg -> MiscUtil.equals((Object)seg.getUid(), (Object)restSeg.getUid(), (boolean)false)).findFirst().orElse(new Segment());
                ExtApiV2AviaConverterHelper.convertRestSegment(restSeg, segment);
                return segment;
            }).collect(Collectors.toList()));
            return segmentTariff;
        }).collect(Collectors.toList()));
    }

    public static LocalDateTime getCorrectTimeLimit(Date timeLimit, SMGeneralSettings generalSettings) {
        if (timeLimit == null) {
            return null;
        }
        return LocalDateTime.ofInstant(timeLimit.toInstant(), CommonHelper.getTimeZone(generalSettings).getTimeZone().toZoneId()).minusMinutes(15L);
    }

    public static String getTimeLimitCity(SMGeneralSettings generalSettings) {
        return CommonHelper.getTimeZone(generalSettings).getTimeZoneCity().toString(LocaleManager.get().getCurrentLocale());
    }

    private static ExtApiV2Price convertPriceComponents2Rest(GeneralPriceComponents priceComponents) {
        String currency = priceComponents.getCurrency();
        ExtApiV2Price result = new ExtApiV2Price();
        result.setTotal(ExtApiV2CommonConverterHelper.convertMoney2Rest((BigDecimal)priceComponents.getTotal(), (String)currency));
        result.setTotalFeeAndTaxes(ExtApiV2CommonConverterHelper.convertMoney2Rest((BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{priceComponents.getFee(), priceComponents.getTaxes()}), (String)currency));
        if (priceComponents.getParameters().getDisplayCurrencies() != null && !priceComponents.getParameters().getDisplayCurrencies().isEmpty()) {
            result.getRates().addAll(ExtApiV2ConverterHelper.convertRatesToRest(priceComponents.getRates()));
        }
        if (priceComponents.getParameters().isCalculateSubagentPrice()) {
            result.setTotalSubagent(ExtApiV2CommonConverterHelper.convertMoney2Rest((BigDecimal)priceComponents.getTotalSubagent(), (String)priceComponents.getSubagentCurrency()));
        }
        result.getPassengerPrices().addAll(priceComponents.getPassengers().keySet().stream().map(ExtApiV2AviaConverterHelper.convertPassengerPriceInfo2Rest(priceComponents, currency)).flatMap(Collection::stream).sorted(ExtApiV2AviaConverterHelper.passengerPriceComparator()).collect(Collectors.toList()));
        return result;
    }

    public static Comparator<ExtApiV2PassengerPrice> passengerPriceComparator() {
        return (pp1, pp2) -> {
            int passengerTypeDiff = CommonHelper.sortByPassengerType((DictionaryReference<PassengerType>)pp1.getPassengerType(), (DictionaryReference<PassengerType>)pp2.getPassengerType());
            if (passengerTypeDiff != 0) {
                return passengerTypeDiff;
            }
            return Double.valueOf(pp2.getTariff().getAmount()).compareTo(pp1.getTariff().getAmount());
        };
    }

    private static Function<DictionaryReference<PassengerType>, List<ExtApiV2PassengerPrice>> convertPassengerPriceInfo2Rest(GeneralPriceComponents priceComponents, String currency) {
        return passengerType -> {
            List<GeneralPriceComponents.PassengerPriceStructure> structures = priceComponents.getPassengerPriceStructures((DictionaryReference<PassengerType>)passengerType);
            if (structures.size() == 0) {
                return Collections.emptyList();
            }
            ArrayList<ExtApiV2PassengerPrice> result = new ArrayList<ExtApiV2PassengerPrice>(structures.size());
            for (GeneralPriceComponents.PassengerPriceStructure structure : structures) {
                ExtApiV2PassengerPrice pp = new ExtApiV2PassengerPrice();
                pp.setPassengerType(passengerType);
                pp.setPassengerCount(structure.getPassengerCount().intValue());
                pp.setTariff(ExtApiV2CommonConverterHelper.convertMoney2Rest((BigDecimal)structure.getTariff(), (String)currency));
                pp.setSinglePassengerTotal(ExtApiV2CommonConverterHelper.convertMoney2Rest((BigDecimal)structure.getSinglePassengerTotal(), (String)currency));
                pp.setTotal(ExtApiV2CommonConverterHelper.convertMoney2Rest((BigDecimal)structure.getTotal(), (String)currency));
                pp.setTaxes(ExtApiV2CommonConverterHelper.convertMoney2Rest((BigDecimal)structure.getTaxes(), (String)currency));
                pp.setFee(ExtApiV2CommonConverterHelper.convertMoney2Rest((BigDecimal)structure.getFees(), (String)currency));
                ExtApiV2FeeDetails feeDetails = new ExtApiV2FeeDetails();
                XtripPriceStructure priceStructure = structure.getPriceStructure();
                feeDetails.setAgencyFees(ExtApiV2CommonConverterHelper.convertMoney2Rest((BigDecimal)priceStructure.getAgencyFees(), (String)currency));
                feeDetails.setSupplierFees(ExtApiV2CommonConverterHelper.convertMoney2Rest((BigDecimal)priceStructure.getSupplierFees(), (String)currency));
                feeDetails.setPaymentFees(ExtApiV2CommonConverterHelper.convertMoney2Rest((BigDecimal)priceStructure.getPaymentFees(), (String)currency));
                pp.setFeeDetails(feeDetails);
                result.add(pp);
            }
            return result;
        };
    }

    private static ExtApiV2BestFlight convertBestFlight2Rest(Flight flight, GeneralPriceComponents priceComponents) {
        ExtApiV2BestFlight result = new ExtApiV2BestFlight();
        result.setCarrier(flight.getCarrier());
        result.setPrice(ExtApiV2CommonConverterHelper.convertMoney2Rest((BigDecimal)priceComponents.getTotal(), (String)priceComponents.getCurrency()));
        return result;
    }

    private static DictionaryReference<GeoLocation> getGeoLocationDictReferenceByCode(String code) {
        return DictHelper.toReference((BaseDictionary)DictionaryCache.get().lookup(GeoLocation.class, code, new String[0]).stream().findFirst().orElse(null));
    }

    public static void populateSegment(Date minimumDate, ExtApiV2SearchLeg fl, RouteSegment seg) {
        seg.setLocationBegin(fl.getDeparture());
        seg.setLocationEnd(fl.getArrival());
        ExtApiV2AviaConverterHelper.setDate(minimumDate, fl, seg);
        ExtApiV2AviaConverterHelper.setTimeOfDate(fl, seg);
    }

    private static void setDate(Date minimumDate, ExtApiV2SearchLeg fl, RouteSegment seg) {
        if (Objects.nonNull(minimumDate) && minimumDate.after(fl.getDate().toDate())) {
            seg.setDate(minimumDate);
        } else {
            seg.setDate(fl.getDate().toDate());
        }
    }

    private static void setTimeOfDate(ExtApiV2SearchLeg fl, RouteSegment seg) {
        int timeBegin = 0;
        int timeEnd = 1439;
        if (fl.getDepartureTimeWindowStart() != null) {
            LocalTime localTimeBegin = fl.getDepartureTimeWindowStart();
            timeBegin = localTimeBegin.getHour() * 60 + localTimeBegin.getMinute();
        }
        if (fl.getDepartureTimeWindowEnd() != null) {
            LocalTime localTimeEnd = fl.getDepartureTimeWindowEnd();
            timeEnd = localTimeEnd.getHour() * 60 + localTimeEnd.getMinute();
        }
        seg.setDepartureTimeBegin(Integer.valueOf(timeBegin));
        seg.setDepartureTimeEnd(Integer.valueOf(timeEnd));
    }

    public static Date getMinimumDate(EntityReference<SMSite> siteRef) {
        try {
            long numDaysFromToday = CommonHelper.getGeneralSettings(siteRef).getCalendarSettings().getDaysShift();
            return new Date(System.currentTimeMillis() + numDaysFromToday * 86400000L);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Pair<org.joda.time.LocalDate> getRequestedMatrixDates(ExtApiV2SearchMatrixFlightsParameters parameters) {
        org.joda.time.LocalDate to = ((ExtApiV2SearchLeg)parameters.getFlightLegs().get(0)).getDate();
        org.joda.time.LocalDate from = parameters.getRouteType() == RouteType.ROUNDTRIP ? ((ExtApiV2SearchLeg)parameters.getFlightLegs().get(parameters.getFlightLegs().size() - 1)).getDate() : null;
        return new Pair((Object)to, from);
    }

    public static void setCheapestFlight(Map<String, Map<String, ExtApiV2MatrixFlightWithGap>> to, byte cheapestItemsNumber) {
        List<ExtApiV2MatrixFlightWithGap> cheapestFlights = to.values().stream().map(Map::values).flatMap(Collection::stream).sorted((matrixFlight1, matrixFlight2) -> {
            int priceComparisionResult = ExtApiV2CommonConverterHelper.MONEY_COMPARATOR.compare(matrixFlight1.getPrice(), matrixFlight2.getPrice());
            if (priceComparisionResult != 0) {
                return priceComparisionResult;
            }
            if (matrixFlight1.getGapToRequiredDates() > matrixFlight2.getGapToRequiredDates()) {
                return 1;
            }
            if (matrixFlight1.getGapToRequiredDates() < matrixFlight2.getGapToRequiredDates()) {
                return -1;
            }
            if (matrixFlight1.getMaxGapToRequiredDates() > matrixFlight2.getMaxGapToRequiredDates()) {
                return 1;
            }
            if (matrixFlight1.getMaxGapToRequiredDates() < matrixFlight2.getMaxGapToRequiredDates()) {
                return -1;
            }
            return 0;
        }).limit(cheapestItemsNumber).collect(Collectors.toList());
        if (cheapestFlights.size() > 0) {
            ExtApiV2MatrixFlightWithGap firstCheapestFlight = (ExtApiV2MatrixFlightWithGap)cheapestFlights.get(0);
            if (firstCheapestFlight.isCurrent()) {
                firstCheapestFlight.setCheapest(true);
                return;
            }
            cheapestFlights.forEach(matrixFlight -> matrixFlight.setCheapest(true));
        }
    }

    public static Traveller convertAviaPassenger2Traveler(ExtApiV2Passenger passenger) {
        Traveller result = new Traveller();
        result.setPassport(ExtApiV2PersonHelper.convertRestPassport2Passport((ExtApiV2Passport)passenger.getPassport()));
        result.setName(TextUtil.buildFullName((PersonalName)result.getPassport()));
        result.getCommunications().addAll(ExtApiV2AviaConverterHelper.convertRest2ContactCommunications(passenger));
        result.setPassenger(passenger.getProfileReference());
        if (ExtApiV2AviaValidationHelper.hasAirBonusCard(passenger.getBonusCard())) {
            result.getAirlineBonusCards().add(ExtApiV2CommonConverterHelper.convertRest2AirlineBonusCard((ExtApiV2AirBonusCard)passenger.getBonusCard()));
        }
        if (passenger.getDocoInfo() != null) {
            result.getDocoInformations().add(ExtApiV2AviaConverterHelper.convertRest2DocoInformation(passenger.getDocoInfo()));
        }
        if (passenger.getDocaInfo() != null) {
            result.getDocaInformations().add(ExtApiV2AviaConverterHelper.convertRest2DocaInformation(passenger.getDocaInfo()));
        }
        return result;
    }

    private static DocoInformation convertRest2DocoInformation(ExtApiV2DocoInfo docoInfo) {
        DocoInformation result = new DocoInformation();
        result.setPlaceOfBirthCountry(docoInfo.getPlaceOfBirthCountry());
        result.setPlaceOfBirthCity(docoInfo.getPlaceOfBirthCity());
        result.setPlaceOfBirthState(docoInfo.getPlaceOfBirthState());
        result.setVisaNumber(docoInfo.getVisaNumber());
        result.setVisaIssueDate(docoInfo.getVisaIssueDate().toDate());
        result.setVisaIssuePlace(docoInfo.getVisaIssuePlace());
        result.setVisaApplicableCountry(docoInfo.getVisaApplicableCountry());
        return result;
    }

    private static DocaInformation convertRest2DocaInformation(ExtApiV2DocaInfo docaInfo) {
        DocaInformation result = new DocaInformation();
        result.setCountry(docaInfo.getCountry());
        result.setStateProvince(docaInfo.getStateProvince());
        result.setCity(docaInfo.getCity());
        result.setStreet(docaInfo.getStreet());
        result.setZipPostalCode(docaInfo.getZipPostalCode());
        result.setType(docaInfo.getAddressType());
        return result;
    }

    private static List<Communication> convertRest2ContactCommunications(ExtApiV2Passenger passenger) {
        ArrayList<Communication> result = new ArrayList<Communication>(5);
        if (AviaHelper.hasEmail((DictionaryReference<PassengerType>)passenger.getType()) && TextUtil.nonBlank((String)passenger.getEmail())) {
            result.add(ExtApiV2CommonConverterHelper.convertRest2Communication((String)passenger.getEmail(), (CommunicationType)CommunicationType.EMAIL, Communication::new));
        }
        if (!(passenger.getPhone() == null || TextUtil.isBlank((String)passenger.getPhone().getCityCode()) || TextUtil.isBlank((String)passenger.getPhone().getCountryCode()) || TextUtil.isBlank((String)passenger.getPhone().getNumber()))) {
            result.add(ExtApiV2CommonConverterHelper.convertRestPhone2Communication((ExtApiV2Phone)passenger.getPhone(), (CommunicationType)CommunicationType.MOBILE));
        }
        return result;
    }

    public static Customer convertRest2Customer(ExtApiV2Customer customer) {
        Customer result = new Customer();
        result.setName(customer.getFirstName().concat("-").concat(customer.getLastName()));
        Passport passport = new Passport();
        passport.setFirstName(customer.getFirstName());
        passport.setLastName(customer.getLastName());
        result.setPassport(passport);
        result.getCommunications().add(ExtApiV2CommonConverterHelper.convertRest2Communication((String)customer.getEmail(), (CommunicationType)CommunicationType.EMAIL, Communication::new));
        result.getCommunications().add(ExtApiV2CommonConverterHelper.convertRestPhone2Communication((ExtApiV2Phone)customer.getPhone(), (CommunicationType)CommunicationType.MOBILE));
        return result;
    }

    private static boolean hasExtendedFare(ExtApiV2FlightSegment segment, EntityReference<SMSite> siteRef) {
        return CommonHelper.getStep2Settings(siteRef).getExtendedTariffAirlines().stream().anyMatch(code -> segment.getAirline() != null && segment.getAirline().getCodes().containsValue(code));
    }

    public static ExtApiV2GeoLocationReference convertGeoLocationReference2Rest(GeoLocation location, Locale locale) {
        ExtApiV2GeoLocationReference result = new ExtApiV2GeoLocationReference();
        result.setCode(location.getCode());
        result.setUid(location.getCode());
        result.setIataCode((String)location.getCodeVariants().get(CodeSystem.IATA.name()));
        result.setCrtCode((String)location.getCodeVariants().get(CodeSystem.CRT.name()));
        if (location.getType() == LocationType.CITY) {
            result.setCityCaption((String)ExtApiV2CommonConverterHelper.findByLocale((Map)location.getTranslations(), (Locale)locale));
            result.setCountryCaption((String)ExtApiV2CommonConverterHelper.findByLocale((Map)((Country)DictionaryCache.get().resolveReference(location.getCountry())).getTranslations(), (Locale)locale));
            result.setType(ExtApiV2GeoLocationType.CITY);
        } else if (location.getType() == LocationType.AIRPORT) {
            GeoLocation city = (GeoLocation)DictionaryCache.get().resolveReference(location.getParent());
            result.setAirportCaption((String)ExtApiV2CommonConverterHelper.findByLocale((Map)location.getTranslations(), (Locale)locale));
            result.setCityCaption((String)ExtApiV2CommonConverterHelper.findByLocale((Map)city.getTranslations(), (Locale)locale));
            result.setCountryCaption((String)ExtApiV2CommonConverterHelper.findByLocale((Map)((Country)DictionaryCache.get().resolveReference(city.getCountry())).getTranslations(), (Locale)locale));
            result.setType(ExtApiV2GeoLocationType.AIRPORT);
        } else {
            throw new IllegalArgumentException("unexpected location type " + location.getType());
        }
        return result;
    }

    public static ExtApiV2AirlineReference convertAirlineReference2Rest(Airline airline, Locale locale) {
        AirlineAlliance alliance;
        Country country;
        ExtApiV2AirlineReference result = new ExtApiV2AirlineReference();
        result.setCode(airline.getCode());
        result.setUid(airline.getCode());
        result.setNumber(airline.getAirlineNumber());
        result.setAirportCaption((String)ExtApiV2CommonConverterHelper.findByLocale((Map)airline.getTranslations(), (Locale)locale));
        if (airline.getCountry() != null && (country = (Country)DictionaryCache.get().resolveReference(airline.getCountry())) != null) {
            result.setCountryCaption((String)ExtApiV2CommonConverterHelper.findByLocale((Map)country.getTranslations(), (Locale)locale));
        }
        if (airline.getAlliance() != null && (alliance = (AirlineAlliance)DictionaryCache.get().resolveReference(airline.getAlliance())) != null) {
            result.setAlliance((String)ExtApiV2CommonConverterHelper.findByLocale((Map)alliance.getTranslations(), (Locale)locale));
        }
        StringBuilder searchString = new StringBuilder();
        airline.getTranslations().entrySet().forEach(e -> searchString.append((String)e.getValue()).append(" "));
        result.setSearchString(searchString.toString());
        return result;
    }

    private static String getAirportCityCode(DictionaryReference<GeoLocation> airport) {
        DictionaryReference<GeoLocation> city = ExtApiV2AviaConverterHelper.getAirportCity(airport);
        return city != null ? city.getCode() : null;
    }

    private static DictionaryReference<GeoLocation> getAirportCity(DictionaryReference<GeoLocation> airport) {
        GeoLocation airportLocation = (GeoLocation)DictionaryCache.get().resolveReference(airport);
        if (airportLocation != null && airportLocation.getType() == LocationType.AIRPORT) {
            DictionaryReference city = airportLocation.getParent();
            GeoLocation cityLocation = (GeoLocation)DictionaryCache.get().resolveReference(city);
            if (cityLocation != null && cityLocation.getType() == LocationType.CITY) {
                return city;
            }
        }
        return null;
    }

    private static ExtApiV2DictionaryItem convertDictionaryReference2RestDictionaryItem(DictionaryReference<? extends BaseDictionary> dictRef) {
        ExtApiV2DictionaryItem result = new ExtApiV2DictionaryItem();
        if (StringUtils.isNotEmpty((String)dictRef.getCaption())) {
            result.setCaption(dictRef.getCaption());
        } else {
            BaseDictionary bd = DictionaryCache.get().resolveReference(dictRef);
            String caption = null;
            if (bd != null) {
                Locale locale = LocaleManager.get().getCurrentLocale();
                caption = (String)MiscUtil.findByLocale((Map)bd.getTranslations(), (Locale)locale);
                if (TextUtil.isBlank((String)caption) && !MiscUtil.equals((Object)locale, (Object)Locale.ENGLISH)) {
                    caption = (String)MiscUtil.findByLocale((Map)bd.getTranslations(), (Locale)Locale.ENGLISH);
                }
            }
            result.setCaption(caption);
            if (StringUtils.isEmpty((String)result.getCaption())) {
                if (StringUtils.isNotEmpty((String)dictRef.getCode())) {
                    result.setCaption(dictRef.getCode());
                } else {
                    result.setCaption(dictRef.toString());
                }
            }
        }
        result.setUid(dictRef.getCode());
        return result;
    }

    private static int sortByPassengerType(DictionaryReference<PassengerType> pt1, DictionaryReference<PassengerType> pt2) {
        return com.gridnine.xtrip.common.ibecorp.common.CommonHelper.getPassengerTypeRank(pt2) - com.gridnine.xtrip.common.ibecorp.common.CommonHelper.getPassengerTypeRank(pt1);
    }

    public static ExtApiV2ProductFop convertProductFop2Rest(ProductFop productFop) {
        ExtApiV2ProductFop result = new ExtApiV2ProductFop();
        result.setUid(productFop.getUid());
        result.setCategory(AirProductHelper.getProductFopCategory((ProductFop)productFop));
        result.setPaymentType(productFop.getType());
        result.setAmount(productFop.getAmount().getValue());
        result.setCurrency(productFop.getAmount().getCurrency());
        result.setAgent(productFop.getAgent());
        result.setOperationDate(DateUtils.toLocalDateTime((Date)productFop.getOperationDate()));
        return result;
    }

    private static class SegmentInfo {
        private final Set<DictionaryReference<PassengerType>> usedTypes = new HashSet<DictionaryReference<PassengerType>>();
        private final Map<DictionaryReference<PassengerType>, LuggageInfo> baseLuggageInfo = new HashMap<DictionaryReference<PassengerType>, LuggageInfo>();
        private final Map<DictionaryReference<PassengerType>, FareDetails> brandedLuggageInfo = new HashMap<DictionaryReference<PassengerType>, FareDetails>();
        private FareDetails brandedFare;
        private PriceComponentsParameters priceComponentsParameters;

        public SegmentInfo(PriceComponentsParameters priceComponentsParameters) {
            this.priceComponentsParameters = priceComponentsParameters;
        }

        private ExtApiV2ExtendedLuggage convertLuggageInfo2Rest(LuggageInfo luggageInfo) {
            ExtApiV2ExtendedLuggage result = new ExtApiV2ExtendedLuggage();
            if (luggageInfo != null) {
                result.setNil(Boolean.valueOf(luggageInfo.isNil()));
                if (!luggageInfo.isNil()) {
                    result.setPieces(luggageInfo.getQuantity());
                    result.setUnit(ExtApiV2AviaConverterHelper.convertLuggageUnit2Rest((DictionaryReference<LuggageUnit>)luggageInfo.getUnit()));
                }
            }
            return result;
        }

        private boolean isBrandedLuggageInfo(FareDetails fareDetails) {
            return Optional.ofNullable(fareDetails).map(FareDetails::getLuggageInfo).orElse(null) != null;
        }

        private ExtApiV2ExtendedLuggage getAndConvertLuggage(FareDetails fareDetails, LuggageInfo luggageInfo) {
            if (this.isBrandedLuggageInfo(fareDetails)) {
                return this.exchangeAndConvertExtendedLuggage2Rest(fareDetails.getLuggageInfo(), null);
            }
            return this.convertLuggageInfo2Rest(luggageInfo);
        }

        private ExtApiV2ExtendedLuggage exchangeAndConvertExtendedLuggage2Rest(ExtendedLuggageInfo luggageInfo, Money price) {
            ExtApiV2ExtendedLuggage result = new ExtApiV2ExtendedLuggage();
            if (luggageInfo != null) {
                result.setPieces(luggageInfo.getPieces());
                result.setWeight(luggageInfo.getWeight());
                result.setWeightUnit(luggageInfo.getWeightUnit());
                result.setLength(luggageInfo.getLength());
                result.setWidth(luggageInfo.getWidth());
                result.setHeight(luggageInfo.getHeight());
                result.setDimensionsSum(luggageInfo.getDimensionsSum());
                result.setDimensionUnit(luggageInfo.getDimensionUnit());
            }
            if (price != null) {
                if (price.getCurrency().equals(this.priceComponentsParameters.getCurrency())) {
                    result.setPrice(ExtApiV2CommonConverterHelper.convertMoney2Rest((BigDecimal)price.getValue(), (String)price.getCurrency()));
                } else {
                    Money money = new Money();
                    money.setCurrency(this.priceComponentsParameters.getCurrency());
                    money.setValue(CurrencyHelper.exchange((Money)price, (String)this.priceComponentsParameters.getCurrency()));
                    result.setPrice(ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)money));
                }
            }
            return result;
        }

        void addBaseLuggageInfo(DictionaryReference<PassengerType> passengerType, LuggageInfo luggageInfo) {
            this.usedTypes.add(passengerType);
            this.baseLuggageInfo.put(passengerType, luggageInfo);
        }

        void addBrandedLuggageInfo(DictionaryReference<PassengerType> passengerType, FareDetails fareDetails) {
            this.usedTypes.add(passengerType);
            this.brandedLuggageInfo.put(passengerType, fareDetails);
        }

        FareDetails getBrandedFare() {
            return this.brandedFare;
        }

        void setBrandedFare(FareDetails brandedFare) {
            this.brandedFare = brandedFare;
        }

        Map<DictionaryReference<PassengerType>, ExtApiV2ExtendedLuggage> getFreeLuggageInfo() {
            return this.usedTypes.stream().collect(Collectors.toMap(UnaryOperator.identity(), t -> this.getAndConvertLuggage(this.brandedLuggageInfo.get(t), this.baseLuggageInfo.get(t))));
        }

        Map<DictionaryReference<PassengerType>, ExtApiV2ExtendedLuggage> getPaidLuggageInfo() {
            return this.usedTypes.stream().collect(Collectors.toMap(UnaryOperator.identity(), t -> {
                FareDetails fareDetails = Optional.ofNullable(this.brandedLuggageInfo.get(t)).orElse(new FareDetails());
                return this.exchangeAndConvertExtendedLuggage2Rest(fareDetails.getPaidLuggageInfo(), fareDetails.getPaidLuggagePrice());
            }));
        }

        Map<DictionaryReference<PassengerType>, ExtApiV2ExtendedLuggage> getFreeCabinLuggageInfo() {
            return this.usedTypes.stream().collect(Collectors.toMap(UnaryOperator.identity(), t -> {
                FareDetails fareDetails = Optional.ofNullable(this.brandedLuggageInfo.get(t)).orElse(new FareDetails());
                return this.exchangeAndConvertExtendedLuggage2Rest(fareDetails.getCabinLuggageInfo(), null);
            }));
        }

        Map<DictionaryReference<PassengerType>, ExtApiV2ExtendedLuggage> getPaidCabinLuggageInfo() {
            return this.usedTypes.stream().collect(Collectors.toMap(UnaryOperator.identity(), t -> {
                FareDetails fareDetails = Optional.ofNullable(this.brandedLuggageInfo.get(t)).orElse(new FareDetails());
                return this.exchangeAndConvertExtendedLuggage2Rest(fareDetails.getPaidCabinLuggageInfo(), fareDetails.getPaidCabinLuggagePrice());
            }));
        }
    }

    private static class Penalty2RestConverter {
        private Penalty2RestConverter() {
        }

        private static ExtApiV2Money exchangeAndConvertMoney2Rest(PriceComponentsParameters priceComponentsParameters, Money money) {
            if (money == null || priceComponentsParameters.getCurrency().equals(money.getCurrency())) {
                return ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)money);
            }
            Money result = new Money();
            result.setCurrency(priceComponentsParameters.getCurrency());
            result.setValue(CurrencyHelper.exchange((Money)money, (String)priceComponentsParameters.getCurrency()));
            return ExtApiV2CommonConverterHelper.convertMoney2Rest((Money)result);
        }

        private static ExtApiV2RefundPenaltiesInfo convertRefundPenalties2Rest(PriceComponentsParameters priceComponentsParameters, PenaltiesInfo penaltiesInfo) {
            ExtApiV2RefundPenaltiesInfo result = new ExtApiV2RefundPenaltiesInfo();
            if (penaltiesInfo == null) {
                return result;
            }
            result.setRefundableBeforeDeparture(Optional.ofNullable(penaltiesInfo.getRefundableBeforeDeparture()).orElse(false));
            result.setRefundableAfterDeparture(Optional.ofNullable(penaltiesInfo.getRefundableAfterDeparture()).orElse(false));
            result.setRefundBeforeDeparture(Penalty2RestConverter.exchangeAndConvertMoney2Rest(priceComponentsParameters, penaltiesInfo.getRefundBeforeDeparture()));
            result.setRefundAfterDeparture(Penalty2RestConverter.exchangeAndConvertMoney2Rest(priceComponentsParameters, penaltiesInfo.getRefundAfterDeparture()));
            return result;
        }

        private static ExtApiV2ExchangePenaltiesInfo convertExchangePenalties2Rest(PriceComponentsParameters priceComponentsParameters, PenaltiesInfo penaltiesInfo) {
            ExtApiV2ExchangePenaltiesInfo result = new ExtApiV2ExchangePenaltiesInfo();
            if (penaltiesInfo == null) {
                return result;
            }
            result.setExchangeableBeforeDeparture(Optional.ofNullable(penaltiesInfo.getExchangableBeforeDeparture()).orElse(false));
            result.setExchangeableAfterDeparture(Optional.ofNullable(penaltiesInfo.getExchangableAfterDeparture()).orElse(false));
            result.setExchangeBeforeDeparture(Penalty2RestConverter.exchangeAndConvertMoney2Rest(priceComponentsParameters, penaltiesInfo.getExchangeBeforeDeparture()));
            result.setExchangeAfterDeparture(Penalty2RestConverter.exchangeAndConvertMoney2Rest(priceComponentsParameters, penaltiesInfo.getExchangeAfterDeparture()));
            return result;
        }

        public static Map<DictionaryReference<PassengerType>, ExtApiV2ExchangePenaltiesInfo> convertExchangeInfo(Map<DictionaryReference<PassengerType>, PenaltiesInfo> penaltiesInfos, PriceComponentsParameters priceComponentsParameters) {
            return penaltiesInfos.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Penalty2RestConverter.convertExchangePenalties2Rest(priceComponentsParameters, (PenaltiesInfo)e.getValue())));
        }

        public static Map<DictionaryReference<PassengerType>, ExtApiV2RefundPenaltiesInfo> convertRefundInfo(Map<DictionaryReference<PassengerType>, PenaltiesInfo> penaltiesInfos, PriceComponentsParameters priceComponentsParameters) {
            HashMap<DictionaryReference<PassengerType>, ExtApiV2RefundPenaltiesInfo> result = new HashMap<DictionaryReference<PassengerType>, ExtApiV2RefundPenaltiesInfo>();
            penaltiesInfos.forEach((k, v) -> result.put((DictionaryReference<PassengerType>)k, Penalty2RestConverter.convertRefundPenalties2Rest(priceComponentsParameters, v)));
            return result;
        }
    }
}

