/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.avia;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.DocaAddressType;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsValidationMessages;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.rules.TransliterationType;
import com.gridnine.xtrip.common.model.rules.passport.PassportActionSet;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.common.ExtApiV2CommonValidationHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.corporateData.person.ExtApiV2PersonHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.dictionary.ExtApiV2DictionaryConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2AirBonusCard;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2DictionaryWrapper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2Passport;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2Phone;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.BonusCardValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.DocaValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.DocoValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.PhoneValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.CreateBookingParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchFlightsParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.avia.ExtApiV2AviaHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2Customer;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2DocaInfo;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2DocoInfo;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2Passenger;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2SearchFlightsParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2SearchLeg;
import com.gridnine.xtrip.server.ibecorp.ibus.rules.PassportRuleHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.ReadablePartial;

public final class ExtApiV2AviaValidationHelper {
    public static final Pattern ALPHA_NUMERIC_PATTERN = Pattern.compile("^([1-9A-Za-z]){3}[0-9A-Za-z]{3}(($)|([1-9A-Za-z]$)|([0-9A-Za-z]{4})$)");
    static final Pattern RUSSIAN_BIRTHDAY_NOTIFICATION_PATTERN = Pattern.compile("^[IVX]+[\u0410-\u042f\u0430-\u044f]{2}[0-9]{6}$");
    private static final Pattern ALPHA_AND_SPACES_PATTERN = Pattern.compile("([A-Za-z ])*");
    private static final Pattern ALPHA_NUMERIC_AND_SPACES_PATTERN = Pattern.compile("([0-9A-Za-z ])*");

    private ExtApiV2AviaValidationHelper() {
    }

    public static void validateFlightLeg(ExtApiV2SearchLeg fl) {
        if (Objects.isNull(fl.getDeparture())) {
            fl.getValidationContext().getDepartureValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyDepartureLocation());
        }
        if (Objects.isNull(fl.getArrival())) {
            fl.getValidationContext().getArrivalValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyArrivalLocation());
        }
        if (Objects.nonNull(fl.getDeparture()) && fl.getDeparture().equals((Object)fl.getArrival())) {
            fl.getValidationContext().getDepartureValidationMessages().add(GdsValidationMessages.getFlightSearchParametersRouteLocationsEqualOrInSameCity());
            fl.getValidationContext().getArrivalValidationMessages().add(GdsValidationMessages.getFlightSearchParametersRouteLocationsEqualOrInSameCity());
        }
        if (Objects.isNull(fl.getDate())) {
            fl.getValidationContext().getDateValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyDate());
        }
        if (Objects.nonNull(fl.getDate()) && fl.getDate().isBefore((ReadablePartial)LocalDate.now())) {
            fl.getValidationContext().getDateValidationMessages().add(SearchFlightsParametersValidationMessages.getPastDate());
        }
        if (fl.getDepartureTimeWindowStart() != null && fl.getDepartureTimeWindowEnd() != null && fl.getDepartureTimeWindowStart().isAfter(fl.getDepartureTimeWindowEnd())) {
            fl.getValidationContext().getDepartureTimeWindowStartValidationMessages().add(SearchFlightsParametersValidationMessages.getStartTimeAfterEndTime());
        }
    }

    public static void validateChildAges(ExtApiV2SearchFlightsParameters parameters, int children) {
        for (int i = 0; i < children; ++i) {
            if (i < parameters.getChildsAge().size() && !Objects.isNull(parameters.getChildsAge().get(i))) continue;
            parameters.getValidationContext().getChildsAgeListValidationMessages().put(i, Collections.singletonList(SearchFlightsParametersValidationMessages.getEmptyChildsAge()));
        }
    }

    public static void validatePassenger(ExtApiV2Passenger passenger, Flight gdsFlight, SalesContext salesContext) {
        boolean isValidateEmail;
        ExtApiV2AviaValidationHelper.validatePassport(passenger.getPassport(), gdsFlight, (DictionaryReference<PassengerType>)passenger.getType(), salesContext);
        boolean bl = isValidateEmail = gdsFlight.getGds() == GdsName.SABRE && AviaHelper.hasEmail((DictionaryReference<PassengerType>)passenger.getType());
        if (isValidateEmail || !TextUtil.isBlank((String)passenger.getEmail())) {
            ExtApiV2AviaValidationHelper.validateEmail(passenger);
        }
        ExtApiV2AviaValidationHelper.validatePhone(passenger);
        boolean hasBonusCard = ExtApiV2AviaValidationHelper.hasAirBonusCard(passenger.getBonusCard());
        if (hasBonusCard) {
            ExtApiV2AviaValidationHelper.isValidAirBonusCard(passenger.getBonusCard(), gdsFlight);
        }
        if (passenger.getDocoInfo() != null) {
            ExtApiV2AviaValidationHelper.validateDocoInfo(passenger.getDocoInfo());
        }
        if (passenger.getDocaInfo() != null) {
            ExtApiV2AviaValidationHelper.validateDocaInfo(passenger.getDocaInfo());
        }
    }

    private static void validatePassport(ExtApiV2Passport passport, Flight gdsFlight, DictionaryReference<PassengerType> passengerType, SalesContext salesContext) {
        ExtApiV2Passport.ExtApiV2PassportValidationContext validationContext = passport.getValidationContext();
        if (passport.getGender() == null) {
            validationContext.getGenderValidationMessages().add(CreateBookingParametersValidationMessages.getMissingGender());
        }
        PassportActionSet transliterationRules = PassportRuleHelper.getPassportRules(gdsFlight, passengerType, ExtApiV2PersonHelper.convertRestPassport2Passport((ExtApiV2Passport)passport), salesContext);
        TransliterationType transliterationType = AviaHelper.verifyTransliteration(gdsFlight, transliterationRules.getTransliterationTypeDocument());
        boolean latinRegistration = gdsFlight.isLatinRegistration();
        if (TransliterationType.LATIN.equals((Object)transliterationType)) {
            latinRegistration = true;
        } else if (TransliterationType.CYRILLIC.equals((Object)transliterationType)) {
            latinRegistration = false;
        }
        ExtApiV2AviaValidationHelper.validateFirstName(passport, latinRegistration);
        ExtApiV2AviaValidationHelper.validateLastName(passport, latinRegistration);
        if (!passport.isWithoutMiddleName()) {
            ExtApiV2AviaValidationHelper.validateMiddleName(passport, latinRegistration);
        }
        ExtApiV2AviaValidationHelper.validateBirthDate(passport, gdsFlight, passengerType);
        if (passport.getCitizenship() == null) {
            validationContext.getCitizenshipValidationMessages().add(CreateBookingParametersValidationMessages.getMissingCitizenship());
        }
        if (passport.getOriginCountry() == null) {
            validationContext.getOriginCountryValidationMessages().add(CreateBookingParametersValidationMessages.getMissingOrigin());
        }
        if (passport.getType() == null) {
            validationContext.getTypeValidationMessages().add(CreateBookingParametersValidationMessages.getMissingPassportType());
        }
        if (ExtApiV2AviaValidationHelper.isValidateExpiredDate(passport) && !ExtApiV2AviaHelper.isCalculateExpiredDate(passport, gdsFlight)) {
            ExtApiV2AviaValidationHelper.validateExpireDate(passport, gdsFlight);
        }
        ExtApiV2AviaValidationHelper.validatePassportNumber(passport, gdsFlight);
    }

    private static boolean isValidateExpiredDate(ExtApiV2Passport passport) {
        return passport.getType() != null && passport.getCitizenship() != null && passport.getOriginCountry() != null;
    }

    public static boolean isValidDKNumber(String number) {
        return ALPHA_NUMERIC_PATTERN.matcher(number).matches();
    }

    private static void validatePhone(ExtApiV2Passenger passenger) {
        if (!passenger.getType().equals((Object)DictHelper.getInfantPassengerType()) && passenger.getPhone() != null) {
            ExtApiV2AviaValidationHelper.validatePhone(passenger.getPhone(), passenger.getValidationContext().getPhoneValidationMessages());
        }
    }

    private static void validateEmail(ExtApiV2Passenger passenger) {
        if (TextUtil.isBlank((String)passenger.getEmail())) {
            passenger.getValidationContext().getEmailValidationMessages().add(CreateBookingParametersValidationMessages.getMissingEmail());
            return;
        }
        if (!ExtApiV2CommonValidationHelper.isValidEmailFormat((String)passenger.getEmail())) {
            passenger.getValidationContext().getEmailValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalEmail());
        }
    }

    private static void validatePassportNumber(ExtApiV2Passport passport, Flight gdsFlight) {
        boolean isRuBirthdayNotification;
        if (TextUtil.isBlank((String)passport.getNumber())) {
            passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getMissingPassportNumber());
            return;
        }
        String number = passport.getNumber();
        boolean isSirenaBirthDateNotification = ExtApiV2AviaHelper.isSirenaBirthDateNotification(gdsFlight.getGds(), passport.getType());
        boolean bl = isRuBirthdayNotification = ExtApiV2CommonValidationHelper.isRu((DictionaryReference)passport.getCitizenship()) && passport.getType() == PassportType.BIRTHDAY_NOTIFICATION;
        if (!isSirenaBirthDateNotification && !isRuBirthdayNotification && ExtApiV2AviaValidationHelper.isInvalidCharacterInPassportNumber(passport)) {
            passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalPassportNumber());
            return;
        }
        if (isSirenaBirthDateNotification && !ExtApiV2AviaValidationHelper.isValidSirenaBirthDateNotificationNumber(number)) {
            passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalBirthdayNotificationNumber());
            return;
        }
        if (ExtApiV2CommonValidationHelper.isRu((DictionaryReference)passport.getCitizenship())) {
            if (!(passport.getType() != PassportType.INTERNAL || ExtApiV2CommonValidationHelper.isNumber((String)number) && number.length() == 10)) {
                passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalInternalPassportNumber());
                return;
            }
            if (passport.getType() == PassportType.FOREIGN && !ExtApiV2CommonValidationHelper.isNumber((String)number) && number.length() == 9) {
                passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalForeignPassportNumber());
                return;
            }
            if (passport.getType() == PassportType.BIRTHDAY_NOTIFICATION && !ExtApiV2AviaValidationHelper.isValidRussianBirthDateNotificationNumber(passport.getNumber())) {
                passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalBirthdayNotificationNumber());
                return;
            }
        }
        if (ExtApiV2CommonValidationHelper.isUa((DictionaryReference)passport.getCitizenship()) && number.length() > 15) {
            passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalInternalPassportNumberUA());
        }
    }

    private static boolean isValidSirenaBirthDateNotificationNumber(String number) {
        return RUSSIAN_BIRTHDAY_NOTIFICATION_PATTERN.matcher(number.replaceAll(" ", "")).matches();
    }

    private static boolean isValidRussianBirthDateNotificationNumber(String number) {
        return RUSSIAN_BIRTHDAY_NOTIFICATION_PATTERN.matcher(number).matches();
    }

    private static void validateExpireDate(ExtApiV2Passport passport, Flight gdsFlight) {
        if (Objects.isNull(passport.getExpiredDate())) {
            passport.getValidationContext().getExpiredDateValidationMessages().add(CreateBookingParametersValidationMessages.getMissingPassportExpired());
            return;
        }
        if (FlightHelper.getFirstDepartureTime((Flight)gdsFlight).after(passport.getExpiredDate().toDate())) {
            passport.getValidationContext().getExpiredDateValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalPassportExpired());
        }
    }

    private static boolean isInvalidCharacterInPassportNumber(ExtApiV2Passport passport) {
        return passport.getNumber().chars().anyMatch(c -> ExtApiV2AviaValidationHelper.isInvalidCharacter(c, passport.getType() == PassportType.BIRTHDAY_NOTIFICATION, ExtApiV2CommonValidationHelper.isUa((DictionaryReference)passport.getCitizenship())));
    }

    private static boolean isInvalidCharacter(int ch, boolean isBirthDateNotification, boolean isUAPassport) {
        if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || isBirthDateNotification && ch == 32) {
            return false;
        }
        if (isUAPassport) {
            switch (ch) {
                case 1030: 
                case 1040: 
                case 1042: 
                case 1045: 
                case 1048: 
                case 1050: 
                case 1052: 
                case 1053: 
                case 1054: 
                case 1056: 
                case 1057: 
                case 1058: 
                case 1059: 
                case 1061: 
                case 1072: 
                case 1074: 
                case 1077: 
                case 1080: 
                case 1082: 
                case 1084: 
                case 1085: 
                case 1086: 
                case 1088: 
                case 1089: 
                case 1090: 
                case 1091: 
                case 1093: 
                case 1110: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private static void validateBirthDate(ExtApiV2Passport passport, Flight gdsFlight, DictionaryReference<PassengerType> passengerType) {
        Collection validationMessages = passport.getValidationContext().getBirthDateValidationMessages();
        if (Objects.isNull(passport.getBirthDate())) {
            validationMessages.add(CreateBookingParametersValidationMessages.getMissingBirthDate());
            return;
        }
        LocalDate departureDate = new LocalDate((Object)FlightHelper.getFirstDepartureTime((Flight)gdsFlight));
        Period period = new Period((ReadablePartial)passport.getBirthDate(), (ReadablePartial)departureDate);
        int age = period.getYears();
        int ageInMonths = period.getMonths() + age * 12;
        if (age < 0 || age > 150) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalBirthDate());
            return;
        }
        if (DictHelper.isAdultPassengerType(passengerType) && age < 12) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalAdultAge());
            return;
        }
        if (DictHelper.isInfantPassengerTypeCategory(passengerType) && ageInMonths >= 24) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalInfantAge());
            return;
        }
        if (DictHelper.isChildPassengerTypeCategory(passengerType) && age > 11) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalChildAge());
            return;
        }
        if (DictHelper.isYouthPassengerType(passengerType) && (age <= 12 || age >= 25)) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalYouthAge());
            return;
        }
        if (DictHelper.isSeniorPassengerType(passengerType) && age < 65) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalSeniorAge());
        }
    }

    private static void validateFirstName(ExtApiV2Passport passport, boolean isValidateLatinCharacters) {
        ExtApiV2CommonValidationHelper.isValidName((String)passport.getFirstName(), (boolean)isValidateLatinCharacters, (Collection)passport.getValidationContext().getFirstNameValidationMessages(), (ValidationMessage)CreateBookingParametersValidationMessages.getMissingFirstName(), (ValidationMessage)CreateBookingParametersValidationMessages.getFirstNameNonLatin(), (ValidationMessage)CreateBookingParametersValidationMessages.getFirstNameIllegal(), (ValidationMessage)CreateBookingParametersValidationMessages.getFirstNameContainsSpace(), (ValidationMessage)CreateBookingParametersValidationMessages.getFirstNameLengthLimit());
    }

    private static void validateLastName(ExtApiV2Passport passport, boolean isValidateLatinCharacters) {
        ExtApiV2CommonValidationHelper.isValidName((String)passport.getLastName(), (boolean)isValidateLatinCharacters, (Collection)passport.getValidationContext().getLastNameValidationMessages(), (ValidationMessage)CreateBookingParametersValidationMessages.getMissingLastName(), (ValidationMessage)CreateBookingParametersValidationMessages.getLastNameNonLatin(), (ValidationMessage)CreateBookingParametersValidationMessages.getLastNameIllegal(), (ValidationMessage)CreateBookingParametersValidationMessages.getLastNameContainsSpace(), (ValidationMessage)CreateBookingParametersValidationMessages.getLastNameLengthLimit());
    }

    private static void validateMiddleName(ExtApiV2Passport passport, boolean isValidateLatinCharacters) {
        ExtApiV2CommonValidationHelper.isValidName((String)passport.getMiddleName(), (boolean)isValidateLatinCharacters, (Collection)passport.getValidationContext().getMiddleNameValidationMessages(), (ValidationMessage)CreateBookingParametersValidationMessages.getMissingMiddleName(), (ValidationMessage)CreateBookingParametersValidationMessages.getMiddleNameNonLatin(), (ValidationMessage)CreateBookingParametersValidationMessages.getMiddleNameIllegal(), (ValidationMessage)CreateBookingParametersValidationMessages.getMiddleNameContainsSpace(), (ValidationMessage)CreateBookingParametersValidationMessages.getMiddleNameLengthLimit());
    }

    public static void validateCustomer(ExtApiV2Customer customer, SMGeneralSettings settings) {
        ExtApiV2AviaValidationHelper.validateEmail(customer, settings);
        ExtApiV2AviaValidationHelper.validatePhone(customer);
    }

    public static void addValidationMessage(ExtApiV2SearchFlightsParameters parameters, Predicate<DictionaryReference<PassengerType>> passTypeCriterion, ValidationMessage message) {
        parameters.getPassengers().keySet().stream().filter(passTypeCriterion).forEach(type -> {
            Collection cfr_ignored_0 = parameters.getValidationContext().getPassengersListValidationMessages().put(type, Collections.singletonList(message));
        });
    }

    public static void validateEmail(ExtApiV2Customer customer, SMGeneralSettings settings) {
        if (TextUtil.isBlank((String)customer.getEmail())) {
            customer.getValidationContext().getEmailValidationMessages().add(CreateBookingParametersValidationMessages.getMissingContactEmail());
            return;
        }
        if (!ExtApiV2CommonValidationHelper.isValidEmailFormat((String)customer.getEmail())) {
            customer.getValidationContext().getEmailValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalContactEmail());
            return;
        }
        if (settings.getBannedEmail().stream().anyMatch(s -> s.equalsIgnoreCase(customer.getEmail()))) {
            customer.getValidationContext().getEmailValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalContactEmail());
        }
    }

    public static void validatePhone(ExtApiV2Customer customer) {
        if (customer.getPhone() == null) {
            customer.getValidationContext().getPhoneValidationMessages().add(CreateBookingParametersValidationMessages.getMissingPhone());
            return;
        }
        ExtApiV2AviaValidationHelper.validatePhone(customer.getPhone(), customer.getValidationContext().getPhoneValidationMessages());
    }

    private static String buildPhone2String(ExtApiV2Phone phone) {
        return phone.getCountryCode() + phone.getCityCode() + phone.getNumber();
    }

    private static void validatePhone(ExtApiV2Phone phone, Collection<ValidationMessage> messages) {
        if (TextUtil.isBlank((String)phone.getCountryCode())) {
            phone.getValidationContext().getCountryCodeValidationMessages().add(PhoneValidationMessages.getMissingCountryCode());
        }
        if (TextUtil.isBlank((String)phone.getCityCode())) {
            phone.getValidationContext().getCityCodeValidationMessages().add(PhoneValidationMessages.getMissingCityCode());
        }
        if (TextUtil.isBlank((String)phone.getNumber())) {
            phone.getValidationContext().getNumberValidationMessages().add(PhoneValidationMessages.getMissingNumber());
        }
        if (!ExtApiV2AviaValidationHelper.buildPhone2String(phone).chars().allMatch(Character::isDigit)) {
            messages.add(PhoneValidationMessages.getIllegalPhone());
        }
    }

    public static boolean isValidAirBonusCard(ExtApiV2AirBonusCard bonusCard, Flight gdsFlight) {
        if (bonusCard.getAirline() == null) {
            bonusCard.getValidationContext().getAirlineValidationMessages().add(BonusCardValidationMessages.getIllegalBonusCard());
            return false;
        }
        if (TextUtil.isBlank((String)bonusCard.getNumber())) {
            bonusCard.getValidationContext().getNumberValidationMessages().add(BonusCardValidationMessages.getIllegalBonusCard());
            return false;
        }
        Set airlines = FlightHelper.getFlightSegmentsStream((Flight)gdsFlight).flatMap(s -> {
            HashSet<DictionaryReference> carriers = new HashSet<DictionaryReference>();
            carriers.add(s.getAirline());
            carriers.add(s.getAirline());
            return carriers.stream();
        }).collect(Collectors.toSet());
        DictionaryReference airlineRef = ExtApiV2DictionaryConverterHelper.getAirlineFromDictionaryWrapper((ExtApiV2DictionaryWrapper)bonusCard.getAirline(), (Date)gdsFlight.getInitDate());
        if (!DictHelper.validateAlliances((DictionaryReference)airlineRef, airlines)) {
            bonusCard.getValidationContext().getAirlineValidationMessages().add(BonusCardValidationMessages.getIllegalBonusCard());
            bonusCard.getValidationContext().getNumberValidationMessages().add(BonusCardValidationMessages.getIllegalBonusCard());
            return false;
        }
        return true;
    }

    public static boolean hasAirBonusCard(ExtApiV2AirBonusCard bonusCard) {
        return bonusCard != null && (Objects.nonNull(bonusCard.getAirline()) || !TextUtil.isBlank((String)bonusCard.getNumber()));
    }

    public static void validateDocoInfo(ExtApiV2DocoInfo docoInfo) {
        boolean emptyVisaIssuePlace;
        boolean emptyVisaNumber;
        ExtApiV2AviaValidationHelper.isEmptyDocoDocaField(docoInfo.getPlaceOfBirthCountry(), false, (Collection<ValidationMessage>)docoInfo.getValidationContext().getPlaceOfBirthCountryValidationMessages(), DocoValidationMessages.getMissingPlaceOfBirthCountry());
        ExtApiV2AviaValidationHelper.isEmptyDocoDocaField(docoInfo.getVisaApplicableCountry(), docoInfo.isVisa(), (Collection<ValidationMessage>)docoInfo.getValidationContext().getVisaApplicableCountryValidationMessages(), DocoValidationMessages.getMissingVisaApplicableCountry());
        ExtApiV2AviaValidationHelper.isEmptyDocoDocaField(docoInfo.getVisaIssueDate(), docoInfo.isVisa(), (Collection<ValidationMessage>)docoInfo.getValidationContext().getVisaIssueDateValidationMessages(), DocoValidationMessages.getMissingVisaIssueDate());
        boolean emptyPlaceOfBirthCity = ExtApiV2AviaValidationHelper.isEmptyDocoDocaField(docoInfo.getPlaceOfBirthCity(), !docoInfo.isVisa(), (Collection<ValidationMessage>)docoInfo.getValidationContext().getPlaceOfBirthCityValidationMessages(), DocoValidationMessages.getMissingPlaceOfBirthCity());
        if (!emptyPlaceOfBirthCity) {
            ExtApiV2AviaValidationHelper.isIllegalDocoDocaField(docoInfo.getPlaceOfBirthCity(), ALPHA_AND_SPACES_PATTERN, docoInfo.getValidationContext().getPlaceOfBirthCityValidationMessages(), DocoValidationMessages.getIllegalPlaceOfBirthCity());
            ExtApiV2AviaValidationHelper.isTooLongDocoDocaField(docoInfo.getPlaceOfBirthCity(), 30, docoInfo.getValidationContext().getPlaceOfBirthCityValidationMessages(), DocoValidationMessages.getTooLongPlaceOfBirthCity());
        }
        if (!(emptyVisaNumber = ExtApiV2AviaValidationHelper.isEmptyDocoDocaField(docoInfo.getVisaNumber(), docoInfo.isVisa(), (Collection<ValidationMessage>)docoInfo.getValidationContext().getVisaNumberValidationMessages(), DocoValidationMessages.getMissingVisaNumber()))) {
            ExtApiV2AviaValidationHelper.isIllegalDocoDocaField(docoInfo.getVisaNumber(), ALPHA_NUMERIC_PATTERN, docoInfo.getValidationContext().getVisaNumberValidationMessages(), DocoValidationMessages.getIllegalVisaNumber());
            ExtApiV2AviaValidationHelper.isTooLongDocoDocaField(docoInfo.getVisaNumber(), 15, docoInfo.getValidationContext().getVisaNumberValidationMessages(), DocoValidationMessages.getTooLongVisaNumber());
        }
        if (!(emptyVisaIssuePlace = ExtApiV2AviaValidationHelper.isEmptyDocoDocaField(docoInfo.getVisaIssuePlace(), docoInfo.isVisa(), (Collection<ValidationMessage>)docoInfo.getValidationContext().getVisaIssuePlaceValidationMessages(), DocoValidationMessages.getMissingVisaIssuePlace()))) {
            ExtApiV2AviaValidationHelper.isIllegalDocoDocaField(docoInfo.getVisaIssuePlace(), ALPHA_AND_SPACES_PATTERN, docoInfo.getValidationContext().getVisaIssuePlaceValidationMessages(), DocoValidationMessages.getIllegalVisaIssuePlace());
            ExtApiV2AviaValidationHelper.isTooLongDocoDocaField(docoInfo.getVisaIssuePlace(), 35, docoInfo.getValidationContext().getVisaIssuePlaceValidationMessages(), DocoValidationMessages.getTooLongVisaIssuePlace());
        }
    }

    public static void validateDocaInfo(ExtApiV2DocaInfo docaInfo) {
        boolean emptyZipPostalCode;
        boolean emptyStreet;
        boolean emptyCity;
        ExtApiV2AviaValidationHelper.isEmptyDocoDocaField(docaInfo.getCountry(), true, (Collection<ValidationMessage>)docaInfo.getValidationContext().getCountryValidationMessages(), DocaValidationMessages.getMissingCountry());
        boolean emptyStageProvince = ExtApiV2AviaValidationHelper.isEmptyDocoDocaField(docaInfo.getStateProvince(), docaInfo.getAddressType() == DocaAddressType.DESTINATION, (Collection<ValidationMessage>)docaInfo.getValidationContext().getStateProvinceValidationMessages(), DocaValidationMessages.getMissingStateProvince());
        if (!emptyStageProvince) {
            ExtApiV2AviaValidationHelper.isIllegalDocoDocaField(docaInfo.getStateProvince(), ALPHA_AND_SPACES_PATTERN, docaInfo.getValidationContext().getStateProvinceValidationMessages(), DocaValidationMessages.getIllegalStateProvince());
            ExtApiV2AviaValidationHelper.isTooLongDocoDocaField(docaInfo.getStateProvince(), 35, docaInfo.getValidationContext().getStateProvinceValidationMessages(), DocaValidationMessages.getTooLongStateProvince());
        }
        if (!(emptyCity = ExtApiV2AviaValidationHelper.isEmptyDocoDocaField(docaInfo.getCity(), docaInfo.getAddressType() == DocaAddressType.DESTINATION, (Collection<ValidationMessage>)docaInfo.getValidationContext().getCityValidationMessages(), DocaValidationMessages.getIllegalCity()))) {
            ExtApiV2AviaValidationHelper.isIllegalDocoDocaField(docaInfo.getCity(), ALPHA_AND_SPACES_PATTERN, docaInfo.getValidationContext().getCityValidationMessages(), DocaValidationMessages.getIllegalCity());
            ExtApiV2AviaValidationHelper.isTooLongDocoDocaField(docaInfo.getCity(), 35, docaInfo.getValidationContext().getCityValidationMessages(), DocaValidationMessages.getTooLongCity());
        }
        if (!(emptyStreet = ExtApiV2AviaValidationHelper.isEmptyDocoDocaField(docaInfo.getStreet(), docaInfo.getAddressType() == DocaAddressType.DESTINATION, (Collection<ValidationMessage>)docaInfo.getValidationContext().getStreetValidationMessages(), DocaValidationMessages.getMissingStreet()))) {
            ExtApiV2AviaValidationHelper.isIllegalDocoDocaField(docaInfo.getStreet(), ALPHA_NUMERIC_AND_SPACES_PATTERN, docaInfo.getValidationContext().getStreetValidationMessages(), DocaValidationMessages.getIllegalStreet());
            ExtApiV2AviaValidationHelper.isTooLongDocoDocaField(docaInfo.getStreet(), 35, docaInfo.getValidationContext().getStreetValidationMessages(), DocaValidationMessages.getTooLongStreet());
        }
        if (!(emptyZipPostalCode = ExtApiV2AviaValidationHelper.isEmptyDocoDocaField(docaInfo.getZipPostalCode(), false, (Collection<ValidationMessage>)docaInfo.getValidationContext().getZipPostalCodeValidationMessages(), DocaValidationMessages.getMissingZipPostalCode()))) {
            ExtApiV2AviaValidationHelper.isIllegalDocoDocaField(docaInfo.getZipPostalCode(), ALPHA_NUMERIC_AND_SPACES_PATTERN, docaInfo.getValidationContext().getZipPostalCodeValidationMessages(), DocaValidationMessages.getIllegalZipPostalCode());
            ExtApiV2AviaValidationHelper.isTooLongDocoDocaField(docaInfo.getZipPostalCode(), 17, docaInfo.getValidationContext().getZipPostalCodeValidationMessages(), DocaValidationMessages.getTooLongZipPostalCode());
        }
    }

    private static boolean isEmptyDocoDocaField(Object field, boolean required, Collection<ValidationMessage> messages, ValidationMessage message) {
        if (field == null) {
            if (required) {
                messages.add(message);
            }
            return true;
        }
        return false;
    }

    private static boolean isEmptyDocoDocaField(String field, boolean required, Collection<ValidationMessage> messages, ValidationMessage message) {
        if (TextUtil.isBlank((String)field)) {
            if (required) {
                messages.add(message);
            }
            return true;
        }
        return false;
    }

    private static boolean isIllegalDocoDocaField(String field, Pattern pattern, Collection<ValidationMessage> messages, ValidationMessage message) {
        if (pattern != null && !pattern.matcher(field).matches()) {
            messages.add(message);
            return true;
        }
        return false;
    }

    private static boolean isTooLongDocoDocaField(String field, int maxLength, Collection<ValidationMessage> messages, ValidationMessage message) {
        if (field.length() > maxLength) {
            messages.add(message);
            return true;
        }
        return false;
    }
}

