/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.avia.applyTravelPolicy;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.externalApi.extApiV2.avia.ExtApiV2AviaToken;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyParameters;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.CreateBookingParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchFlightsParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.avia.ExtApiV2AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2ApplyTravelPolicyParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2Passenger;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.ArrayList;
import java.util.List;

public class ExtApiV2ApplyTravelPolicyParametersValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        TravelPolicyParameters travelPolicyParams;
        ExtApiV2ApplyTravelPolicyParameters parameters = (ExtApiV2ApplyTravelPolicyParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        ExtApiV2AviaToken token = ExtApiV2AviaConverterHelper.convertRestToken2Flight(parameters.getFlightToken());
        if (parameters.getPassengers().isEmpty()) {
            parameters.getValidationContext().getPassengersValidationMessages().add(CreateBookingParametersValidationMessages.getEmptyPassengers());
        }
        if ((travelPolicyParams = token.getTravelPolicyParams()) != null) {
            ExtApiV2Passenger personParam;
            int i;
            if (!travelPolicyParams.getPersons().isEmpty()) {
                if (travelPolicyParams.getPersons().size() != parameters.getPassengers().size()) {
                    parameters.getValidationContext().getPassengersValidationMessages().add(CreateBookingParametersValidationMessages.getMissingPassenger());
                } else {
                    for (i = 0; i < parameters.getPassengers().size(); ++i) {
                        personParam = (ExtApiV2Passenger)parameters.getPassengers().get(i);
                        if (!travelPolicyParams.getPersons().stream().noneMatch(p -> p.getUid().equals(personParam.getUid()))) continue;
                        parameters.getValidationContext().getPassengersListValidationMessages().computeIfAbsent(i, p -> new ArrayList()).add(CreateBookingParametersValidationMessages.getMissingPassenger());
                    }
                }
            } else {
                for (i = 0; i < parameters.getPassengers().size(); ++i) {
                    EntityContainer personCtr;
                    personParam = (ExtApiV2Passenger)parameters.getPassengers().get(i);
                    EntityContainer entityContainer = personCtr = TextUtil.nonBlank((String)personParam.getUid()) ? EntityStorage.get().load(Person.class, personParam.getUid()) : null;
                    if (personCtr != null) {
                        travelPolicyParams.getPersons().add(personCtr.toReference());
                        continue;
                    }
                    parameters.getValidationContext().getPassengersListValidationMessages().computeIfAbsent(i, p -> new ArrayList()).add(CreateBookingParametersValidationMessages.getMissingPassenger());
                }
            }
            List categories = travelPolicyParams.getPersonCategories();
            if (!travelPolicyParams.getPersonCategories().isEmpty()) {
                for (int i2 = 0; i2 < parameters.getPassengers().size(); ++i2) {
                    EmployeeCategory category;
                    ExtApiV2Passenger personParam2 = (ExtApiV2Passenger)parameters.getPassengers().get(i2);
                    EntityContainer personCtr = TextUtil.nonBlank((String)personParam2.getUid()) ? EntityStorage.get().load(Person.class, personParam2.getUid()) : null;
                    EmployeeCategory employeeCategory = category = personCtr != null ? GeneralProductHelper.getEmployeeCategory((EntityReference)travelPolicyParams.getClientRef(), (Person)((Person)personCtr.getEntity())) : null;
                    if (!categories.stream().noneMatch(c -> GeneralProductHelper.isEmployeeCategoriesEquals((EmployeeCategory)c, (EmployeeCategory)category))) continue;
                    parameters.getValidationContext().getPassengersListValidationMessages().computeIfAbsent(i2, p -> new ArrayList()).add(SearchFlightsParametersValidationMessages.getInvalidPassengerEmployeeCategory());
                }
            }
        }
        if (!ValidationHelper.isValid((Validatable)parameters)) {
            throw new ValidationException();
        }
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, (Object)token.getFlight());
        if (travelPolicyParams != null) {
            ctx.putObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PARAMETERS, (Object)travelPolicyParams);
        }
    }
}

