/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.avia.createBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyParameters;
import com.gridnine.xtrip.server.externalApi.extApiV2.corporateData.person.ExtApiV2PersonHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.avia.ExtApiV2AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2CreateBookingParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2Passenger;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ExtApiV2CreateBookingParametersConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV2CreateBookingParameters parameters = (ExtApiV2CreateBookingParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Flight selectedFlight = ExtApiV2AviaConverterHelper.convertRestToken2Flight(parameters.getFlightToken()).getFlight();
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        TravelPolicyParameters travelPolicyParams = (TravelPolicyParameters)ctx.getObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PARAMETERS);
        if (travelPolicyParams != null) {
            salesContext.setClient(travelPolicyParams.getClientRef());
        }
        ArrayList<Traveller> travellers = new ArrayList<Traveller>(8);
        ArrayList<GdsTraveller> gdsTravellers = new ArrayList<GdsTraveller>(8);
        HashMap<Traveller, List> travellersCostCodes = new HashMap<Traveller, List>();
        for (ExtApiV2Passenger passenger : parameters.getPassengers()) {
            Traveller traveller = ExtApiV2AviaConverterHelper.convertAviaPassenger2Traveler(passenger);
            GdsTraveller gdsTraveller = new GdsTraveller();
            gdsTraveller.setPassengerType(passenger.getType());
            gdsTraveller.setTravellerUid(traveller.getUid());
            List costCodes = ExtApiV2PersonHelper.convertRestPersonCostCodes((List)passenger.getCostCodes());
            travellersCostCodes.put(traveller, costCodes);
            travellers.add(traveller);
            gdsTravellers.add(gdsTraveller);
        }
        Customer customer = ExtApiV2AviaConverterHelper.convertRest2Customer(parameters.getCustomer());
        customer.setProfile(salesContext.getCustomer());
        customer.setPreferredLocale(LocaleHelper.getCurrentLocale());
        GdsReservationCreationParameters aviaParameters = new GdsReservationCreationParameters();
        aviaParameters.getGdsTravellers().addAll(gdsTravellers);
        aviaParameters.setFlight(selectedFlight);
        aviaParameters.setGdsAccount(selectedFlight.getGdsAccount());
        HashSet<GdsReservationCreationParameters> reservationCreationParameters = new HashSet<GdsReservationCreationParameters>();
        reservationCreationParameters.add(aviaParameters);
        ctx.putObject((Enum)IBusIbecorpContextKeys.TRAVELLERS_COST_CODES, travellersCostCodes);
        ctx.putObject((Enum)IBusMidofficeContextKeys.TRAVELLERS, travellers);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_CREATION_PARAMETERS, reservationCreationParameters);
        ctx.putObject((Enum)IBusMidofficeContextKeys.CUSTOMER, (Object)customer);
        ctx.putObject((Enum)IBusIbecorpContextKeys.DK_NUMBER, (Object)parameters.getDkNumber());
    }
}

