/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.avia.createItineraryReceipt;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DownloadableData;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2CreateItineraryReceiptParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.templates.jr.ItineraryReceiptRender;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Optional;

public class ExtApiV2CreateItineraryReceiptProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV2CreateItineraryReceiptParameters request = (ExtApiV2CreateItineraryReceiptParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"navigationKey", (Object)request.getProductUid()));
        SearchResult searchResult = EntityStorage.get().search(CommonProductIndex.class, query);
        if (searchResult.getTotalCount() != 1) {
            throw Xeption.forAdmin((String)("Can't resolve a product with uid " + request.getProductUid()), (Object[])new Object[0]);
        }
        Locale locale = LocaleUtil.createNormalizedLocale((String)LocaleHelper.getCurrentLocale().getLanguage());
        EntityContainer<TemplateDocument> templateContainer = CabinetHelper.getTemplateDocument(locale);
        if (templateContainer == null) {
            throw Xeption.forDeveloper((String)String.format("Travel reservation template not found for locale %s", locale.toString()), (Object[])new Object[0]);
        }
        DictionaryCache dCache = (DictionaryCache)Environment.getPublished(DictionaryCache.class);
        LinkedList<InformationNote> notes = new LinkedList<InformationNote>();
        for (String noteCode : request.getInformationNotes()) {
            InformationNote note = (InformationNote)dCache.findByCode(InformationNote.class, noteCode);
            if (note == null) continue;
            notes.add(note);
        }
        EntityReference bfRef = ((CommonProductIndex)searchResult.getData().get(0)).getSource();
        EntityContainer bfCtr = EntityStorage.get().resolve(bfRef);
        Optional<BaseProduct> prod = ((BookingFile)bfCtr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(p -> p.getUid().equals(request.getProductUid()) && p instanceof Product).findFirst();
        if (!prod.isPresent()) {
            throw Xeption.forAdmin((String)String.format("Product with uid %s is not an air product", request.getProductUid()), (Object[])new Object[0]);
        }
        Product product = (Product)prod.get();
        boolean includeAgencyFeesIntoTaxes = (Boolean)MiscUtil.guarded((Object)request.isIncludeAgencyFeesIntoTaxes(), (Object)request.isUseFeesAsTaxes(), (Object[])new Boolean[]{false});
        boolean includeVendorFeesIntoTaxes = (Boolean)MiscUtil.guarded((Object)request.isIncludeVendorFeesIntoTaxes(), (Object)request.isUseFeesAsTaxes(), (Object[])new Boolean[]{false});
        ItineraryReceiptRender render = new ItineraryReceiptRender();
        FilledTemplateDocument file = render.renderReport(bfCtr, product, templateContainer, notes, false, false, false, true, false, true, includeAgencyFeesIntoTaxes, true, includeVendorFeesIntoTaxes, false, false, false);
        file.setContent(JasperUtil.convertToPdf((byte[])file.getContent()));
        file.setContentType(ContentType.PDF);
        BinaryData binaryData = new BinaryData();
        binaryData.setContentType(file.getContentType());
        binaryData.setData(file.getContent());
        DownloadableData result = new DownloadableData();
        result.setFileName("itineraryReceipt.pdf");
        result.setContent(binaryData);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

