/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.avia.getItineraryReceipt;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.ExtApiV2IBusContextKeys;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2GetItineraryReceiptParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.parsers.helpers.ParsersHelper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExtApiV2GetItineraryReceiptsSearchBookingsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SearchResult bookingFileSearchResult;
        ExtApiV2GetItineraryReceiptParameters request = (ExtApiV2GetItineraryReceiptParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SearchQuery query = new SearchQuery();
        if (TextUtil.nonBlank((String)request.getPnr())) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)request.getPnr(), (boolean)true), SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)ParsersHelper.translitPnr((String)request.getPnr(), (boolean)false), (boolean)true)}));
        }
        if (TextUtil.nonBlank((String)request.getTicketNumber())) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)BookingFileIndex.Property.ticketNumbers.name(), (Object)request.getTicketNumber()));
        }
        if ((bookingFileSearchResult = EntityStorage.get().search(BookingFileIndex.class, query)).getTotalCount() == 0) {
            throw Xeption.forEndUser((String)String.format("No booking file found for pnr: %s, ticketNumber: %s", request.getPnr(), request.getTicketNumber()), (Object[])new Object[0]);
        }
        List bookingSources = bookingFileSearchResult.getData().stream().map(BookingFileIndex::getSource).collect(Collectors.toList());
        List bookingFiles = bookingSources.stream().map(source -> EntityStorage.get().resolve(source)).filter(Objects::nonNull).map(EntityContainer::getEntity).collect(Collectors.toList());
        List navigationKeys = TextUtil.isBlank((String)request.getTicketNumber()) ? bookingFiles.stream().flatMap(booking -> booking.getReservations().stream()).filter(res -> MiscUtil.equals((Object)request.getPnr(), (Object)CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)res), (boolean)false)).flatMap(res -> res.getProducts().stream()).map(BaseIdentity::getUid).collect(Collectors.toList()) : bookingFiles.stream().flatMap(bookingFile -> BookingHelper.findAirProductsByNumber((BookingFile)bookingFile, (String)request.getTicketNumber()).stream()).map(BaseIdentity::getUid).collect(Collectors.toList());
        ctx.putObject((Enum)ExtApiV2IBusContextKeys.SOURCES, bookingSources);
        ctx.putObject((Enum)ExtApiV2IBusContextKeys.NAVIGATION_KEYS, navigationKeys);
    }
}

