/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.avia.searchFlights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyParameters;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.avia.ExtApiV2AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2SearchFlightsParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ExtApiV2SearchFlightsParametersConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV2SearchFlightsParameters parameters = (ExtApiV2SearchFlightsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        TravelPolicyParameters travelPolicyParams = (TravelPolicyParameters)ctx.getObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PARAMETERS);
        if (travelPolicyParams != null) {
            salesContext.setClient(travelPolicyParams.getClientRef());
        }
        FlightSearchParameters flightSearchParameters = new FlightSearchParameters();
        flightSearchParameters.setServiceClass(parameters.getClassOfService());
        flightSearchParameters.getPreferredAirlines().addAll(parameters.getPreferredAirlines());
        flightSearchParameters.setSkipConnected(parameters.isDirect());
        Date minimumDate = ExtApiV2AviaConverterHelper.getMinimumDate((EntityReference<SMSite>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE)));
        flightSearchParameters.getRoute().addAll(parameters.getFlightLegs().stream().map(fl -> {
            RouteSegment seg = new RouteSegment();
            ExtApiV2AviaConverterHelper.populateSegment(minimumDate, fl, seg);
            return seg;
        }).collect(Collectors.toList()));
        DictionaryReference childType = DictHelper.getChildPassengerType();
        List seats = parameters.getPassengers().entrySet().stream().filter(entry -> !childType.equals(entry.getKey())).map(e -> this.createSeat((DictionaryReference<PassengerType>)((DictionaryReference)e.getKey()), (Integer)e.getValue())).collect(Collectors.toList());
        flightSearchParameters.getSeats().addAll(seats);
        int childsCount = parameters.getPassengers().getOrDefault(childType, 0);
        Collection childSeats = IntStream.range(0, childsCount).mapToObj(i -> {
            DictionaryReference targetType = childType;
            if (i < parameters.getChildsAge().size()) {
                targetType = DictHelper.getChildPassengerType((int)((Integer)parameters.getChildsAge().get(i)));
            }
            return this.createSeat((DictionaryReference<PassengerType>)targetType, 1);
        }).collect(Collectors.toMap(SeatPreferences::getPassengerType, Function.identity(), (sp1, sp2) -> {
            sp1.setCount(sp1.getCount() + 1);
            return sp1;
        })).values();
        flightSearchParameters.getSeats().addAll(childSeats);
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)flightSearchParameters);
    }

    private SeatPreferences createSeat(DictionaryReference<PassengerType> type, int count) {
        SeatPreferences seatPref = new SeatPreferences();
        seatPref.setPassengerType(type);
        seatPref.setCount(count);
        return seatPref;
    }
}

