/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.avia.searchFlights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.PriceDisplayStyle;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyParameters;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyApplicable;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.common.ExtApiV2CommonConverterHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.AviaPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.avia.ExtApiV2AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2BestFlights;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2SearchFlightsResult;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public final class ExtApiV2SearchFlightsResultConverter
extends BaseProcessor {
    private static final DateTimeFormatter TF = DateTimeFormatter.ofPattern("HH:mm");

    public void process(MessageContext ctx) throws Exception {
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        Collection gdsFlights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        TravelPolicyParameters travelPolicyParams = (TravelPolicyParameters)ctx.getObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PARAMETERS);
        PriceDisplayStyle displayStyle = CommonHelper.getStep2Settings((EntityReference<SMSite>)siteRef).getPriceDisplayStyle();
        ExtApiV2SearchFlightsResult result = new ExtApiV2SearchFlightsResult();
        PriceComponentsParameters componentsParameters = this.getPriceConverterParameters(ctx);
        gdsFlights.stream().filter(flight -> flight.getCarrier() != null).forEach(flight -> ExtApiV2AviaConverterHelper.addFlightToBestPrices(flight, result.getBestPrices(), AviaPriceComponents.builder(flight, componentsParameters).build()));
        result.getBestPrices().entrySet().stream().forEach(bestFlightsEntry -> Collections.sort(((ExtApiV2BestFlights)bestFlightsEntry.getValue()).getBestFlights(), (bf1, bf2) -> ExtApiV2CommonConverterHelper.MONEY_COMPARATOR.compare(bf1.getPrice(), bf2.getPrice())));
        for (Flight flight2 : gdsFlights) {
            if (CommonConverterHelper.shouldExcludeFromSearchResults((TravelPolicyApplicable)flight2) || flight2.getCarrier() == null) continue;
            this.log.warn(this.noValidatingCarrierWarning(flight2));
            result.getFlights().add(ExtApiV2AviaConverterHelper.convertFlightSearchItem2Rest(flight2, componentsParameters, displayStyle, false, travelPolicyParams));
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private String noValidatingCarrierWarning(Flight flight) {
        StringBuilder builder = new StringBuilder("No validating carrier for the flight:");
        List segments = FlightHelper.getSegments((Flight)flight);
        int segmentNumber = 0;
        for (FlightSegment segment : segments) {
            builder.append("\n").append("segment").append(++segmentNumber).append("(").append(segment.getLocationBegin().getCode()).append("->").append(segment.getLocationEnd().getCode()).append(")  departureTime: ").append(TF.format(MiscUtil.toLocalTime((Date)segment.getDateBegin()))).append(" arrivalTime: ").append(TF.format(MiscUtil.toLocalTime((Date)segment.getDateEnd()))).append(" flightNumber: ").append(segment.getFlightNumber());
        }
        return builder.toString();
    }

    protected PriceComponentsParameters getPriceConverterParameters(MessageContext ctx) {
        return PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER)), (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT));
    }
}

