/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.avia.searchFlights;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyParameters;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2Person;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2SearchFlightsParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2SearchFlightsParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.ArrayList;
import java.util.Date;

public class ExtApiV2SearchFlightsTravelPolicyParametersValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        boolean hasTravelPolicy;
        ExtApiV2SearchFlightsParameters parameters = (ExtApiV2SearchFlightsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        boolean bl = hasTravelPolicy = TextUtil.nonBlank((String)parameters.getClient()) || TextUtil.nonBlank((String)parameters.getPersonCategory()) || !parameters.getPersons().isEmpty();
        if (!hasTravelPolicy) {
            return;
        }
        EntityReference clientRef = null;
        EntityContainer clientCtr = null;
        if (TextUtil.nonBlank((String)parameters.getClient())) {
            clientRef = new EntityReference(parameters.getClient(), Organization.class, null);
            clientCtr = EntityStorage.get().resolve(clientRef);
            if (clientCtr != null) {
                clientRef = clientCtr.toReference();
            } else {
                parameters.getValidationContext().getClientValidationMessages().add(ExtApiV2SearchFlightsParametersValidationMessages.getInvalidClient());
            }
        }
        EmployeeCategory employeeCategory = null;
        ArrayList<EntityReference> persons = parameters.getPersons().isEmpty() ? null : new ArrayList<EntityReference>();
        for (int i = 0; i < parameters.getPersons().size(); ++i) {
            ExtApiV2Person personParam = (ExtApiV2Person)parameters.getPersons().get(i);
            EntityReference<Organization> companyRef = null;
            Person person = null;
            String personUid = personParam.getUid();
            if (TextUtil.nonBlank((String)personUid)) {
                EntityReference personRef = new EntityReference(personUid, Person.class, null);
                EntityContainer personCtr = EntityStorage.get().resolve(personRef);
                if (personCtr != null) {
                    persons.add(personCtr.toReference());
                    person = (Person)personCtr.getEntity();
                    companyRef = ExtApiV2SearchFlightsTravelPolicyParametersValidator.getCompany(person);
                    if (companyRef != null && null == clientRef) {
                        clientCtr = EntityStorage.get().resolve(companyRef);
                        if (clientCtr != null) {
                            clientRef = clientCtr.toReference();
                        } else {
                            companyRef = null;
                        }
                    }
                }
            }
            if (null == companyRef || !companyRef.equals((Object)clientRef)) {
                parameters.getValidationContext().getPersonsListValidationMessages().computeIfAbsent(i, p -> new ArrayList()).add(ExtApiV2SearchFlightsParametersValidationMessages.getInvalidPerson());
                continue;
            }
            EmployeeCategory employeeCategory2 = GeneralProductHelper.getEmployeeCategory(companyRef, person);
            if (0 == i) {
                employeeCategory = employeeCategory2;
                continue;
            }
            if (GeneralProductHelper.isEmployeeCategoriesEquals((EmployeeCategory)employeeCategory, (EmployeeCategory)employeeCategory2)) continue;
            parameters.getValidationContext().getPersonsListValidationMessages().computeIfAbsent(i, p -> new ArrayList()).add(ExtApiV2SearchFlightsParametersValidationMessages.getInvalidPersonEmployeeCategory());
        }
        String personCategory = parameters.getPersonCategory();
        if (TextUtil.nonBlank((String)personCategory)) {
            if (clientCtr != null) {
                EmployeeCategory employeeCategory2 = ((Organization)clientCtr.getEntity()).getEmployeeCategories().stream().filter(ec -> ec.getName().getValues().values().stream().anyMatch(personCategory::equalsIgnoreCase)).findFirst().orElse(null);
                if (null == employeeCategory2) {
                    parameters.getValidationContext().getPersonCategoryValidationMessages().add(ExtApiV2SearchFlightsParametersValidationMessages.getInvalidPersonCategory());
                } else if (parameters.getPersons().isEmpty()) {
                    employeeCategory = employeeCategory2;
                } else if (!employeeCategory2.equals((Object)employeeCategory)) {
                    parameters.getValidationContext().getPersonCategoryValidationMessages().add(ExtApiV2SearchFlightsParametersValidationMessages.getInvalidPersonEmployeeCategory());
                }
            } else if (parameters.getPersons().size() == 0 && parameters.getValidationContext().getClientValidationMessages().isEmpty()) {
                parameters.getValidationContext().getClientValidationMessages().add(ExtApiV2SearchFlightsParametersValidationMessages.getInvalidClient());
            }
        }
        if (!ValidationHelper.isValid((Validatable)parameters)) {
            throw new ValidationException();
        }
        TravelPolicyParameters travelPolicyParams = new TravelPolicyParameters();
        travelPolicyParams.setClientRef(clientRef);
        if (employeeCategory != null) {
            travelPolicyParams.getPersonCategories().add(employeeCategory);
        }
        if (persons != null) {
            travelPolicyParams.getPersons().addAll(persons);
        }
        ctx.putObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PARAMETERS, (Object)travelPolicyParams);
    }

    private static EntityReference<Organization> getCompany(Person person) {
        if (person == null) {
            return null;
        }
        Date now = new Date();
        for (PersonEmployment pe : person.getEmployments()) {
            if (pe.getOrganization() == null || !pe.isMainEmployment() || pe.getOpened() != null && !pe.getOpened().before(now) || pe.getClosed() != null && !pe.getClosed().after(now)) continue;
            return pe.getOrganization();
        }
        return null;
    }
}

