/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.avia.selectFlight;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.externalApi.extApiV2.avia.ExtApiV2AviaToken;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.avia.ExtApiV2AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2Flight;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2FlightParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.avia.ExtApiV2SelectFlightResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Iterator;
import java.util.List;

public class ExtApiV2SelectFlightResultConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV2FlightParameters parameters = (ExtApiV2FlightParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Flight selectedFlight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMGeneralSettings generalSettings = CommonHelper.getGeneralSettings((EntityReference<SMSite>)siteRef);
        ExtApiV2SelectFlightResult result = new ExtApiV2SelectFlightResult();
        ExtApiV2Flight restFlight = ExtApiV2AviaConverterHelper.convertFlight2Rest(selectedFlight, this.getPriceConverterParameters(ctx), generalSettings, true);
        restFlight.setInternational(ExtApiV2AviaConverterHelper.isInternationalFlight(selectedFlight));
        result.setFlight(restFlight);
        ExtApiV2AviaToken token = ExtApiV2AviaConverterHelper.convertRestToken2Flight(parameters.getFlightToken());
        Flight oldFlight = token.getFlight();
        token.setFlight(selectedFlight);
        result.setFlightToken(ExtApiV2AviaConverterHelper.convertFlight2RestToken(token));
        result.setSegmentsChanged(this.isSegmentsChanged(oldFlight, selectedFlight));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    boolean isSegmentsChanged(Flight oldFlight, Flight selectedFlight) {
        List oldSegments = FlightHelper.getFlightSegmentsList((Flight)oldFlight);
        List newSegments = FlightHelper.getFlightSegmentsList((Flight)selectedFlight);
        if (oldSegments.size() != newSegments.size()) {
            return true;
        }
        Iterator oldIterator = oldSegments.iterator();
        for (FlightSegment newSegment : newSegments) {
            FlightSegment oldSegment = (FlightSegment)oldIterator.next();
            if (oldSegment.getDateBegin().compareTo(newSegment.getDateBegin()) == 0) continue;
            return true;
        }
        return false;
    }

    protected PriceComponentsParameters getPriceConverterParameters(MessageContext ctx) {
        return PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER)), (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT));
    }
}

