/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.profile.GdsReference;
import com.gridnine.xtrip.common.model.profile.GdsReferenceIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2ExternalCode;
import com.gridnine.xtrip.server.externalApi.security.ExtApiV2SecurityHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2AgentReference;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ExtApiV2BookingHelper {
    public static final String UPDATE_ORDER_PROCESS = "updateOrder";
    public static final String UPDATE_PRODUCTS_PROCESS = "updateProducts";

    public static void checkBookingCustomer(EntityContainer<BookingFile> bookingCtr) {
        EntityReference customerProfile = ((BookingFile)bookingCtr.getEntity()).getCustomerProfile();
        if (customerProfile == null) {
            throw Xeption.forEndUser((String)("Missing customer profile in the booking " + ((BookingFile)bookingCtr.getEntity()).getNumber()), (Object[])new Object[0]);
        }
        if (ExtApiV2SecurityHelper.isOrganizationRestricted((EntityReference)customerProfile)) {
            throw Xeption.forEndUser((String)String.format("Booking with uid [%s] has a customer with a restricted access. Operations with the booking are forbidden.", bookingCtr.getUid()), (Object[])new Object[0]);
        }
    }

    public static String getSalesPointCode(EntityReference<SalesPoint> salesPointRef) {
        EntityContainer salesPointCtr = EntityStorage.get().resolve(salesPointRef);
        return salesPointCtr != null ? ((SalesPoint)salesPointCtr.getEntity()).getCode() : null;
    }

    public static EntityReference<SalesPoint> findSalesPoint(String code) {
        if (TextUtil.nonBlank((String)code)) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SalesPointIndex.Property.code.name(), (Object)code));
            SearchResult result = EntityStorage.get().search(SalesPointIndex.class, query);
            return result.getTotalCount() == 1 ? ((SalesPointIndex)result.getData().get(0)).getSource() : null;
        }
        return null;
    }

    public static ExtApiV2AgentReference convertAgentToGdsReference(EntityReference<Person> agentReference, Date issueDate) {
        List gdsReferences;
        Optional<GdsReference> sabreRef;
        GdsReference gdsRef;
        EntityContainer personCtr = EntityStorage.get().resolve(agentReference);
        if (personCtr != null && (gdsRef = (sabreRef = (gdsReferences = ((Person)personCtr.getEntity()).getGdsReferences().stream().filter(ref -> !(ref.getClosed() != null && !ref.getClosed().after(issueDate) || ref.getOpened() != null && !ref.getOpened().before(issueDate))).collect(Collectors.toList())).stream().filter(ref -> ref.getGdsName() == GdsName.SABRE).findFirst()).orElseGet(() -> gdsReferences.stream().findFirst().orElse(null))) != null) {
            ExtApiV2AgentReference ref2 = new ExtApiV2AgentReference();
            ref2.setGdsName(gdsRef.getGdsName());
            ref2.setReference(gdsRef.getReference());
            return ref2;
        }
        return null;
    }

    public static EntityReference<Person> findAgent(ExtApiV2AgentReference reference, LocalDateTime issueTime) {
        EntityReference<Person> result = null;
        if (reference != null && (result = ExtApiV2BookingHelper.findAgentByExternalCode(reference.getExternalCode())) == null) {
            result = ExtApiV2BookingHelper.findAgentByGdsReference(reference.getGdsName(), reference.getReference(), issueTime);
        }
        return result;
    }

    private static EntityReference<Person> findAgentByExternalCode(ExtApiV2ExternalCode externalCode) {
        if (externalCode != null) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.externalCodes.name(), (Object)externalCode.getCode()));
            List result = EntityStorage.get().search(PersonIndex.class, query).getData();
            if (CollectionUtil.isNotEmpty((Collection)result)) {
                boolean match;
                if (result.size() > 1) {
                    throw Xeption.forAdmin((String)String.format("More than 1 agent was found for external code: external system: [%s], code: [%s].", externalCode.getSystem(), externalCode.getCode()), (Object[])new Object[0]);
                }
                EntityContainer personCtr = EntityStorage.get().resolve(((PersonIndex)result.get(0)).getSource());
                if (personCtr != null && (match = ((Person)personCtr.getEntity()).getExternalCodesV2().stream().anyMatch(code -> MiscUtil.equals((Object)code.getCode(), (Object)externalCode.getCode()) && (code.getSystem() == null && TextUtil.isBlank((String)externalCode.getSystem()) || code.getSystem() != null && MiscUtil.equals((Object)code.getSystem().getCode(), (Object)externalCode.getSystem()))))) {
                    return ((PersonIndex)result.get(0)).getSource();
                }
            }
        }
        return null;
    }

    private static EntityReference<Person> findAgentByGdsReference(GdsName gdsName, String reference, LocalDateTime issueTime) {
        if (TextUtil.isBlank((String)reference) || gdsName == null) {
            return null;
        }
        Date issueDate = DateUtils.toJavaDate((LocalDateTime)issueTime) != null ? DateUtils.toJavaDate((LocalDateTime)issueTime) : new Date();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)GdsReferenceIndex.Property.gdsName.name(), (Object)gdsName), SearchCriterion.eq((String)GdsReferenceIndex.Property.reference.name(), (Object)reference)}));
        SearchResult search = EntityStorage.get().search(GdsReferenceIndex.class, query);
        List result = search.getData().stream().filter(idx -> !(idx.getClosed() != null && !idx.getClosed().after(issueDate) || idx.getOpened() != null && !idx.getOpened().before(issueDate))).collect(Collectors.toList());
        if (!result.isEmpty()) {
            if (search.getData().size() > 1) {
                throw Xeption.forAdmin((String)String.format("More than 1 agent reservation system reference was found for reference: reservation system: [%s], reference: [%s].", gdsName, reference), (Object[])new Object[0]);
            }
            return ((GdsReferenceIndex)result.get(0)).getSource();
        }
        return null;
    }

    public static EntityReference<BookingFile> getBookingFileReference(String bookingFileUid, String bookingFileNumber) {
        if (bookingFileUid != null) {
            if (!EntityStorage.get().isAvailable(BookingFile.class, bookingFileUid)) {
                throw Xeption.forEndUser((String)"BOOKING_WITH_UID_NOT_FOUND", (Object[])new Object[]{bookingFileUid});
            }
            return EntityStorage.get().actualize(new EntityReference(bookingFileUid, BookingFile.class, null), new EntityStorageActualizeParameters().processedUncachedEntity(true));
        }
        EntityReference bfRef = EntityStorage.get().findReference(BookingFileIndex.class, BookingFileIndex.Property.fullNumber.name(), (Object)bookingFileNumber);
        if (bfRef != null) {
            return bfRef;
        }
        throw Xeption.forEndUser((String)"BOOKING_WITH_NUMBER_NOT_FOUND", (Object[])new Object[]{bookingFileNumber});
    }
}

