/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.standard.helpers.HttpHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2ProductType;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.correspondence.ExtApiV2RestCorrespondenceParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseOrder;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseProduct;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2OrderValidationMessages;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2Reservation;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.correspondence.ExtApiV2RestCorrespondenceValidationMessages;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class ExtApiV2BookingValidationHelper {
    public static boolean validateCorrespondence(ExtApiV2RestCorrespondenceParameters parameters) {
        AtomicBoolean valid = new AtomicBoolean(true);
        if (TextUtil.isBlank((String)parameters.getBookingNumber())) {
            valid.set(false);
            parameters.getValidationContext().getBookingNumberValidationMessages().add(ExtApiV2RestCorrespondenceValidationMessages.getMissingBookingNumber());
        }
        if (TextUtil.isBlank((String)parameters.getComment()) && (parameters.getAttachments().isEmpty() || parameters.getAttachments().stream().anyMatch(a -> TextUtil.isBlank((String)a.getContent())))) {
            valid.set(false);
            parameters.getValidationContext().getCommentValidationMessages().add(ExtApiV2RestCorrespondenceValidationMessages.getMissingContent());
        }
        parameters.getAttachments().forEach(a -> {
            if (TextUtil.nonBlank((String)a.getContent()) && TextUtil.isBlank((String)a.getName())) {
                valid.set(false);
                parameters.getValidationContext().getAttachmentsValidationMessages().add(ExtApiV2RestCorrespondenceValidationMessages.getMissingFileName());
            }
            if (TextUtil.nonBlank((String)a.getContent()) && TextUtil.nonBlank((String)a.getName()) && HttpHelper.detectContentType((String)a.getName()) == ContentType.BINARY) {
                valid.set(false);
                parameters.getValidationContext().getAttachmentsValidationMessages().add(ExtApiV2RestCorrespondenceValidationMessages.getMissingContentType());
            }
        });
        return valid.get();
    }

    public static boolean validateRecordLocator(ExtApiV2Reservation reservation) {
        return reservation.getProducts().stream().noneMatch(product -> product.getProductType() == ExtApiV2ProductType.UNIVERSAL_PRODUCT);
    }

    public static boolean validateGdsName(ExtApiV2Reservation reservation) {
        return reservation.getProducts().stream().noneMatch(product -> product.getProductType() == ExtApiV2ProductType.UNIVERSAL_PRODUCT || product.getProductType() == ExtApiV2ProductType.TRANSFER);
    }

    public static void validateTravellers(ExtApiV2BaseOrder order) {
        order.getTravellers().forEach(traveller -> {
            if (TextUtil.isBlank((String)traveller.getUid())) {
                traveller.getValidationContext().getUidValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingUID());
            }
        });
    }

    public static void validateProducts(ExtApiV2BaseOrder order) {
        order.getReservations().forEach(res -> res.getProducts().forEach(product -> {
            if (product.getProductType() == null) {
                product.getValidationContext().getProductTypeValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingProductType());
            }
            if (product.getProductStatus() == null) {
                product.getValidationContext().getProductStatusValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingProductStatus());
            }
            if (ExtApiV2BookingValidationHelper.isRefundOrExchange(product) && !ExtApiV2BookingValidationHelper.hasRelatedSell(product, res)) {
                product.getValidationContext().getPreviousProductUidValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingRelatedSell((String)product.getUid(), (ProductStatus)product.getProductStatus()));
            }
        }));
    }

    private static boolean isRefundOrExchange(ExtApiV2BaseProduct product) {
        return product.getProductStatus() == ProductStatus.REFUND || product.getProductStatus() == ProductStatus.EXCHANGE;
    }

    private static boolean hasRelatedSell(ExtApiV2BaseProduct refundOrExchange, ExtApiV2Reservation reservation) {
        if (refundOrExchange.getPreviousProductUid() == null) {
            return false;
        }
        return reservation.getProducts().stream().anyMatch(prod -> Objects.equals(refundOrExchange.getPreviousProductUid(), prod.getUid()) && prod.getProductStatus() == ProductStatus.SELL);
    }

    private ExtApiV2BookingValidationHelper() {
    }
}

