/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.createEmptyOrder;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.common.ExtApiV2CommonConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2Organization;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2EmptyOrder;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2OrderMessages;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.stream.Collectors;

public class ExtApiV2PrepareEmptyOrderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV2EmptyOrder order = (ExtApiV2EmptyOrder)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer bookingCtr = new EntityContainer(BookingFile.class);
        ((BookingFile)bookingCtr.getEntity()).setCreateDate(order.getCreateDate() == null ? new Date() : DateUtils.toJavaDate((LocalDateTime)order.getCreateDate()));
        ExtApiV2Organization organization = order.getClientProfile();
        EntityReference customer = null;
        if (TextUtil.nonBlank((String)organization.getUid()) || TextUtil.nonBlank((String)organization.getKpp()) && TextUtil.nonBlank((String)organization.getInn()) || TextUtil.nonBlank((String)organization.getCode())) {
            customer = ExtApiV2CommonConverterHelper.findOrganization((ExtApiV2Organization)organization, (boolean)false);
        }
        if (customer == null) {
            order.getValidationContext().getClientProfileValidationMessages().add(ExtApiV2OrderMessages.getCustomerNotFound((String)organization.getUid(), (String)organization.getInn(), (String)organization.getKpp(), (String)organization.getCode()));
            EntityContainer retailCtr = ProfileHelper.getRetailProfileContainer();
            customer = retailCtr != null ? retailCtr.toReference() : null;
        }
        ((BookingFile)bookingCtr.getEntity()).setCustomerProfile(customer);
        ExtApiV2Organization agencyRest = order.getAgencyProfile();
        if (agencyRest != null && (TextUtil.nonBlank((String)agencyRest.getUid()) || TextUtil.nonBlank((String)agencyRest.getKpp()) && TextUtil.nonBlank((String)agencyRest.getInn()) || TextUtil.nonBlank((String)agencyRest.getCode()))) {
            EntityReference agency = null;
            try {
                agency = ExtApiV2CommonConverterHelper.findOrganization((ExtApiV2Organization)agencyRest, (boolean)false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (agency == null) {
                order.getValidationContext().getAgencyProfileValidationMessages().add(ExtApiV2OrderMessages.getAgencyNotFound((String)organization.getUid(), (String)organization.getInn(), (String)organization.getKpp(), (String)organization.getCode()));
            } else {
                ((BookingFile)bookingCtr.getEntity()).setAgency(agency);
            }
        }
        ((BookingFile)bookingCtr.getEntity()).getExternalCodes().addAll(order.getExternalCodes().stream().map(ExtApiV2CommonConverterHelper::convertRest2ExternalSystemCode).collect(Collectors.toList()));
        bookingCtr.getVersionInfo().setDataSource("ext-api");
        EntityStorage.get().save(bookingCtr, true);
        ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE, (Object)bookingCtr);
    }
}

