/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.getOrder;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.externalApi.security.ExtApiV2SecurityHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.searchOrder.ExtApiV2OrderConverter;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2GetOrderParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2OrderMessages;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.List;

public class ExtApiV2GetOrderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV2GetOrderParameters params = (ExtApiV2GetOrderParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference currentUser = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        this.validateParams(params);
        SearchQuery query = new SearchQuery();
        if (TextUtil.nonBlank((String)params.getUid())) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)params.getUid()));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BookingFileIndex.Property.fullNumber.name(), (Object)params.getNumber()));
        }
        List searchResult = ExtApiV2SecurityHelper.secureSearch((EntityReference)currentUser, BookingFileIndex.class, (SearchQuery)query);
        if (searchResult.isEmpty()) {
            throw Xeption.forEndUser((String)ExtApiV2OrderMessages.getBookingFileNotFound2((String)params.getUid(), (String)params.getNumber()).getText(), (Object[])new Object[0]);
        }
        EntityContainer result = EntityStorage.get().resolve(((BookingFileIndex)searchResult.get(0)).getSource());
        if (result == null) {
            throw Xeption.forEndUser((String)ExtApiV2OrderMessages.getBookingFileNotFound2((String)params.getUid(), (String)params.getNumber()).getText(), (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)ExtApiV2OrderConverter.convertBookingFile2RestOrder((EntityContainer<BookingFile>)result));
    }

    private void validateParams(ExtApiV2GetOrderParameters params) {
        if (TextUtil.isBlank((String)params.getUid()) && TextUtil.isBlank((String)params.getNumber())) {
            params.getValidationContext().getUidValidationMessages().add(ExtApiV2OrderMessages.getMissingOrderUidNumber());
        }
        if (!ValidationHelper.isValid((Validatable)params)) {
            throw new ValidationException();
        }
    }
}

