/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.getOrders;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2ProductHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2GetOrdersResult;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2OrderInfo;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.joda.time.LocalDateTime;

public class ExtApiV2GetOrdersResultConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List productIndices = (List)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCTS_LIST);
        ExtApiV2GetOrdersResult restResult = new ExtApiV2GetOrdersResult();
        restResult.getOrders().addAll(productIndices.stream().collect(Collectors.groupingBy(CommonProductIndex::getBookingNumber)).entrySet().stream().map(bfNum2Prods -> {
            ExtApiV2OrderInfo orderInfo = new ExtApiV2OrderInfo();
            List indices = (List)bfNum2Prods.getValue();
            List recordLocators = indices.stream().map(CommonProductIndex::getDisplayedRecordLocator).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (recordLocators.isEmpty()) {
                recordLocators = indices.stream().map(CommonProductIndex::getRecordLocator).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            }
            orderInfo.getPnr().addAll(recordLocators);
            orderInfo.setUid((String)indices.stream().map(CommonProductIndex::getSource).filter(Objects::nonNull).map(EntityReference::getUid).findAny().orElse(null));
            orderInfo.setNumber((String)bfNum2Prods.getKey());
            orderInfo.setCreationDate((LocalDateTime)indices.stream().map(CommonProductIndex::getBookingCreateDate).filter(Objects::nonNull).map(LocalDateTime::fromDateFields).findAny().orElse(null));
            orderInfo.setChangeDate((LocalDateTime)indices.stream().map(CommonProductIndex::getModified).filter(Objects::nonNull).max(Date::compareTo).map(LocalDateTime::fromDateFields).orElse(null));
            orderInfo.getProducts().addAll(indices.stream().filter(ExtApiV2ProductHelper::isRestSupportedProduct).map(ExtApiV2ProductHelper::convertProductInfo2Rest).collect(Collectors.toList()));
            return orderInfo;
        }).collect(Collectors.toList()));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)restResult);
    }
}

