/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.getTravelDocuments;

import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.DownloadableData;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.ExtApiV2IBusContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.io.ByteArrayOutputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ExtApiV2GetTravelDocumentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        byte[] zipArchive;
        List bookingSources = (List)ctx.getMandatoryObject((Enum)ExtApiV2IBusContextKeys.SOURCES);
        Set navigationKeys = (Set)ctx.getMandatoryObject((Enum)ExtApiV2IBusContextKeys.NAVIGATION_KEYS);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEntityCriterion((String)BasicDocumentIndex.Property.owner.name(), (Collection)bookingSources));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqStringCriterion((String)"navigationKey", (Collection)navigationKeys));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEnumCriterion((String)BasicDocumentIndex.Property.type.name(), EnumSet.of(DocumentType.RECEIPT, DocumentType.TRAVELDOCUMENT, DocumentType.SPECIAL_TRAVELDOCUMENT, DocumentType.VOUCHER)));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BasicDocumentIndex.Property.contentType.name(), (Object)ContentType.JASPERPRINT), SearchCriterion.eq((String)BasicDocumentIndex.Property.contentType.name(), (Object)ContentType.PDF)}));
        SearchResult documentsSearchResult = EntityStorage.get().search(BasicDocumentIndex.class, query);
        List documentContainers = documentsSearchResult.getData().stream().map(docIdx -> EntityStorage.get().resolve(docIdx.getSource())).filter(Objects::nonNull).collect(Collectors.toList());
        if (documentContainers.size() == 0) {
            throw Xeption.forEndUser((String)"No travel documents found by requested data", (Object[])new Object[0]);
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            try (ZipOutputStream zos = new ZipOutputStream(bos);){
                HashMap<String, Integer> titles = new HashMap<String, Integer>();
                for (EntityContainer docCtr : documentContainers) {
                    BaseFileDocument doc = (BaseFileDocument)docCtr.getEntity();
                    byte[] docContent = doc.getContentType() == ContentType.JASPERPRINT ? JasperUtil.convertToPdf((byte[])doc.getContent()) : doc.getContent();
                    String title = doc.getTitle();
                    if (titles.containsKey(title)) {
                        int copy = (Integer)titles.get(title) + 1;
                        title = title + " (" + copy + ")";
                        titles.put(doc.getTitle(), copy);
                    } else {
                        titles.put(title, 0);
                    }
                    ZipEntry entry = new ZipEntry(title + ".pdf");
                    zos.putNextEntry(entry);
                    zos.write(docContent);
                    zos.closeEntry();
                }
            }
            zipArchive = bos.toByteArray();
        }
        catch (Exception e) {
            throw Xeption.forEndUser((String)"Unable to ZIP travel documents", (Throwable)e, (Object[])new Object[0]);
        }
        DownloadableData result = new DownloadableData();
        BinaryData binaryData = new BinaryData();
        binaryData.setContentType(ContentType.BINARY);
        binaryData.setData(zipArchive);
        result.setFileName("travel_documents.zip");
        result.setContent(binaryData);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

