/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.getTravelDocuments;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.ExtApiV2IBusContextKeys;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2GetTravelDocumentsParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.parsers.helpers.ParsersHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExtApiV2GetTravelDocumentsSearchBookingsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SearchResult bookingFileSearchResult;
        ExtApiV2GetTravelDocumentsParameters request = (ExtApiV2GetTravelDocumentsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SearchQuery query = new SearchQuery();
        if (TextUtil.nonBlank((String)request.getBookingNumber())) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BookingFileIndex.Property.fullNumber.name(), (Object)request.getBookingNumber()));
        }
        if (TextUtil.nonBlank((String)request.getReservationNumber())) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)request.getReservationNumber(), (boolean)true), SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)ParsersHelper.translitPnr((String)request.getReservationNumber(), (boolean)false), (boolean)true)}));
        }
        if (TextUtil.nonBlank((String)request.getProductNumber())) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)BookingFileIndex.Property.ticketNumbers.name(), (Object)request.getProductNumber()));
        }
        if ((bookingFileSearchResult = EntityStorage.get().search(BookingFileIndex.class, query)).getTotalCount() == 0) {
            throw Xeption.forEndUser((String)String.format("No booking file found for bookingNumber: %s, reservationNumber: %s, productNumber: %s", request.getBookingNumber(), request.getReservationNumber(), request.getProductNumber()), (Object[])new Object[0]);
        }
        List bookingSources = bookingFileSearchResult.getData().stream().map(BookingFileIndex::getSource).collect(Collectors.toList());
        List bookingFiles = bookingSources.stream().map(source -> EntityStorage.get().resolve(source)).filter(Objects::nonNull).map(EntityContainer::getEntity).collect(Collectors.toList());
        HashSet navigationKeys = new HashSet();
        List<Object> products = TextUtil.nonBlank((String)request.getProductNumber()) ? bookingFiles.stream().flatMap(bookingFile -> BookingHelper.findBaseProductsBySystemNumber((String)request.getProductNumber(), (BookingFile)bookingFile).stream()).collect(Collectors.toList()) : (TextUtil.nonBlank((String)request.getReservationNumber()) ? bookingFiles.stream().flatMap(booking -> booking.getReservations().stream()).filter(res -> MiscUtil.equals((Object)request.getReservationNumber(), (Object)CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)res), (boolean)false)).flatMap(res -> res.getProducts().stream()).collect(Collectors.toList()) : bookingFiles.stream().map(BookingHelper::getProducts).flatMap(Collection::stream).collect(Collectors.toList()));
        products.forEach(product -> {
            navigationKeys.add(product.getUid());
            navigationKeys.add(product.getReservation().getUid());
        });
        ctx.putObject((Enum)ExtApiV2IBusContextKeys.SOURCES, bookingSources);
        ctx.putObject((Enum)ExtApiV2IBusContextKeys.NAVIGATION_KEYS, navigationKeys);
    }
}

