/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.listDocuments;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.ExtApiV2ConverterHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.ExtApiV2BookingHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BookingFileDocument;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2ListBookingFileDocumentsParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

public class ListDocumentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV2ListBookingFileDocumentsParameters parameters = (ExtApiV2ListBookingFileDocumentsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference<BookingFile> bfRef = ExtApiV2BookingHelper.getBookingFileReference(parameters.getBookingFileUid(), parameters.getBookingFileNumber());
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), bfRef));
        if (parameters.getDocumentType() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)parameters.getDocumentType()));
        }
        if (parameters.getContentType() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.contentType.name(), (Object)parameters.getContentType()));
        }
        if (parameters.isExternalOnly()) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.external.name(), (Object)Boolean.TRUE));
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, EntityStorage.get().search(BasicDocumentIndex.class, query).getData().stream().map(ListDocumentsProcessor::buildExtApiV2BookingFileDocument).collect(Collectors.toList()));
    }

    private static ExtApiV2BookingFileDocument buildExtApiV2BookingFileDocument(BasicDocumentIndex idx) {
        ExtApiV2BookingFileDocument doc = new ExtApiV2BookingFileDocument();
        doc.setReference(ExtApiV2ConverterHelper.toApiEntityReference(idx.getSource()));
        doc.setDocumentType(idx.getType());
        doc.setExternal(idx.isExternal());
        doc.setShowOnSite(!idx.isDoNotShowOnSite());
        if (idx.getCreated() != null) {
            doc.setCreated(new DateTime(idx.getCreated().getTime()));
        }
        doc.setName(idx.getName());
        doc.setTitle(idx.getTitle());
        doc.setProductOrReservationUid(idx.getNavigationKey());
        doc.setCheckSum(idx.getCheckSum());
        return doc;
    }
}

