/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.searchOrder;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.RailwayBonusCard;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.server.externalApi.extApiV2.common.ExtApiV2CommonConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.corporateData.person.ExtApiV2PersonHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2RestBonusCards;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.ExtApiV2BookingHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.gdsAccount.ExtApiV2GdsAccountHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2ProductHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2Order;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2Reservation;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2Traveller;
import java.util.Date;
import java.util.Optional;
import java.util.stream.Collectors;

public class ExtApiV2OrderConverter {
    public static ExtApiV2Order convertBookingFile2RestOrder(EntityContainer<BookingFile> bookingFileCtr) {
        ExtApiV2Order result = new ExtApiV2Order();
        result.setUid(bookingFileCtr.getUid());
        result.setNumber(((BookingFile)bookingFileCtr.getEntity()).getNumber());
        result.setOrderRevision(bookingFileCtr.getRevision().intValue());
        result.setCreateDate(DateUtils.toLocalDateTime((Date)((BookingFile)bookingFileCtr.getEntity()).getCreateDate()));
        result.setClientProfile(ExtApiV2CommonConverterHelper.convertOrganization2Rest((EntityReference)((BookingFile)bookingFileCtr.getEntity()).getCustomerProfile()));
        result.setAgencyProfile(ExtApiV2CommonConverterHelper.convertOrganization2Rest((EntityReference)((BookingFile)bookingFileCtr.getEntity()).getAgency()));
        result.getExternalCodes().addAll(((BookingFile)bookingFileCtr.getEntity()).getExternalCodes().stream().map(ExtApiV2CommonConverterHelper::convertExternalSystemCode2Rest).collect(Collectors.toList()));
        result.getReservations().addAll(((BookingFile)bookingFileCtr.getEntity()).getReservations().stream().map(ExtApiV2OrderConverter::convertReservation2Rest).collect(Collectors.toList()));
        result.getTravellers().addAll(((BookingFile)bookingFileCtr.getEntity()).getTravellers().stream().map(ExtApiV2OrderConverter::convertTraveller2Rest).collect(Collectors.toList()));
        return result;
    }

    private static ExtApiV2Reservation convertReservation2Rest(Reservation reservation) {
        ExtApiV2Reservation result = new ExtApiV2Reservation();
        result.setUid(reservation.getUid());
        result.setGdsName(CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)reservation));
        EntityReference gdsAccountRef = reservation.getGdsNameInfo().getOnlineGdsAccount();
        if (gdsAccountRef != null) {
            Optional.ofNullable(ExtApiV2GdsAccountHandler.of(reservation)).ifPresent(gdsAccountHandler -> Optional.ofNullable(EntityStorage.get().resolve(gdsAccountRef)).ifPresent(gdsAccount -> result.setGdsAccount(gdsAccountHandler.toRest((BaseGdsAccount)gdsAccount.getEntity()))));
        }
        result.setRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation));
        result.setBookingPcc(CommonReservationGdsNameInfoHelper.getBookingPcc((Reservation)reservation, (GdsName)CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)reservation)));
        result.setReservationDate(DateUtils.toLocalDateTime((Date)reservation.getResDate()));
        result.setSubagency(ExtApiV2CommonConverterHelper.convertOrganization2Rest((EntityReference)reservation.getSubagency()));
        result.setSalesPointCode(ExtApiV2BookingHelper.getSalesPointCode((EntityReference<SalesPoint>)reservation.getSalesPoint()));
        result.setBookingAgentReference(ExtApiV2BookingHelper.convertAgentToGdsReference((EntityReference<Person>)reservation.getBookingAgent(), reservation.getResDate()));
        result.getProducts().addAll(reservation.getProducts().stream().map(product -> ExtApiV2ProductHandler.of(product).toRest((BaseProduct)product)).collect(Collectors.toList()));
        return result;
    }

    private static ExtApiV2Traveller convertTraveller2Rest(Traveller traveller) {
        ExtApiV2Traveller result = new ExtApiV2Traveller();
        result.setUid(traveller.getUid());
        result.setTravellerName(traveller.getName());
        result.setProfileReference(traveller.getPassenger());
        if (traveller.getPassport() != null) {
            result.setPassport(ExtApiV2PersonHelper.convertPassport2RestPassport((Passport)traveller.getPassport()));
        }
        result.setBonusCards(new ExtApiV2RestBonusCards());
        result.getBonusCards().getAirBonusCards().addAll(traveller.getAirlineBonusCards().stream().map(ExtApiV2CommonConverterHelper::convertAirlineBonusCard2Rest).collect(Collectors.toList()));
        if (traveller.getRailwayBonusCard() != null) {
            result.getBonusCards().getRailBonusCards().add(ExtApiV2CommonConverterHelper.convertRailwayBonusCard2Rest((RailwayBonusCard)traveller.getRailwayBonusCard()));
        }
        return result;
    }
}

