/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.searchOrder;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.externalApi.security.ExtApiV2SecurityHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2ProductHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2ProductHandlersRegistry;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2OrderValidationMessages;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2SearchOrdersParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.parsers.helpers.ParsersHelper;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExtApiV2SearchOrderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV2SearchOrdersParameters params = (ExtApiV2SearchOrdersParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference currentUser = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        this.validateParams(params);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.between((String)BookingFileIndex.Property.createDate.name(), (Object)DateUtils.toJavaDate((LocalDate)params.getCreateDate().minusDays(1L)), (Object)DateUtils.toJavaDate((LocalDate)params.getCreateDate().plusDays(1L))));
        if (TextUtil.nonBlank((String)params.getPnr())) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)params.getPnr(), (boolean)true), SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)ParsersHelper.translitPnr((String)params.getPnr(), (boolean)false), (boolean)true)}));
        }
        if (TextUtil.nonBlank((String)params.getProductNumber())) {
            query.getCriteria().getCriterions().add(SearchCriterion.icontains((String)BookingFileIndex.Property.ticketNumbers.name(), (String)params.getProductNumber()));
        }
        if (params.getProductStatus() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)BookingFileIndex.Property.productStatuses.name(), (Object)params.getProductStatus()));
        }
        List searchResult = ExtApiV2SecurityHelper.secureSearch((EntityReference)currentUser, BookingFileIndex.class, (SearchQuery)query);
        ExtApiV2ProductHandler restHandler = ExtApiV2ProductHandlersRegistry.get().findProductHandler(params.getProductType());
        List bookingFiles = searchResult.stream().map(bfi -> EntityStorage.get().resolve(bfi.getSource())).filter(Objects::nonNull).collect(Collectors.toList());
        List result = bookingFiles.stream().filter(bookingFileContainer -> BookingHelper.getProducts((BookingFile)((BookingFile)bookingFileContainer.getEntity())).stream().anyMatch(product -> (MiscUtil.equals((Object)(product.getReservation() == null ? null : CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation())), (Object)params.getPnr(), (boolean)false) || MiscUtil.equals((Object)BookingHelper.getSystemNumber((BaseProduct)product), (Object)params.getProductNumber(), (boolean)false)) && MiscUtil.equals(product.getClass(), restHandler.getProductClass(), (boolean)false))).collect(Collectors.toList());
        ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILES_COLLECTION, result);
    }

    private void validateParams(ExtApiV2SearchOrdersParameters params) {
        if (TextUtil.isBlank((String)params.getPnr()) && TextUtil.isBlank((String)params.getProductNumber())) {
            params.getValidationContext().getPnrValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingRecordLocatorOrProductNumber());
        }
        if (params.getProductType() == null) {
            params.getValidationContext().getProductTypeValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingProductType());
        }
        if (params.getCreateDate() == null) {
            params.getValidationContext().getCreateDateValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingCreateDate());
        }
        if (!ValidationHelper.isValid((Validatable)params)) {
            throw new ValidationException();
        }
    }
}

