/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.statistic;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.server.externalApi.extApiV2.common.ExtApiV2CommonConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2StandardGetMethodParam;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.ExtApiV2BookingHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.statistic.ExtApiV2StatisticHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2ProductHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2GetBookingStatisticResult;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2OrderValidationMessages;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2ProductCostCode;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2ProductStatisticInfo;
import com.gridnine.xtrip.server.ibecorp.security.acl.IbePermissionManager;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;
import java.util.stream.Collectors;

public class ExtApiV2GetBookingStatisticProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV2StandardGetMethodParam param = (ExtApiV2StandardGetMethodParam)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer<BookingFile> bookingCtr = this.getBookingContainer(param.getUid());
        ExtApiV2GetBookingStatisticResult result = new ExtApiV2GetBookingStatisticResult();
        result.setBookingUid(bookingCtr.getUid());
        result.setBookingNumber(((BookingFile)bookingCtr.getEntity()).getNumber());
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
        List products = BookingHelper.getProducts((BookingFile)((BookingFile)bookingCtr.getEntity()));
        for (BaseProduct product : products) {
            StatisticalData statisticalData;
            if (!ExtApiV2ProductHelper.isRestSupportedProduct(product) || (statisticalData = ProductHandler.of((BaseProduct)product).getStatisticalData(product)) == null) continue;
            ExtApiV2ProductStatisticInfo stat = new ExtApiV2ProductStatisticInfo();
            stat.setProductUid(product.getUid());
            stat.setProductInfo(ExtApiV2ProductHelper.convertProductInfo2Rest(product));
            stat.setCalcStatistic(ExtApiV2StatisticHelper.convertAfsData2Rest(statisticalData));
            stat.getUdids().addAll(this.getProductCostCodes(statisticalData));
            stat.getReasonCodes().addAll(statisticalData.getReasonCodes().stream().map(ExtApiV2CommonConverterHelper::convertReasonCode2Rest).collect(Collectors.toList()));
            result.getStatistic().add(stat);
        }
    }

    private EntityContainer<BookingFile> getBookingContainer(String bookingUid) throws Exception {
        EntityContainer bookingCtr = EntityStorage.get().load(BookingFile.class, bookingUid);
        if (bookingCtr == null) {
            throw Xeption.forEndUser((String)ExtApiV2OrderValidationMessages.getInvalidOrderUid().getText(), (Object[])new Object[0]);
        }
        boolean granted = IbePermissionManager.isEntityGranted(bookingCtr, StandardRestrictionResourceOperations.VIEW);
        if (!granted) {
            throw Xeption.forEndUser((String)("Permission denied for user " + UserData.get().getCurrentUser()), (Object[])new Object[0]);
        }
        ExtApiV2BookingHelper.checkBookingCustomer((EntityContainer<BookingFile>)bookingCtr);
        return bookingCtr;
    }

    private List<ExtApiV2ProductCostCode> getProductCostCodes(StatisticalData statisticalData) {
        return statisticalData.getTravellerCostCodes().stream().flatMap(costCode -> ExtApiV2StatisticHelper.convertTravellerCostCodes2Rest(costCode).stream()).collect(Collectors.toList());
    }
}

