/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.statistic;

import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2AfsPriceValue;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2ProductAFS;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2ProductCostCode;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class ExtApiV2StatisticHelper {
    ExtApiV2StatisticHelper() {
    }

    static ExtApiV2ProductAFS convertAfsData2Rest(StatisticalData statData) {
        ExtApiV2ProductAFS result = new ExtApiV2ProductAFS();
        if (statData.getHbf1Tkt() != null || statData.getHbf1Bkg() != null) {
            result.setHbf1(ExtApiV2StatisticHelper.buildAfsPriceValue(statData.getHbf1Bkg(), statData.getHbf1Tkt()));
        }
        if (statData.getHbf2Tkt() != null || statData.getHbf2Bkg() != null) {
            result.setHbf2(ExtApiV2StatisticHelper.buildAfsPriceValue(statData.getHbf2Bkg(), statData.getHbf1Tkt()));
        }
        if (statData.getLaf1Tkt() != null || statData.getLaf1Bkg() != null) {
            result.setLaf1(ExtApiV2StatisticHelper.buildAfsPriceValue(statData.getLaf1Bkg(), statData.getLaf1Tkt()));
        }
        if (statData.getLaf2Tkt() != null || statData.getLaf2Bkg() != null) {
            result.setLaf2(ExtApiV2StatisticHelper.buildAfsPriceValue(statData.getLaf2Bkg(), statData.getLaf2Tkt()));
        }
        if (statData.getLaf3Tkt() != null || statData.getLaf3Bkg() != null) {
            result.setLaf3(ExtApiV2StatisticHelper.buildAfsPriceValue(statData.getLaf3Bkg(), statData.getLaf3Tkt()));
        }
        if (statData.getAtf1Tkt() != null || statData.getAtf1Bkg() != null) {
            result.setAtf1(ExtApiV2StatisticHelper.buildAfsPriceValue(statData.getAtf1Bkg(), statData.getAtf1Tkt()));
        }
        if (statData.getAtf2Tkt() != null || statData.getAtf2Bkg() != null) {
            result.setAtf2(ExtApiV2StatisticHelper.buildAfsPriceValue(statData.getAtf2Bkg(), statData.getAtf2Tkt()));
        }
        if (statData.getLpf1Tkt() != null || statData.getLpf1Bkg() != null) {
            result.setLpf1(ExtApiV2StatisticHelper.buildAfsPriceValue(statData.getLpf1Bkg(), statData.getLpf1Tkt()));
        }
        if (statData.getLpf2Tkt() != null || statData.getLpf2Bkg() != null) {
            result.setLpf2(ExtApiV2StatisticHelper.buildAfsPriceValue(statData.getLpf2Bkg(), statData.getLpf2Tkt()));
        }
        if (statData.getLpf3Tkt() != null || statData.getLpf3Bkg() != null) {
            result.setLpf3(ExtApiV2StatisticHelper.buildAfsPriceValue(statData.getLpf3Bkg(), statData.getLpf3Tkt()));
        }
        if (statData.getP3dTkt() != null || statData.getP3dBkg() != null) {
            result.setP3d(ExtApiV2StatisticHelper.buildAfsPriceValue(statData.getP3dBkg(), statData.getP3dTkt()));
        }
        if (statData.getCtfTkt() != null || statData.getCtfBkg() != null) {
            result.setCtf(ExtApiV2StatisticHelper.buildAfsPriceValue(statData.getCtfBkg(), statData.getCtfTkt()));
        }
        result.setMinPricePerRoom(statData.getMinPricePerRoom());
        result.setRackRatePrice(statData.getRackRatePrice());
        result.setSelfBookingEconomy(statData.getSelfBookingEconomy());
        result.setFlightDuration(statData.getFlightDuration());
        result.setSalesDeeps(statData.getSalesDeeps());
        result.setOverallClassService(statData.getOverallClassService());
        result.setTravelPolicyLimit(statData.getTravelPolicyLimit());
        result.setTravelPolicyAuthorization(statData.getTravelPolicyAuthorization());
        result.setTravelPolicySalesDeepsLimit(statData.getTravelPolicySalesDeepsLimit());
        result.setTravelPolicyViolation(statData.getTravelPolicyViolation());
        return result;
    }

    static void convertAfsDataFromRest(StatisticalData statisticalData, ExtApiV2ProductAFS restData) {
        if (restData != null) {
            if (restData.getHbf1() != null) {
                statisticalData.setHbf1Bkg(restData.getHbf1().getBookingValue());
                statisticalData.setHbf1Tkt(restData.getHbf1().getTicketingValue());
            }
            if (restData.getHbf2() != null) {
                statisticalData.setHbf2Bkg(restData.getHbf2().getBookingValue());
                statisticalData.setHbf2Tkt(restData.getHbf2().getTicketingValue());
            }
            if (restData.getLaf1() != null) {
                statisticalData.setLaf1Bkg(restData.getLaf1().getBookingValue());
                statisticalData.setLaf1Tkt(restData.getLaf1().getTicketingValue());
            }
            if (restData.getLaf2() != null) {
                statisticalData.setLaf2Bkg(restData.getLaf2().getBookingValue());
                statisticalData.setLaf2Tkt(restData.getLaf2().getTicketingValue());
            }
            if (restData.getLaf3() != null) {
                statisticalData.setLaf3Bkg(restData.getLaf3().getBookingValue());
                statisticalData.setLaf3Tkt(restData.getLaf3().getTicketingValue());
            }
            if (restData.getAtf1() != null) {
                statisticalData.setAtf1Bkg(restData.getAtf1().getBookingValue());
                statisticalData.setAtf1Tkt(restData.getAtf1().getTicketingValue());
            }
            if (restData.getAtf2() != null) {
                statisticalData.setAtf2Bkg(restData.getAtf2().getBookingValue());
                statisticalData.setAtf2Tkt(restData.getAtf2().getTicketingValue());
            }
            if (restData.getLpf1() != null) {
                statisticalData.setLpf1Bkg(restData.getLpf1().getBookingValue());
                statisticalData.setLpf1Tkt(restData.getLpf1().getTicketingValue());
            }
            if (restData.getLpf2() != null) {
                statisticalData.setLpf2Bkg(restData.getLpf2().getBookingValue());
                statisticalData.setLpf2Tkt(restData.getLpf2().getTicketingValue());
            }
            if (restData.getLpf3() != null) {
                statisticalData.setLpf3Bkg(restData.getLpf3().getBookingValue());
                statisticalData.setLpf3Tkt(restData.getLpf3().getTicketingValue());
            }
            if (restData.getP3d() != null) {
                statisticalData.setP3dBkg(restData.getP3d().getBookingValue());
                statisticalData.setP3dTkt(restData.getP3d().getTicketingValue());
            }
            if (restData.getCtf() != null) {
                statisticalData.setCtfBkg(restData.getCtf().getBookingValue());
                statisticalData.setCtfTkt(restData.getCtf().getTicketingValue());
            }
            statisticalData.setMinPricePerRoom(restData.getMinPricePerRoom());
            statisticalData.setRackRatePrice(restData.getRackRatePrice());
            statisticalData.setSelfBookingEconomy(restData.getSelfBookingEconomy());
            statisticalData.setFlightDuration(restData.getFlightDuration());
            statisticalData.setSalesDeeps(restData.getSalesDeeps());
            statisticalData.setOverallClassService(restData.getOverallClassService());
            statisticalData.setTravelPolicyLimit(restData.getTravelPolicyLimit());
            statisticalData.setTravelPolicyAuthorization(restData.isTravelPolicyAuthorization());
            statisticalData.setTravelPolicySalesDeepsLimit(restData.getTravelPolicySalesDeepsLimit());
            statisticalData.setTravelPolicyViolation(restData.getTravelPolicyViolation());
        }
    }

    static List<ExtApiV2ProductCostCode> convertTravellerCostCodes2Rest(TravellerCostCodes costCode) {
        return costCode.getCostCodes().stream().map(productCostCode -> ExtApiV2StatisticHelper.convertProductCostCode2Rest(productCostCode, costCode.getTraveller().getUid())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    static ExtApiV2ProductCostCode convertProductCostCode2Rest(CostCode costCode, String passengerUid) {
        CostCodeCategory category = (CostCodeCategory)DictHelper.resolve((DictionaryReference)costCode.getCostCodeProperties().getCategory());
        if (category != null) {
            ExtApiV2ProductCostCode result = new ExtApiV2ProductCostCode();
            result.setPassengerUid(passengerUid);
            result.setSabreShortName(TextUtil.nonBlank((String)category.getShortName()) ? category.getShortName() : null);
            result.setSabreFullName(TextUtil.nonBlank((String)category.getName()) ? category.getName() : null);
            result.setValue(costCode.getValue());
            result.setRuValue(costCode.getLocalValue());
            result.setEnValue(costCode.getEnglishValue());
            return result;
        }
        return null;
    }

    private static ExtApiV2AfsPriceValue buildAfsPriceValue(Double bookingValue, Double ticketingValue) {
        ExtApiV2AfsPriceValue result = new ExtApiV2AfsPriceValue();
        result.setBookingValue(bookingValue);
        result.setTicketingValue(ticketingValue);
        return result;
    }
}

