/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.statistic;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2RestReasonCode;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.statistic.ExtApiV2StatisticHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2ProductHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.ExtApiV2CostCodeStatusResult;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.ExtApiV2ReasonCodeStatusResult;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2ProductCostCode;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2ProductStatistic;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2UpdateBookingStatisticParam;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2UpdateBookingStatisticResult;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2UpdateBookingStatisticStatus;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2UpdateProductStatisticResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ExtApiV2UpdateBookingStatisticProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        ExtApiV2UpdateBookingStatisticParam param = (ExtApiV2UpdateBookingStatisticParam)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        ExtApiV2UpdateBookingStatisticResult result = new ExtApiV2UpdateBookingStatisticResult();
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
        EntityContainer customer = EntityStorage.get().resolve(((BookingFile)bookingCtr.getEntity()).getCustomerProfile());
        List products = ((BookingFile)bookingCtr.getEntity()).getReservations().stream().flatMap(res -> res.getProducts().stream()).collect(Collectors.toList());
        param.getStatistic().forEach(stat -> products.stream().filter(p -> MiscUtil.equals((Object)p.getUid(), (Object)stat.getProductUid())).findFirst().ifPresent(product -> result.getProductsStatisticResult().add(this.updateStatistic((ExtApiV2ProductStatistic)stat, (BaseProduct)product, (EntityContainer<Organization>)customer))));
        boolean changed = result.getProductsStatisticResult().stream().anyMatch(r -> r.getReasonCodeResult().stream().anyMatch(reasonCodeResult -> reasonCodeResult.getStatus() == ExtApiV2UpdateBookingStatisticStatus.OK) || r.getUdidResult().stream().anyMatch(udidResult -> udidResult.getStatus() == ExtApiV2UpdateBookingStatisticStatus.OK));
        if (changed) {
            bookingCtr.getVersionInfo().setDataSource(ctx.getDataSource());
            bookingCtr.getVersionInfo().setVersionNotes("update statistical data");
            EntityStorage.get().save(bookingCtr, true);
        }
    }

    private ExtApiV2UpdateProductStatisticResult updateStatistic(ExtApiV2ProductStatistic stat, BaseProduct product, EntityContainer<Organization> customer) {
        ExtApiV2UpdateProductStatisticResult result = new ExtApiV2UpdateProductStatisticResult();
        ProductHandler handler = ProductHandler.of((BaseProduct)product);
        StatisticalData statData = (StatisticalData)MiscUtil.orElseGet((Object)handler.getStatisticalData(product), () -> {
            handler.newStatisticalData(product);
            return handler.getStatisticalData(product);
        });
        ExtApiV2StatisticHelper.convertAfsDataFromRest(statData, stat.getCalcStatistic());
        result.setProductInfo(ExtApiV2ProductHelper.convertProductInfo2Rest(product));
        result.getUdidResult().addAll(this.updateCostCodes(customer, product, statData, stat.getUdids()));
        result.getReasonCodeResult().addAll(this.updateReasonCodes(customer, statData, stat.getReasonCodes()));
        return result;
    }

    private List<ExtApiV2CostCodeStatusResult> updateCostCodes(EntityContainer<Organization> customer, BaseProduct product, StatisticalData statData, List<ExtApiV2ProductCostCode> restCostCodes) {
        ArrayList<ExtApiV2CostCodeStatusResult> result = new ArrayList<ExtApiV2CostCodeStatusResult>();
        HashMap pairs = new HashMap();
        ProductHandler handler = ProductHandler.of((BaseProduct)product);
        Collection travellers = handler.getTravellers(product);
        for (CostCodeProperties properties : ((Organization)customer.getEntity()).getCostCodeProperties()) {
            CostCodeCategory category = (CostCodeCategory)DictHelper.resolve((DictionaryReference)properties.getCategory());
            if (category == null) continue;
            restCostCodes.stream().filter(rcc -> TextUtil.nonBlank((String)category.getShortName()) && MiscUtil.equals((Object)category.getShortName(), (Object)rcc.getSabreShortName()) || TextUtil.nonBlank((String)category.getName()) && MiscUtil.equals((Object)category.getName(), (Object)rcc.getSabreFullName())).forEach(rcc -> pairs.put(rcc, properties));
        }
        HashMap<String, TravellerCostCodes> resultCostCodes = new HashMap<String, TravellerCostCodes>();
        for (ExtApiV2ProductCostCode rcc2 : restCostCodes) {
            Optional<Traveller> traveller;
            CostCodeProperties prop = (CostCodeProperties)pairs.get(rcc2);
            if (prop != null && (traveller = travellers.stream().filter(tr -> MiscUtil.equals((Object)tr.getPassenger().getUid(), (Object)rcc2.getPassengerUid())).findFirst()).isPresent()) {
                CostCode costCodeByValue;
                TravellerCostCodes travellerCostCode = resultCostCodes.computeIfAbsent(traveller.get().getUid(), uid -> {
                    TravellerCostCodes tcc = new TravellerCostCodes();
                    tcc.setTraveller((Traveller)traveller.get());
                    return tcc;
                });
                String costCodeValue = rcc2.getValue();
                String costCodeRuValue = rcc2.getRuValue();
                String costCodeEnValue = rcc2.getEnValue();
                if ((TextUtil.isBlank((String)costCodeRuValue) || TextUtil.isBlank((String)costCodeEnValue)) && (costCodeByValue = ProfileHelper.findCostCodeByValue((CostCodeProperties)prop, (Collection)((Organization)customer.getEntity()).getCostCodes(), (String)costCodeValue)) != null) {
                    costCodeValue = costCodeByValue.getValue();
                    costCodeEnValue = costCodeByValue.getEnglishValue();
                    costCodeRuValue = costCodeByValue.getLocalValue();
                }
                PersonCostCode costCode = new PersonCostCode();
                costCode.setCostCodeProperties(prop);
                costCode.setOrganization(customer.toReference());
                costCode.setValue(costCodeValue);
                costCode.setLocalValue(costCodeRuValue);
                costCode.setEnglishValue(costCodeEnValue);
                travellerCostCode.getCostCodes().add(costCode);
                result.add(this.buildCostCodeResult(ExtApiV2UpdateBookingStatisticStatus.OK, rcc2));
                continue;
            }
            result.add(this.buildCostCodeResult(ExtApiV2UpdateBookingStatisticStatus.FAIL, rcc2));
        }
        statData.getTravellerCostCodes().clear();
        statData.getTravellerCostCodes().addAll(resultCostCodes.values());
        return result;
    }

    private List<ExtApiV2ReasonCodeStatusResult> updateReasonCodes(EntityContainer<Organization> customer, StatisticalData statData, List<ExtApiV2RestReasonCode> restCodes) {
        ArrayList<ExtApiV2ReasonCodeStatusResult> result = new ArrayList<ExtApiV2ReasonCodeStatusResult>();
        HashSet<ReasonCode> resultCodes = new HashSet<ReasonCode>();
        for (ExtApiV2RestReasonCode restCode : restCodes) {
            Optional<ReasonCode> reasonCode = ((Organization)customer.getEntity()).getReasonCodes().stream().filter(rc -> (MiscUtil.equals((Object)rc.getName(), (Object)restCode.getCode()) || MiscUtil.equals((Object)rc.getSabreName(), (Object)restCode.getSabreName())) && rc.getType() == restCode.getType() && rc.getComparisonType() == restCode.getComparisonType()).findFirst();
            if (reasonCode.isPresent()) {
                resultCodes.add(reasonCode.get());
                result.add(this.buildReasonCodeResult(ExtApiV2UpdateBookingStatisticStatus.OK, restCode));
                continue;
            }
            result.add(this.buildReasonCodeResult(ExtApiV2UpdateBookingStatisticStatus.FAIL, restCode));
        }
        statData.getReasonCodes().clear();
        statData.getReasonCodes().addAll(resultCodes);
        return result;
    }

    private ExtApiV2ReasonCodeStatusResult buildReasonCodeResult(ExtApiV2UpdateBookingStatisticStatus status, ExtApiV2RestReasonCode reasonCode) {
        ExtApiV2ReasonCodeStatusResult result = new ExtApiV2ReasonCodeStatusResult();
        result.setStatus(status);
        result.setValue(reasonCode);
        return result;
    }

    private ExtApiV2CostCodeStatusResult buildCostCodeResult(ExtApiV2UpdateBookingStatisticStatus status, ExtApiV2ProductCostCode reasonCode) {
        ExtApiV2CostCodeStatusResult result = new ExtApiV2CostCodeStatusResult();
        result.setStatus(status);
        result.setValue(reasonCode);
        return result;
    }
}

