/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.statistic;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2RestReasonCode;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.ExtApiV2BookingHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2OrderValidationMessages;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2ProductCostCode;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2ProductStatistic;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2UpdateBookingStatisticParam;
import com.gridnine.xtrip.server.ibecorp.security.acl.IbePermissionManager;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;

public class ExtApiV2UpdateBookingStatisticValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV2UpdateBookingStatisticParam param = (ExtApiV2UpdateBookingStatisticParam)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer<BookingFile> bookingCtr = this.getBookingContainer(param.getBookingUid());
        ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE, bookingCtr);
        for (ExtApiV2ProductStatistic stat : param.getStatistic()) {
            if (TextUtil.isBlank((String)stat.getProductUid())) {
                stat.getValidationContext().getProductUidValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingUID());
            }
            stat.getUdids().forEach(this::validateUDID);
            stat.getReasonCodes().forEach(this::validateReasonCode);
        }
        if (!ValidationHelper.isValid((Validatable)param)) {
            throw new ValidationException();
        }
    }

    private EntityContainer<BookingFile> getBookingContainer(String bookingUid) throws Exception {
        EntityContainer bookingCtr = EntityStorage.get().load(BookingFile.class, bookingUid);
        if (bookingCtr == null) {
            throw Xeption.forEndUser((String)ExtApiV2OrderValidationMessages.getInvalidOrderUid().getText(), (Object[])new Object[0]);
        }
        boolean granted = IbePermissionManager.isEntityGranted(bookingCtr, StandardRestrictionResourceOperations.EDIT);
        if (!granted) {
            throw Xeption.forEndUser((String)("Permission denied for user " + UserData.get().getCurrentUser()), (Object[])new Object[0]);
        }
        ExtApiV2BookingHelper.checkBookingCustomer((EntityContainer<BookingFile>)bookingCtr);
        return bookingCtr;
    }

    private void validateUDID(ExtApiV2ProductCostCode costCode) {
        if (TextUtil.isBlank((String)costCode.getPassengerUid())) {
            costCode.getValidationContext().getPassengerUidValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingUID());
        }
        if (TextUtil.isBlank((String)costCode.getSabreShortName()) && TextUtil.isBlank((String)costCode.getSabreFullName())) {
            costCode.getValidationContext().getSabreShortNameValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingRequiredField());
            costCode.getValidationContext().getSabreFullNameValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingRequiredField());
        }
        if (TextUtil.isBlank((String)costCode.getValue())) {
            costCode.getValidationContext().getValueValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingRequiredField());
        }
    }

    private void validateReasonCode(ExtApiV2RestReasonCode reasonCode) {
        if (TextUtil.isBlank((String)reasonCode.getCode())) {
            reasonCode.getValidationContext().getCodeValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingRequiredField());
        }
        if (reasonCode.getType() == null) {
            reasonCode.getValidationContext().getTypeValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingRequiredField());
        }
        if (reasonCode.getComparisonType() == null) {
            reasonCode.getValidationContext().getComparisonTypeValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingRequiredField());
        }
    }
}

