/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.updateCorrespondence;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueIndex;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueStatus;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.NotificationEvent;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.Post;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.SimpleIssue;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.HttpHelper;
import com.gridnine.xtrip.common.model.system.ActionSource;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.correspondence.ExtApiV2RestCorrespondenceParameters;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.ExtApiV2BookingValidationHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.correspondence.ExtApiV2RestCorrespondenceMessages;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class ExtApiV2UpdateCorrespondenceProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV2RestCorrespondenceParameters parameters = (ExtApiV2RestCorrespondenceParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        boolean valid = ExtApiV2BookingValidationHelper.validateCorrespondence(parameters);
        if (!valid) {
            throw new ValidationException();
        }
        EntityReference<Person> person = this.getPerson(parameters);
        EntityContainer<BookingFile> bookingFile = this.getBookingFile(parameters);
        if (bookingFile == null) {
            return;
        }
        EntityContainer issueCtr = this.getIssue(parameters);
        if (issueCtr == null) {
            SimpleIssue issue = new SimpleIssue();
            issue.setStatus(IssueStatus.NEW);
            issue.setAuthor(person);
            issue.setBooking(bookingFile.toReference());
            issue.setCreateDate(new Date());
            issue.setClient(((BookingFile)bookingFile.getEntity()).getCustomerProfile());
            issue.setAgency(BookingHelper.getAgency((BookingFile)((BookingFile)bookingFile.getEntity())));
            issue.setSubagency(BookingHelper.getSubagency((BookingFile)((BookingFile)bookingFile.getEntity())));
            issue.setTitle(String.format("\u0412\u043e\u043f\u0440\u043e\u0441 \u043f\u043e \u0437\u0430\u043a\u0430\u0437\u0443 \u2116%s", parameters.getBookingNumber()));
            issue.getEvents().add(NotificationEvent.ISSUE_CREATED);
            issueCtr = EntityStorageHelper.createContainer((BaseEntity)issue, (EntityStorageContext)new EntityStorageContext());
            issue.setCreationSource(ActionSource.EXT_API);
        }
        ((BaseIssue)issueCtr.getEntity()).setUpdateDate(new Date());
        EntityReference issueRfc = issueCtr.toReference();
        Post post = new Post();
        post.setAuthor(person);
        post.setDateCreated(new Date());
        post.setClient(true);
        if (!((BaseIssue)issueCtr.getEntity()).getPosts().isEmpty()) {
            post.setHotelEmail(((Post)CollectionUtil.getLastElement((List)((BaseIssue)issueCtr.getEntity()).getPosts())).getHotelEmail());
        }
        if (TextUtil.nonBlank((String)parameters.getComment())) {
            post.setContent(parameters.getComment());
            ((BaseIssue)issueCtr.getEntity()).getEvents().add(NotificationEvent.COMMENT_ADDED);
        }
        if (!parameters.getAttachments().isEmpty()) {
            post.getAttachments().addAll(parameters.getAttachments().stream().filter(a -> TextUtil.nonBlank((String)a.getName())).map(a -> {
                EntityReference docRfc;
                try {
                    Document doc = new Document();
                    byte[] fileArray = Base64.decode((String)a.getContent());
                    doc.setContent(fileArray);
                    doc.setCreated(new Date());
                    String name = TextUtil.isBlank((String)a.getName()) ? UUIDUtil.toString((UUID)UUID.randomUUID()) : a.getName();
                    doc.setName(name);
                    doc.setDescription(name);
                    doc.setCheckSum(MiscUtil.getCheckSum((byte[])fileArray));
                    doc.setContentType(HttpHelper.detectContentType((String)a.getName()));
                    doc.setNavigationKey(post.getUid());
                    doc.setType(DocumentType.ISSUE_ATTACHMENT);
                    doc.setExternal(true);
                    doc.setOwner(issueRfc);
                    doc.setNavigationKey(post.getUid());
                    EntityContainer docCtr = EntityContainer.create((BaseEntity)doc);
                    docCtr.getVersionInfo().setDataSource("ext-api");
                    EntityStorage.get().save(docCtr, true);
                    docRfc = docCtr.toReference();
                }
                catch (Exception e) {
                    throw Xeption.forEndUser((String)ExtApiV2RestCorrespondenceMessages.getBrokenFile().getText(), (Throwable)e, (Object[])new Object[0]);
                }
                return docRfc;
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        if (!post.getAttachments().isEmpty()) {
            ((BaseIssue)issueCtr.getEntity()).getEvents().add(NotificationEvent.ATTACHMENT_ADDED);
        }
        ((BaseIssue)issueCtr.getEntity()).getPosts().add(post);
        ((BaseIssue)issueCtr.getEntity()).setUnreadPosts(((BaseIssue)issueCtr.getEntity()).getUnreadPosts() + 1);
        issueCtr.getVersionInfo().setDataSource("ext-api");
        EntityStorage.get().save(issueCtr, true);
    }

    private EntityContainer<BaseIssue> getIssue(ExtApiV2RestCorrespondenceParameters parameters) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)IssueIndex.Property.bookingNumber.name(), (Object)parameters.getBookingNumber()));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)IssueIndex.Property.status.name(), (Object)IssueStatus.CLOSED));
        List indices = EntityStorage.get().search(IssueIndex.class, query).getData();
        if (indices.isEmpty()) {
            return null;
        }
        for (IssueIndex index : indices) {
            EntityContainer issue = EntityStorage.get().resolve(index.getSource());
            if (issue == null || !(issue.getEntity() instanceof SimpleIssue)) continue;
            return issue;
        }
        return null;
    }

    private EntityContainer<BookingFile> getBookingFile(ExtApiV2RestCorrespondenceParameters parameters) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BookingFileIndex.Property.fullNumber.name(), (Object)parameters.getBookingNumber()));
        List bookingFileIndices = EntityStorage.get().search(BookingFileIndex.class, query).getData();
        if (bookingFileIndices.isEmpty()) {
            parameters.getValidationContext().getBookingNumberValidationMessages().add(ExtApiV2RestCorrespondenceMessages.getBookingNotFound((String)parameters.getBookingNumber()));
            return null;
        }
        if (bookingFileIndices.size() > 1) {
            parameters.getValidationContext().getBookingNumberValidationMessages().add(ExtApiV2RestCorrespondenceMessages.getSeveralBookingsFound((String)parameters.getBookingNumber()));
        }
        return EntityStorage.get().resolve(((BookingFileIndex)bookingFileIndices.get(0)).getSource());
    }

    private EntityReference<Person> getPerson(ExtApiV2RestCorrespondenceParameters parameters) {
        if (parameters.getPerson() == null || TextUtil.isBlank((String)parameters.getPerson().getEmail()) && TextUtil.isBlank((String)parameters.getPerson().getFirstName()) && TextUtil.isBlank((String)parameters.getPerson().getLastName()) && TextUtil.isBlank((String)parameters.getPerson().getMiddleName()) && TextUtil.isBlank((String)parameters.getPerson().getUid())) {
            return null;
        }
        if (TextUtil.nonBlank((String)parameters.getPerson().getUid())) {
            EntityContainer personCtr = EntityStorage.get().load(Person.class, parameters.getPerson().getUid());
            if (personCtr == null) {
                this.addPersonMessage(parameters, true);
                return null;
            }
            return personCtr.toReference();
        }
        return null;
    }

    private void addPersonMessage(ExtApiV2RestCorrespondenceParameters parameters, boolean notFound) {
        parameters.getValidationContext().getPersonValidationMessages().add(notFound ? ExtApiV2RestCorrespondenceMessages.getPersonNotFound((String)parameters.getPerson().getUid(), (String)TextUtil.combine((char)' ', (String[])new String[]{parameters.getPerson().getLastName(), parameters.getPerson().getFirstName(), parameters.getPerson().getMiddleName()}), (String)parameters.getPerson().getEmail()) : ExtApiV2RestCorrespondenceMessages.getSeveralPersonsFound((String)parameters.getPerson().getUid(), (String)TextUtil.combine((char)' ', (String[])new String[]{parameters.getPerson().getLastName(), parameters.getPerson().getFirstName(), parameters.getPerson().getMiddleName()}), (String)parameters.getPerson().getEmail()));
    }
}

