/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.updateOrder;

import com.gridnine.bof.midoffice.ibus.BookingFileOperationParameters;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.ExtApiV2BookingHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2Order;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2Reservation;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.parsers.helpers.ParsersHelper;
import java.time.LocalDateTime;
import java.util.Iterator;

public class ExtApiV2PrepareOrderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingCtr;
        ExtApiV2Order order = (ExtApiV2Order)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        if (TextUtil.isBlank((String)order.getUid())) {
            BookingFileIndex bookingFile = this.getOrderUidByPnrAndDate(order);
            if (bookingFile == null) {
                bookingCtr = new EntityContainer(BookingFile.class);
            } else {
                bookingCtr = EntityStorage.get().resolve(bookingFile.getSource());
                ExtApiV2BookingHelper.checkBookingCustomer((EntityContainer<BookingFile>)bookingCtr);
            }
        } else {
            bookingCtr = EntityStorage.get().load(BookingFile.class, order.getUid());
            ExtApiV2BookingHelper.checkBookingCustomer((EntityContainer<BookingFile>)bookingCtr);
        }
        ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE, (Object)bookingCtr);
        BookingFileOperationParameters parameters = new BookingFileOperationParameters();
        parameters.setOperationName("extApiV2-rest");
        parameters.setVersionNotes("updateOrder");
        ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_OPERATION_PARAMETERS, (Object)parameters);
    }

    private BookingFileIndex getOrderUidByPnrAndDate(ExtApiV2Order order) {
        for (ExtApiV2Reservation reservation : order.getReservations()) {
            Iterator iterator;
            if (!TextUtil.nonBlank((String)reservation.getRecordLocator())) continue;
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.between((String)BookingFileIndex.Property.createDate.name(), (Object)DateUtils.toJavaDate((LocalDateTime)reservation.getReservationDate().minusDays(1L)), (Object)DateUtils.toJavaDate((LocalDateTime)reservation.getReservationDate().plusDays(1L))));
            if (GdsName.SIRENA == reservation.getGdsName()) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)reservation.getRecordLocator(), (boolean)true), SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)ParsersHelper.translitPnr((String)reservation.getRecordLocator(), (boolean)false), (boolean)true)}));
            } else {
                query.getCriteria().getCriterions().add(SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)reservation.getRecordLocator(), (boolean)true));
            }
            if (!(iterator = EntityStorage.get().search(BookingFileIndex.class, query).getData().iterator()).hasNext()) continue;
            BookingFileIndex searchData = (BookingFileIndex)iterator.next();
            return searchData;
        }
        return null;
    }
}

