/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.updateOrder;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.externalApi.extApiV2.IBusExtApiV2ContextKeys;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2ProductHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseOrder;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseProduct;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class ExtApiV2ProductLockAdvice
extends BaseAdvice {
    public void before(MessageContext ctx) throws Exception {
        ExtApiV2BaseOrder order = (ExtApiV2BaseOrder)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        List products = order.getReservations().stream().flatMap(r -> r.getProducts().stream()).collect(Collectors.toList());
        if (ctx.getObject((Enum)IBusExtApiV2ContextKeys.PRODUCT_LOCKS) != null) {
            throw Xeption.forDeveloper((String)"Lock hierarchy is not supported", (Object[])new Object[0]);
        }
        ArrayList<NamedLock> locks = new ArrayList<NamedLock>();
        ctx.putObject((Enum)IBusExtApiV2ContextKeys.PRODUCT_LOCKS, locks);
        List lockNames = products.stream().map(ExtApiV2ProductLockAdvice::getLockName).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        for (String lockName : lockNames) {
            ExtApiV2ProductLockAdvice.getLock(lockName, locks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(MessageContext ctx) throws Exception {
        List locks = (List)ctx.removeObject((Enum)IBusExtApiV2ContextKeys.PRODUCT_LOCKS);
        if (locks != null) {
            for (NamedLock namedLock : locks) {
                try {
                    namedLock.unlock();
                }
                finally {
                    namedLock.close();
                }
            }
        }
    }

    private static String getLockName(ExtApiV2BaseProduct product) {
        ExtApiV2ProductHandler handler = ExtApiV2ProductHandler.of(product);
        return String.format("EXT_API_V2_PRODUCT_%s_%s_%s_%s", Optional.ofNullable(handler.getRestProductType()).map(Enum::name).orElse(null), Optional.ofNullable(handler.getRestProductStatus(product)).map(Enum::name).orElse(null), Optional.ofNullable(handler.getRestIssueDate(product)).map(LocalDateTime::toLocalDate).orElse(null), handler.getRestSystemNumber(product));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getLock(String lockName, List<NamedLock> locks) throws Exception {
        NamedLock namedLock = LockUtil.getLockManager().getLock((Object)lockName, TimeUnit.MINUTES.toMillis(5L));
        boolean success = false;
        try {
            boolean tryLock = namedLock.tryLock(null, 5L, TimeUnit.MINUTES);
            if (!tryLock) {
                throw Xeption.forDeveloper((String)"Unable to lock {0}", (Object[])new Object[]{lockName});
            }
            locks.add(namedLock);
            success = true;
        }
        finally {
            if (!success) {
                namedLock.close();
            }
        }
    }
}

