/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.updateOrder;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.RailwayBonusCard;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.common.ExtApiV2CommonConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.corporateData.person.ExtApiV2PersonHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2ExternalCode;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2Organization;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2Passport;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2Order;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2Traveller;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExtApiV2UpdateBookingProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        ExtApiV2Order order = (ExtApiV2Order)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE);
        BookingFile bookingFile = (BookingFile)bookingCtr.getEntity();
        HashMap<String, Traveller> travellerMap = new HashMap<String, Traveller>();
        ctx.putObject((Enum)IBusMidofficeContextKeys.TRAVELLERS, travellerMap);
        bookingFile.setAgency(ExtApiV2CommonConverterHelper.findOrganization((ExtApiV2Organization)order.getAgencyProfile()));
        bookingFile.setCustomerProfile(this.getCustomerProfile(order.getClientProfile()));
        bookingFile.setCreateDate(DateUtils.toJavaDate((LocalDateTime)order.getCreateDate()));
        this.updateExternalCodes(order, bookingFile);
        this.updateTravellersData(order, bookingFile, travellerMap);
    }

    private void updateExternalCodes(ExtApiV2Order order, BookingFile bookingFile) {
        bookingFile.getExternalCodes().clear();
        if (order.getExternalCode() != null) {
            bookingFile.getExternalCodes().add(ExtApiV2CommonConverterHelper.convertRest2ExternalSystemCode((ExtApiV2ExternalCode)order.getExternalCode()));
        }
        bookingFile.getExternalCodes().addAll(order.getExternalCodes().stream().map(ExtApiV2CommonConverterHelper::convertRest2ExternalSystemCode).collect(Collectors.toList()));
    }

    private void updateTravellersData(ExtApiV2Order order, BookingFile bookingFile, Map<String, Traveller> travellerMap) {
        ArrayList sourceTravellers = new ArrayList(bookingFile.getTravellers());
        bookingFile.getTravellers().clear();
        for (ExtApiV2Traveller restTraveller : order.getTravellers()) {
            Traveller traveller = sourceTravellers.stream().filter(tr -> MiscUtil.equals((Object)tr.getUid(), (Object)restTraveller.getUid())).findFirst().orElse(new Traveller());
            traveller.setName(restTraveller.getTravellerName());
            traveller.setPassenger(restTraveller.getProfileReference());
            if (restTraveller.getPassport() != null) {
                traveller.setPassport(ExtApiV2PersonHelper.convertRestPassport2Passport((ExtApiV2Passport)restTraveller.getPassport()));
                traveller.setBirthday(traveller.getPassport().getBirthday());
                traveller.setGender(traveller.getPassport().getGender());
            }
            if (restTraveller.getBonusCards() != null) {
                restTraveller.getBonusCards().getAirBonusCards().stream().filter(Objects::nonNull).map(ExtApiV2CommonConverterHelper::convertRest2AirlineBonusCard).forEach(traveller.getAirlineBonusCards()::add);
                traveller.setRailwayBonusCard((RailwayBonusCard)restTraveller.getBonusCards().getRailBonusCards().stream().map(ExtApiV2CommonConverterHelper::convertRest2RailwayBonusCard).findFirst().orElse(null));
            }
            travellerMap.put(restTraveller.getUid(), traveller);
            bookingFile.getTravellers().add(traveller);
        }
    }

    private EntityReference<Organization> getCustomerProfile(ExtApiV2Organization clientProfile) {
        if (clientProfile == null) {
            return null;
        }
        if (TextUtil.nonBlank((String)clientProfile.getKpp()) && TextUtil.nonBlank((String)clientProfile.getInn())) {
            return ExtApiV2CommonConverterHelper.findOrganization((ExtApiV2Organization)clientProfile);
        }
        EntityContainer retailCtr = ProfileHelper.getRetailProfileContainer();
        return retailCtr != null ? retailCtr.toReference() : null;
    }
}

