/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.updateOrder;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2ProductHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseOrder;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseProduct;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ExtApiV2UpdateProductsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV2BaseOrder order = (ExtApiV2BaseOrder)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Map travellersMap = (Map)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        Map productMap = (Map)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        List restProducts = order.getReservations().stream().flatMap(res -> res.getProducts().stream()).collect(Collectors.toList());
        for (ExtApiV2BaseProduct restProduct : restProducts) {
            BaseProduct product = (BaseProduct)productMap.get(restProduct.getUid());
            ProductHandler productHandler = ProductHandler.of((BaseProduct)product);
            if (!ShipmentHelper.hasRelatedShipment((BaseProduct)product) && product.getPrepaymentDocuments().isEmpty()) {
                ExtApiV2ProductHandler.of(product).linkTravellersWithProduct(product, (BaseProduct)restProduct, travellersMap);
            }
            productHandler.setPreviousProduct(product, (BaseProduct)productMap.get(restProduct.getPreviousProductUid()));
            productHandler.setNextProduct(product, (BaseProduct)productMap.get(restProduct.getNextProductUid()));
            productHandler.updateProductFops(product);
        }
    }
}

