/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.updateOrder;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.rules.standard.hotelProductSettings.HotelProductSettingsActionSet;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.model.validation.XtripHotelsValidationMessageType;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.common.ExtApiV2CommonConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2ExternalCode;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2Organization;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.ExtApiV2BookingHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.gdsAccount.ExtApiV2GdsAccountHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.handler.product.ExtApiV2ProductHandler;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseOrder;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseProduct;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2Order;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2Reservation;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHelper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ExtApiV2UpdateReservationsProcessor
extends BaseProcessor {
    private String processName;

    public void configure(Map<String, String> parameters) {
        this.processName = parameters.get("processName");
    }

    public void process(MessageContext ctx) throws Exception {
        ExtApiV2BaseOrder order = (ExtApiV2BaseOrder)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE);
        HashMap<String, BaseProduct> productMap = new HashMap<String, BaseProduct>();
        ctx.putObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS, productMap);
        if ("updateOrder".equals(this.processName)) {
            this.updateReservationsData(order, (EntityContainer<BookingFile>)bookingCtr, productMap);
        } else if ("updateProducts".equals(this.processName)) {
            this.updateProductsData(order, (EntityContainer<BookingFile>)bookingCtr, productMap);
        }
    }

    private void updateReservationsData(ExtApiV2BaseOrder order, EntityContainer<BookingFile> bookingCtr, Map<String, BaseProduct> productMap) {
        BookingFile bookingFile = (BookingFile)bookingCtr.getEntity();
        ArrayList sourceReservations = new ArrayList(bookingFile.getReservations());
        bookingFile.getReservations().clear();
        for (ExtApiV2Reservation restReservation : order.getReservations()) {
            Reservation reservation = sourceReservations.stream().filter(res -> MiscUtil.equals((Object)res.getUid(), (Object)restReservation.getUid())).findFirst().orElse(new Reservation());
            this.updateReservationFromRest(reservation, restReservation, bookingFile, order);
            reservation.getProducts().clear();
            reservation.getProducts().addAll(restReservation.getProducts().stream().map(restProduct -> {
                Object product = ExtApiV2ProductHandler.of(restProduct).fromRest((ExtApiV2BaseProduct)restProduct, bookingCtr.getUid());
                product.setReservation(reservation);
                productMap.put(restProduct.getUid(), (BaseProduct)product);
                if (product instanceof HotelProduct) {
                    try {
                        RuleProxy ruleProxy = HotelRulesHelper.applyHotelProductSettingsRules((HotelProduct)((HotelProduct)product));
                        HotelsHelper.fillContractData((HotelProduct)((HotelProduct)product), (HotelProductSettingsActionSet)((HotelProductSettingsActionSet)ruleProxy.getActionSet()));
                    }
                    catch (Exception e) {
                        ((HotelProduct)product).getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_ERROR_APPLYING_HOTEL_PRODUCT_SETTINGS_RULES));
                    }
                }
                return product;
            }).collect(Collectors.toList()));
            bookingFile.getReservations().add(reservation);
        }
    }

    private void updateProductsData(ExtApiV2BaseOrder order, EntityContainer<BookingFile> bookingCtr, Map<String, BaseProduct> productMap) {
        BookingFile bookingFile = (BookingFile)bookingCtr.getEntity();
        for (ExtApiV2Reservation restReservation : order.getReservations()) {
            Reservation reservation;
            if (TextUtil.nonBlank((String)restReservation.getUid())) {
                reservation = bookingFile.getReservations().stream().filter(res -> MiscUtil.equals((Object)res.getUid(), (Object)restReservation.getUid())).findFirst().orElse(null);
            } else {
                reservation = new Reservation();
                this.updateReservationFromRest(reservation, restReservation, bookingFile, order);
                bookingFile.getReservations().add(reservation);
            }
            if (reservation == null) continue;
            for (ExtApiV2BaseProduct restProduct : restReservation.getProducts()) {
                Object product = ExtApiV2ProductHandler.of(restProduct).fromRest(restProduct, bookingCtr.getUid());
                product.setReservation(reservation);
                reservation.getProducts().removeIf(p -> p.getUid().equals(product.getUid()));
                reservation.getProducts().add(product);
                productMap.put(restProduct.getUid(), (BaseProduct)product);
            }
        }
    }

    private void updateReservationFromRest(Reservation reservation, ExtApiV2Reservation restReservation, BookingFile bookingFile, ExtApiV2BaseOrder order) {
        reservation.setBookingFile(bookingFile);
        this.setRecordLocator(reservation, restReservation.getGdsName(), restReservation.getRecordLocator());
        CommonReservationGdsNameInfoHelper.setBookingPcc((Reservation)reservation, (GdsName)restReservation.getGdsName(), (String)restReservation.getBookingPcc());
        if (order instanceof ExtApiV2Order) {
            reservation.setType(this.getReservationType(((ExtApiV2Order)order).getExternalCode(), ((ExtApiV2Order)order).getExternalCodes()));
        }
        if (restReservation.getGdsAccount() == null) {
            reservation.getGdsNameInfo().setOnlineGdsAccount(null);
        } else if (restReservation.getGdsName() != null) {
            Optional.ofNullable(ExtApiV2GdsAccountHandler.of(restReservation)).ifPresent(handler -> reservation.getGdsNameInfo().setOnlineGdsAccount(handler.fromRest(restReservation)));
        }
        reservation.setResDate(DateUtils.toJavaDate((LocalDateTime)restReservation.getReservationDate()));
        reservation.setSalesPoint(ExtApiV2BookingHelper.findSalesPoint(restReservation.getSalesPointCode()));
        reservation.setSubagency(ExtApiV2CommonConverterHelper.findOrganization((ExtApiV2Organization)restReservation.getSubagency()));
        reservation.setBookingAgent(ExtApiV2BookingHelper.findAgent(restReservation.getBookingAgentReference(), restReservation.getReservationDate()));
    }

    private void setRecordLocator(Reservation reservation, GdsName gdsName, String locator) {
        RecordLocatorType type;
        if (TextUtil.isBlank((String)locator)) {
            return;
        }
        if (gdsName == null) {
            CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, null, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)locator);
            return;
        }
        switch (gdsName) {
            case SIRENA: {
                type = RecordLocatorType.SIRENA_LATIN;
                break;
            }
            case IWAY: {
                type = RecordLocatorType.IWAY_ORDER_ID;
                break;
            }
            case FLY_ARYSTAN: {
                type = RecordLocatorType.FLY_ARYSTAN_ID;
                break;
            }
            case TA_NDC: {
                type = RecordLocatorType.TA_NDC_ORDER_ID;
                break;
            }
            case HOTEL_AGGREGATOR: {
                type = RecordLocatorType.HOTEL_AGGREGATOR_PNR;
                break;
            }
            default: {
                type = RecordLocatorType.DEFAULT;
            }
        }
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)gdsName, (RecordLocatorType)type, (String)locator);
    }

    private ReservationType getReservationType(ExtApiV2ExternalCode externalCode, List<ExtApiV2ExternalCode> externalCodes) {
        if (!externalCodes.isEmpty() && externalCodes.stream().allMatch(extCode -> "RAKETA".equalsIgnoreCase(extCode.getSystem()))) {
            return ReservationType.RAKETA;
        }
        if (externalCode != null && "RAKETA".equalsIgnoreCase(externalCode.getSystem())) {
            return ReservationType.RAKETA;
        }
        return ReservationType.OFFLINE;
    }
}

