/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.updateOrder;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.ExtApiV2BookingValidationHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseOrder;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2Order;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2OrderValidationMessages;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;

public class ExtApiV2ValidateOrderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV2Order order = (ExtApiV2Order)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        if (order.getReservations().isEmpty()) {
            order.getValidationContext().getReservationsValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingReservation());
        }
        if (TextUtil.nonBlank((String)order.getUid())) {
            EntityContainer ctr = EntityStorage.get().load(BookingFile.class, order.getUid());
            if (ctr == null) {
                order.getValidationContext().getUidValidationMessages().add(ExtApiV2OrderValidationMessages.getInvalidOrderUid());
            }
            if (order.getCreateDate() == null) {
                order.getValidationContext().getCreateDateValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingCreateDate());
            }
            if (order.getOrderRevision() == 0) {
                order.getValidationContext().getOrderRevisionValidationMessages().add(ExtApiV2OrderValidationMessages.getInvalidOrderRevision());
            } else if (ctr != null && ctr.getRevision() != (long)order.getOrderRevision()) {
                order.getValidationContext().getOrderRevisionValidationMessages().add(ExtApiV2OrderValidationMessages.getDifferentOrderRevision());
            }
            if (order.getClientProfile() == null) {
                order.getValidationContext().getClientProfileValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingCustomerProfile());
            }
        }
        ExtApiV2BookingValidationHelper.validateTravellers((ExtApiV2BaseOrder)order);
        this.validateReservations(order);
        ExtApiV2BookingValidationHelper.validateProducts((ExtApiV2BaseOrder)order);
        if (!ValidationHelper.isValid((Validatable)order)) {
            throw new ValidationException();
        }
    }

    private void validateReservations(ExtApiV2Order order) {
        order.getReservations().forEach(reservation -> {
            if (ExtApiV2BookingValidationHelper.validateRecordLocator(reservation) && TextUtil.isBlank((String)reservation.getRecordLocator())) {
                reservation.getValidationContext().getRecordLocatorValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingRecordLocator());
            }
            if (ExtApiV2BookingValidationHelper.validateGdsName(reservation) && reservation.getGdsName() == null) {
                reservation.getValidationContext().getGdsNameValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingGdsName());
            }
            if (reservation.getReservationDate() == null) {
                reservation.getValidationContext().getReservationDateValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingReservationDate());
            }
        });
    }
}

