/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.updateProduct;

import com.gridnine.bof.midoffice.ibus.BookingFileOperationParameters;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.RailwayBonusCard;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.common.ExtApiV2CommonConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.corporateData.person.ExtApiV2PersonHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2Passport;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseOrder;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2Traveller;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ExtApiV2PrepareBaseOrderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV2BaseOrder order = (ExtApiV2BaseOrder)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer bookingCtr = EntityStorage.get().load(BookingFile.class, order.getUid());
        ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE, (Object)bookingCtr);
        HashMap<String, Traveller> travellerMap = new HashMap<String, Traveller>();
        this.updateTravellersData(order, (BookingFile)bookingCtr.getEntity(), travellerMap);
        ctx.putObject((Enum)IBusMidofficeContextKeys.TRAVELLERS, travellerMap);
        BookingFileOperationParameters parameters = new BookingFileOperationParameters();
        parameters.setOperationName("extApiV2-rest");
        parameters.setVersionNotes("updateProducts");
        ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_OPERATION_PARAMETERS, (Object)parameters);
    }

    private void updateTravellersData(ExtApiV2BaseOrder order, BookingFile bookingFile, Map<String, Traveller> travellerMap) {
        for (ExtApiV2Traveller restTraveller : order.getTravellers()) {
            Traveller traveller = bookingFile.getTravellers().stream().filter(tr -> MiscUtil.equals((Object)tr.getUid(), (Object)restTraveller.getUid())).findFirst().orElse(null);
            if (traveller == null) {
                traveller = new Traveller();
                traveller.setName(restTraveller.getTravellerName());
                traveller.setPassenger(restTraveller.getProfileReference());
                if (restTraveller.getPassport() != null) {
                    traveller.setPassport(ExtApiV2PersonHelper.convertRestPassport2Passport((ExtApiV2Passport)restTraveller.getPassport()));
                    traveller.setBirthday(traveller.getPassport().getBirthday());
                    traveller.setGender(traveller.getPassport().getGender());
                }
                if (restTraveller.getBonusCards() != null) {
                    restTraveller.getBonusCards().getAirBonusCards().stream().filter(Objects::nonNull).map(ExtApiV2CommonConverterHelper::convertRest2AirlineBonusCard).forEach(traveller.getAirlineBonusCards()::add);
                    traveller.setRailwayBonusCard((RailwayBonusCard)restTraveller.getBonusCards().getRailBonusCards().stream().map(ExtApiV2CommonConverterHelper::convertRest2RailwayBonusCard).findFirst().orElse(null));
                }
                bookingFile.getTravellers().add(traveller);
            }
            travellerMap.put(restTraveller.getUid(), traveller);
        }
    }
}

