/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.updateProduct;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.ExtApiV2BookingHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.booking.ExtApiV2BookingValidationHelper;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseOrder;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2BaseProduct;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2OrderMessages;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2OrderValidationMessages;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.booking.ExtApiV2Reservation;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;

public class ExtApiV2ValidateBaseOrderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV2BaseOrder order = (ExtApiV2BaseOrder)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        if (TextUtil.isBlank((String)order.getUid())) {
            throw Xeption.forEndUser((String)ExtApiV2OrderMessages.getMissingOrderUid().getText(), (Object[])new Object[0]);
        }
        EntityContainer bfCtr = EntityStorage.get().load(BookingFile.class, order.getUid());
        if (bfCtr == null) {
            throw Xeption.forEndUser((String)ExtApiV2OrderMessages.getBookingFileNotFound((String)order.getUid()).getText(), (Object[])new Object[0]);
        }
        ExtApiV2BookingHelper.checkBookingCustomer((EntityContainer<BookingFile>)bfCtr);
        if (order.getReservations().isEmpty()) {
            order.getValidationContext().getReservationsValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingReservation());
        }
        ExtApiV2BookingValidationHelper.validateTravellers(order);
        this.validateReservations(order, (BookingFile)bfCtr.getEntity());
        ExtApiV2BookingValidationHelper.validateProducts(order);
        this.validateProducts(order, (BookingFile)bfCtr.getEntity());
        if (!ValidationHelper.isValid((Validatable)order)) {
            throw new ValidationException();
        }
    }

    private void validateReservations(ExtApiV2BaseOrder order, BookingFile bookingFile) {
        for (ExtApiV2Reservation restReservation : order.getReservations()) {
            if (TextUtil.nonBlank((String)restReservation.getUid()) && bookingFile.getReservations().stream().noneMatch(r -> r.getUid().equals(restReservation.getUid()))) {
                throw Xeption.forEndUser((String)ExtApiV2OrderMessages.getReservationNotFound((String)restReservation.getUid(), (String)bookingFile.getNumber()).getText(), (Object[])new Object[0]);
            }
            if (!TextUtil.isBlank((String)restReservation.getUid())) continue;
            if (ExtApiV2BookingValidationHelper.validateRecordLocator(restReservation) && TextUtil.isBlank((String)restReservation.getRecordLocator())) {
                restReservation.getValidationContext().getRecordLocatorValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingRecordLocator());
            }
            if (ExtApiV2BookingValidationHelper.validateGdsName(restReservation) && restReservation.getGdsName() == null) {
                restReservation.getValidationContext().getGdsNameValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingGdsName());
            }
            if (restReservation.getReservationDate() != null) continue;
            restReservation.getValidationContext().getReservationDateValidationMessages().add(ExtApiV2OrderValidationMessages.getMissingReservationDate());
        }
    }

    private void validateProducts(ExtApiV2BaseOrder order, BookingFile bookingFile) {
        for (ExtApiV2Reservation restReservation : order.getReservations()) {
            for (ExtApiV2BaseProduct restProduct : restReservation.getProducts()) {
                if (!TextUtil.nonBlank((String)restProduct.getUid())) continue;
                BaseProduct product = bookingFile.getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(p -> p.getUid().equals(restProduct.getUid())).findFirst().orElse(null);
                if (product == null) {
                    throw Xeption.forEndUser((String)ExtApiV2OrderMessages.getProductNotFound((String)restProduct.getUid(), (String)bookingFile.getNumber()).getText(), (Object[])new Object[0]);
                }
                if (product.getReservation().getUid().equals(restReservation.getUid())) continue;
                throw Xeption.forEndUser((String)ExtApiV2OrderMessages.getIncorrectResUidForProduct((String)restReservation.getUid(), (String)restProduct.getUid()).getText(), (Object[])new Object[0]);
            }
        }
    }
}

