/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.dictionaries.getCountries;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.externalApi.extApiV2.dictionary.ExtApiV2DictionaryConverterHelper;
import com.gridnine.xtrip.server.externalApi.extApiV2.model.ExtApiV2StandardAutocompleteParams;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.dict.ExtApiV2GetCountriesResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;

public class ExtApiV2GetCountriesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ExtApiV2StandardAutocompleteParams request = (ExtApiV2StandardAutocompleteParams)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        ExtApiV2GetCountriesResult result = new ExtApiV2GetCountriesResult();
        Set countries = TextUtil.isBlank((String)request.getPattern()) ? DictionaryCache.get().getAll(Country.class).values() : DictionaryCache.get().search(Country.class, request.getPattern());
        result.getCountries().addAll(countries.stream().sorted(Comparator.comparing(BaseDictionary::getCode)).limit(request.getLimit() != null ? (long)request.getLimit().intValue() : Integer.MAX_VALUE).map(country -> ExtApiV2DictionaryConverterHelper.convertDictionaryReference2Rest((DictionaryReference)country.toReference())).collect(Collectors.toList()));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

