/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ExternalFinanceDocument;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.DownloadableData;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.finance.DownloadExternalFinanceDocumentParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;

public class DownloadExternalFinanceDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        DownloadExternalFinanceDocumentParameters parameters = (DownloadExternalFinanceDocumentParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        String uid = parameters.getUid();
        if (TextUtil.isBlank((String)uid)) {
            throw Xeption.forEndUser((String)"EXTERNAL_FINANCE_DOCUMENT_UID_MANDATORY", (Object[])new Object[0]);
        }
        EntityContainer documentCtr = EntityStorage.get().load(ExternalFinanceDocument.class, uid);
        if (documentCtr == null) {
            throw Xeption.forEndUser((String)"EXTERNAL_FINANCE_DOCUMENT_WITH_UID_NOT_FOUND", (Object[])new Object[]{uid});
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)DownloadExternalFinanceDocumentProcessor.buildDownloadableData((ExternalFinanceDocument)documentCtr.getEntity()));
    }

    private static DownloadableData buildDownloadableData(ExternalFinanceDocument document) {
        DownloadableData data = new DownloadableData();
        BinaryData content = new BinaryData();
        content.setContentType(document.getContentType());
        content.setData(document.getContent());
        data.setFileName(document.getName());
        data.setContent(content);
        return data;
    }
}

