/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.finance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ExternalFinanceDocumentIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.finance.ExternalFinanceDocument;
import com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.finance.ListExternalFinanceDocumentsParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Date;
import java.util.Optional;
import java.util.stream.Collectors;

public class ListExternalFinanceDocumentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ListExternalFinanceDocumentsParameters parameters = (ListExternalFinanceDocumentsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference<BookingFile> bfRef = ListExternalFinanceDocumentsProcessor.findBookingFile(parameters.getBookingFileNumber());
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ExternalFinanceDocumentIndex.Property.bookingFile.name(), bfRef));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, EntityStorage.get().search(ExternalFinanceDocumentIndex.class, query).getData().stream().map(ListExternalFinanceDocumentsProcessor::buildExternalFinanceDocument).collect(Collectors.toList()));
    }

    private static ExternalFinanceDocument buildExternalFinanceDocument(ExternalFinanceDocumentIndex idx) {
        com.gridnine.xtrip.common.model.finance.ExternalFinanceDocument model = (com.gridnine.xtrip.common.model.finance.ExternalFinanceDocument)EntityStorage.get().resolve(idx.getSource()).getEntity();
        ExternalFinanceDocument rest = new ExternalFinanceDocument();
        rest.setUid(idx.getSource().getUid());
        rest.setDate(DateUtils.toLocalDate((Date)model.getDate()));
        rest.setNumber(model.getNumber());
        rest.setNumberPrefix(model.getNumberPrefix());
        rest.setNumberSuffix(model.getNumberSuffix());
        rest.setCustomerUid((String)Optional.ofNullable(model.getCustomer()).map(EntityReference::getUid).orElse(null));
        rest.setPayerUid((String)Optional.ofNullable(model.getPayer()).map(EntityReference::getUid).orElse(null));
        rest.setContractUid((String)Optional.ofNullable(model.getContract()).map(EntityReference::getUid).orElse(null));
        rest.setCurrency((String)Optional.ofNullable(model.getCurrency()).map(DictionaryReference::getCode).orElse(null));
        rest.setFinanceDocumentType(ListExternalFinanceDocumentsProcessor.convert(model.getFinanceDocumentType()));
        rest.setName(model.getName());
        rest.setTotalAmount(model.getTotalAmount());
        rest.setContentType(model.getContentType());
        rest.setExternalId(model.getExternalId());
        return rest;
    }

    private static EntityReference<BookingFile> findBookingFile(String number) {
        if (number == null) {
            throw Xeption.forEndUser((String)"BOOKING_FILE_NUMBER_MANDATORY", (Object[])new Object[0]);
        }
        EntityReference ref = EntityStorage.get().findReference(BookingFileIndex.class, BookingFileIndex.Property.fullNumber.name(), (Object)number);
        if (ref == null) {
            throw Xeption.forEndUser((String)"BOOKING_FILE_NOT_FOUND", (Object[])new Object[]{number});
        }
        return ref;
    }

    private static com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.finance.FinanceDocumentType convert(FinanceDocumentType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case CORRECTION_DOCUMENT: {
                return com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.finance.FinanceDocumentType.CORRECTION_DOCUMENT;
            }
            case ACCEPTANCE_CERTIFICATE: {
                return com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.finance.FinanceDocumentType.ACCEPTANCE_CERTIFICATE;
            }
            case INVOICE: {
                return com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.finance.FinanceDocumentType.INVOICE;
            }
            case INVOICE_CONSOLIDATED: {
                return com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.finance.FinanceDocumentType.INVOICE_CONSOLIDATED;
            }
            case INVOICE_FACTURA: {
                return com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.finance.FinanceDocumentType.INVOICE_FACTURA;
            }
            case INVOICE_PREPAYMENT: {
                return com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.finance.FinanceDocumentType.INVOICE_PREPAYMENT;
            }
            case UNIVERSAL_DOCUMENT: {
                return com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.finance.FinanceDocumentType.UNIVERSAL_DOCUMENT;
            }
            case STANDARD_BILL: {
                return com.gridnine.xtrip.server.ibecorp.externalApi.extApiV2.model.finance.FinanceDocumentType.STANDARD_BILL;
            }
        }
        throw Xeption.forDeveloper((String)"unsupported type {0}", (Object[])new Object[]{type.name()});
    }
}

